/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.util;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

final class ARCryptoClient {
    private static final int PASSWORD_CHAR_ENCRYPTED_SIZE = 120;
    private static final int AR_MAX_HASH_SIZE = 28;
    private static final int AR_MAX_SHA_256_HASH_SIZE = 67;
    private static final int IDX0 = 0;
    private static final int IDX1 = 1;
    private static final int IDX3 = 3;
    private static final Logger logger = Logger.getLogger("AREgcpUtil");

    ARCryptoClient() {
    }

    String ECPUtil(String str) {
        return this.encrypt(str, 1);
    }

    String GCPUtil(String str) {
        if (str != null && str.length() == 120) {
            str = this.decrypt(str, 1);
        }
        return this.mangle(User.MT, str);
    }

    String GCPUtil_ext(String str) {
        if (str != null && str.length() == 120) {
            str = this.decrypt(str, 1);
        }
        return this.mangle(User.MT, str, false);
    }

    String GCEUtil(String str) {
        if (str != null && str.length() == 120) {
            str = this.decrypt(str, 0);
        }
        return str;
    }

    String HCPUtil(String str) {
        byte[] bts = this.hashPassword(str.getBytes());
        if (bts != null) {
            return new String(bts);
        }
        return null;
    }

    String GCPUtilDso(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.mangle(User.DS, str);
        }
        return null;
    }

    String GCPUtilDso_ext(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.mangle(User.DS, str, false);
        }
        return null;
    }

    String GCEUtilDso(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.mangle(User.DS, str);
        }
        return null;
    }

    String GCEUtilDso_ext(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.mangle(User.DS, str, false);
        }
        return null;
    }

    String GCPUtilApp(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 1);
            }
            return this.mangle(User.RA, str);
        }
        return null;
    }

    String GCPUtilApp_ext(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 1);
            }
            return this.mangle(User.RA, str, false);
        }
        return null;
    }

    String GCEUtilApp(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.mangle(User.RA, str);
        }
        return null;
    }

    String GCEUtilApp_ext(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.mangle(User.RA, str, false);
        }
        return null;
    }

    boolean CCPUtilApp(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        if (str2.length() == 120) {
            str2 = this.decrypt(str2, 1);
        }
        return str1.equals(str2);
    }

    String GCXPUtil(String str) {
        if (str != null) {
            byte[] bts = str.getBytes();
            if (!(str.length() == 28 || str.length() == 67 && str.startsWith("a$"))) {
                bts = this.hashPassword(bts);
            }
            return this.encrypt(bts, 3);
        }
        return null;
    }

    String GCXEUtil(String str) {
        if (str != null) {
            if (str.length() == 120) {
                str = this.decrypt(str, 0);
            }
            return this.encrypt(str, 3);
        }
        return null;
    }

    private byte[] hashPassword(byte[] bts) {
        try {
            Class<?> cls = Class.forName("com.bmc.arsys.arencrypt.PasswordFieldEncryption");
            Object obj = cls.getConstructor(Boolean.TYPE).newInstance(false);
            byte[] bt = (byte[])cls.getDeclaredMethod("hashPassword", byte[].class).invoke(obj, new Object[]{bts});
            return bt;
        }
        catch (Exception ex) {
            logger.debug("Error:", ex);
            return null;
        }
    }

    private String mangle(User mt, String str) {
        return this.mangle(mt, str, true);
    }

    private String mangle(User usr, String str, boolean isXOR) {
        StringBuilder sb = new StringBuilder();
        String reverseStr = null;
        StringBuilder newPassword = new StringBuilder();
        switch (usr) {
            case RA: {
                sb.append("R!APp@Svc#");
                break;
            }
            case DS: {
                sb.append("Distributed! Server!");
                break;
            }
            case MT: {
                sb.append("Mid-Tier!#Service!");
                break;
            }
            case PL: {
                sb.append("Plug-inMsg$Alert$");
                break;
            }
            default: {
                logger.debug("No match to Mangle!");
            }
        }
        if (str != null && str.length() <= 30) {
            if (str.length() == 30) {
                str = str.substring(0, str.length() - 1);
            }
            reverseStr = new StringBuilder(str).reverse().toString();
            if (isXOR && sb != null && reverseStr.length() > 29 - sb.length()) {
                int count = reverseStr.length() - (30 - sb.length()) + 1;
                newPassword = new StringBuilder(sb.substring(0, sb.length() - count));
                int i = sb.length() - count;
                for (int j = 0; j < count; ++j) {
                    newPassword.append((char)(sb.charAt(i) ^ reverseStr.charAt(j)));
                    ++i;
                }
                newPassword.append(reverseStr.substring(count));
            } else {
                newPassword = sb;
                newPassword.append(new StringBuilder(str).reverse().toString());
            }
        } else {
            newPassword = sb;
        }
        return newPassword.toString();
    }

    private String encrypt(byte[] bts, int idx) {
        if (bts != null) {
            try {
                Class<?> cls = Class.forName("com.bmc.arsys.arencrypt.PasswordEncryption");
                byte[] bt = (byte[])cls.getDeclaredMethod("encryptPasswordEx", byte[].class).invoke(this.getPE(cls, idx), new Object[]{bts});
                return new String(bt);
            }
            catch (Exception ex) {
                logger.debug("Error:", ex);
            }
        }
        return null;
    }

    private String encrypt(String str, int idx) {
        if (str != null) {
            return this.encrypt(str.getBytes(), idx);
        }
        return null;
    }

    private String decrypt(String str, int idx) {
        if (str != null) {
            try {
                Class<?> cls = Class.forName("com.bmc.arsys.arencrypt.PasswordEncryption");
                byte[] bt = (byte[])cls.getDeclaredMethod("decryptPasswordEx", byte[].class).invoke(this.getPE(cls, idx), new Object[]{str.getBytes()});
                return new String(bt);
            }
            catch (Exception ex) {
                logger.debug("Error:", ex);
            }
        }
        return null;
    }

    private Object getPE(Class cls, int idx) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return cls.getConstructor(Integer.TYPE, Boolean.TYPE).newInstance(idx, false);
    }

    String funcE(String str, String token) {
        String rtn = null;
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            try {
                Class<?> cls = Class.forName("com.bmc.arsys.arencrypt.PaddedPasswordEncryption");
                Object obj = cls.getConstructor(Boolean.TYPE, Boolean.TYPE).newInstance(true, false);
                cls.getDeclaredMethod("setPasswordKeyForEncryption", byte[].class).invoke(obj, new Object[]{token.getBytes()});
                byte[] bt = (byte[])cls.getMethod("encryptCharData", byte[].class).invoke(obj, new Object[]{str.getBytes()});
                rtn = new String(bt);
            }
            catch (Exception ex) {
                logger.debug("funcE Error:", ex);
            }
        }
        return rtn;
    }

    String funcD(String str, String token) {
        String rtn = null;
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            try {
                Class<?> cls = Class.forName("com.bmc.arsys.arencrypt.PaddedPasswordEncryption");
                Object obj = cls.getConstructor(Boolean.TYPE, Boolean.TYPE).newInstance(true, false);
                cls.getDeclaredMethod("setPasswordKeyForEncryption", byte[].class).invoke(obj, new Object[]{token.getBytes()});
                byte[] bt = (byte[])cls.getMethod("decryptCharData", byte[].class).invoke(obj, new Object[]{str.getBytes()});
                rtn = new String(bt);
            }
            catch (Exception ex) {
                logger.debug("funcD Error:", ex);
            }
        }
        return rtn;
    }

    public String Pre7Util(int s, String str30Bytes) {
        if (str30Bytes != null) {
            try {
                Class<?> cls = Class.forName("com.bmc.arsys.arencrypt.PasswordPre12Encryption");
                Class[] args1 = new Class[]{Integer.TYPE, String.class};
                Object[] arglist = new Object[]{s, str30Bytes};
                Object obj = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                return (String)cls.getDeclaredMethod("pre12decryptPassword", args1).invoke(obj, arglist);
            }
            catch (Exception ex) {
                logger.debug("Error:", ex);
            }
        }
        return null;
    }

    private static enum User {
        RA,
        MT,
        DS,
        PL;

    }
}

