/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.io.ByteArrayOutputStream;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    final MessageDigestAlgorithm mda;
    static Log log = LogFactory.getLog(DigesterOutputStream.class.getName());

    public DigesterOutputStream(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.mda = messageDigestAlgorithm;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) {
        this.mda.update((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (log.isDebugEnabled()) {
            log.debug("Pre-digested input:");
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            log.debug(stringBuffer.toString());
        }
        this.mda.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

