/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.util;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.ws.security.SOAP11Constants;
import org.apache.ws.security.SOAP12Constants;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.StringUtil;
import org.apache.xml.security.algorithms.JCEMapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WSSecurityUtil {
    private static Log log = LogFactory.getLog(class$org$apache$ws$security$util$WSSecurityUtil == null ? (class$org$apache$ws$security$util$WSSecurityUtil = WSSecurityUtil.class$("org.apache.ws.security.util.WSSecurityUtil")) : class$org$apache$ws$security$util$WSSecurityUtil);
    private static SecureRandom random = null;
    private static String randomAlgorithm = null;
    static /* synthetic */ Class class$org$apache$ws$security$util$WSSecurityUtil;

    public static Element getSecurityHeader(Document doc, String actor, SOAPConstants sc) {
        Element soapHeaderElement = (Element)WSSecurityUtil.getDirectChild(doc.getDocumentElement(), sc.getHeaderQName().getLocalPart(), sc.getEnvelopeURI());
        if (soapHeaderElement == null) {
            return null;
        }
        NodeList list = soapHeaderElement.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.getLength(); ++i) {
            String hActor;
            Element elem = (Element)list.item(i);
            Attr attr = elem.getAttributeNodeNS(sc.getEnvelopeURI(), sc.getRoleAttributeQName().getLocalPart());
            String string = hActor = attr != null ? attr.getValue() : null;
            if (!WSSecurityUtil.isActorEqual(actor, hActor)) continue;
            return elem;
        }
        return null;
    }

    public static boolean isActorEqual(String actor, String hActor) {
        if (!(hActor != null && hActor.length() != 0 || actor != null && actor.length() != 0)) {
            return true;
        }
        return hActor != null && actor != null && hActor.equalsIgnoreCase(actor);
    }

    public static Node getDirectChild(Node fNode, String localName, String namespace) {
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            return currentChild;
        }
        return null;
    }

    public static Element getDirectChildElement(Node fNode, String localName, String namespace) {
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType() || !localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public static Element findBodyElement(Document doc, SOAPConstants sc) {
        Element soapBodyElement = (Element)WSSecurityUtil.getDirectChild(doc.getFirstChild(), sc.getBodyQName().getLocalPart(), sc.getEnvelopeURI());
        return soapBodyElement;
    }

    public static Node findElement(Node startNode, String name, String namespace) {
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            if (startNode.getNodeType() == 1 && startNode.getLocalName().equals(name)) {
                String ns = startNode.getNamespaceURI();
                if (ns != null && ns.equals(namespace)) {
                    return startNode;
                }
                if (!(namespace != null && namespace.length() != 0 || ns != null && ns.length() != 0)) {
                    return startNode;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return null;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return null;
    }

    public static Element findSAMLAssertionElementById(Node startNode, String value) {
        Element foundElement = null;
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            Element se;
            if (startNode.getNodeType() == 1 && ((se = (Element)startNode).hasAttribute("ID") && value.equals(se.getAttribute("ID")) || se.hasAttribute("AssertionID") && value.equals(se.getAttribute("AssertionID")))) {
                if (foundElement == null) {
                    foundElement = se;
                } else {
                    log.warn("Multiple elements with the same 'ID' attribute value!");
                    return null;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static Element findElementById(Node startNode, String value, String namespace) {
        Element foundElement = null;
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            Element se;
            if (startNode.getNodeType() == 1 && (se = (Element)startNode).hasAttributeNS(namespace, "Id") && value.equals(se.getAttributeNS(namespace, "Id"))) {
                if (foundElement == null) {
                    foundElement = se;
                } else {
                    log.warn("Multiple elements with the same 'Id' attribute value!");
                    return null;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static String setNamespace(Element element, String namespace, String prefix) {
        String pre = WSSecurityUtil.getPrefixNS(namespace, element);
        if (pre != null) {
            return pre;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        return prefix;
    }

    public static String getPrefixNS(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring(6);
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = null;
            attr = prefix == null ? ((Element)e).getAttributeNode("xmlns") : ((Element)e).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, false);
    }

    public static QName getFullQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, true);
    }

    private static QName getQNameFromString(String str, Node e, boolean defaultNS) {
        String ns;
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns2 = WSSecurityUtil.getNamespace(prefix, e);
            if (ns2 == null) {
                return null;
            }
            return new QName(ns2, str.substring(idx + 1));
        }
        if (defaultNS && (ns = WSSecurityUtil.getNamespace(null, e)) != null) {
            return new QName(ns, str);
        }
        return new QName("", str);
    }

    public static String getStringForQName(QName qname, Element e) {
        String uri = qname.getNamespaceURI();
        String prefix = WSSecurityUtil.getPrefixNS(uri, e);
        if (prefix == null) {
            int i = 1;
            prefix = "ns" + i;
            while (WSSecurityUtil.getNamespace(prefix, e) != null) {
                prefix = "ns" + ++i;
            }
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        return prefix + ":" + qname.getLocalPart();
    }

    public static Element getElementByWsuId(Document doc, String id) {
        if (id == null) {
            return null;
        }
        id = WSSecurityUtil.getIDFromReference(id);
        return WSSecurityUtil.findElementById(doc.getDocumentElement(), id, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
    }

    public static String getIDFromReference(String ref) {
        String id = ref.trim();
        if (id.length() == 0) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        return id;
    }

    public static String getIDfromReference(String ref) {
        return WSSecurityUtil.getIDFromReference(ref);
    }

    public static Element getElementByGenId(Document doc, String id) {
        if (id == null) {
            return null;
        }
        id = WSSecurityUtil.getIDFromReference(id);
        return WSSecurityUtil.findElementById(doc.getDocumentElement(), id, null);
    }

    private static Element createElementInSameNamespace(Element parent, String localName) {
        String qName = localName;
        String prefix = parent.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            qName = prefix + ":" + localName;
        }
        String nsUri = parent.getNamespaceURI();
        return parent.getOwnerDocument().createElementNS(nsUri, qName);
    }

    private static Element findChildElement(Element parent, String namespaceUri, String localName) {
        NodeList children = parent.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Element elementChild;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !namespaceUri.equals((elementChild = (Element)child).getNamespaceURI()) || !localName.equals(elementChild.getLocalName())) continue;
            return elementChild;
        }
        return null;
    }

    public static Element appendChildElement(Document doc, Element parent, Element child) {
        Text whitespaceText = doc.createTextNode("\n");
        parent.appendChild(whitespaceText);
        parent.appendChild(child);
        return child;
    }

    public static Element prependChildElement(Element parent, Element child) {
        Node firstChild = parent.getFirstChild();
        if (firstChild == null) {
            return (Element)parent.appendChild(child);
        }
        return (Element)parent.insertBefore(child, firstChild);
    }

    public static Element prependChildElement(Document doc, Element parent, Element child, boolean addWhitespace) {
        Node firstChild = parent.getFirstChild();
        Node addedChild = firstChild == null ? parent.appendChild(child) : parent.insertBefore(child, firstChild);
        if (addWhitespace) {
            Text whitespaceText = doc.createTextNode("\n");
            parent.insertBefore(whitespaceText, addedChild);
        }
        return (Element)addedChild;
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, boolean doCreate) {
        return WSSecurityUtil.findWsseSecurityHeaderBlock(doc, envelope, null, doCreate);
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, String actor, boolean doCreate) {
        SOAPConstants sc = WSSecurityUtil.getSOAPConstants(envelope);
        Element wsseSecurity = WSSecurityUtil.getSecurityHeader(doc, actor, sc);
        if (wsseSecurity != null) {
            return wsseSecurity;
        }
        Element header = WSSecurityUtil.findChildElement(envelope, sc.getEnvelopeURI(), sc.getHeaderQName().getLocalPart());
        if (header == null && doCreate) {
            header = WSSecurityUtil.createElementInSameNamespace(envelope, sc.getHeaderQName().getLocalPart());
            header = WSSecurityUtil.prependChildElement(envelope, header);
        }
        if (doCreate) {
            wsseSecurity = header.getOwnerDocument().createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            wsseSecurity.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            return WSSecurityUtil.prependChildElement(header, wsseSecurity);
        }
        return null;
    }

    public static Text createBase64EncodedTextNode(Document doc, byte[] data) {
        return doc.createTextNode(Base64.encode(data));
    }

    public static SecretKey prepareSecretKey(String symEncAlgo, byte[] rawKey) {
        SecretKeySpec keySpec = new SecretKeySpec(rawKey, JCEMapper.getJCEKeyAlgorithmFromURI(symEncAlgo));
        return keySpec;
    }

    public static SOAPConstants getSOAPConstants(Element startElement) {
        Document doc = startElement.getOwnerDocument();
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(ns)) {
            return new SOAP12Constants();
        }
        return new SOAP11Constants();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Cipher getCipherInstance(String cipherAlgo) throws WSSecurityException {
        String jceid = JCEMapper.translateURItoJCEID(cipherAlgo);
        Cipher cipher = null;
        try {
            if (jceid != null) return Cipher.getInstance(jceid);
            if (cipherAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#rsa-1_5")) {
                return Cipher.getInstance("RSA/NONE/PKCS1PADDING");
            }
            if (!cipherAlgo.equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{cipherAlgo});
            return Cipher.getInstance("RSA/NONE/OAEPPADDING");
        }
        catch (NoSuchPaddingException ex) {
            throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such padding: " + cipherAlgo}, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(2, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo}, ex);
        }
    }

    public static WSSecurityEngineResult fetchActionResult(Vector wsResultVector, int action) {
        WSSecurityEngineResult wsResult = null;
        for (int i = 0; i < wsResultVector.size(); ++i) {
            WSSecurityEngineResult result = (WSSecurityEngineResult)wsResultVector.get(i);
            int resultAction = (Integer)result.get("action");
            if (resultAction != action) continue;
            wsResult = (WSSecurityEngineResult)wsResultVector.get(i);
        }
        return wsResult;
    }

    public static Vector fetchAllActionResults(Vector wsResultVector, int action, Vector results) {
        for (int i = 0; i < wsResultVector.size(); ++i) {
            WSSecurityEngineResult result = (WSSecurityEngineResult)wsResultVector.get(i);
            int resultAction = (Integer)result.get("action");
            if (resultAction != action) continue;
            results.add(wsResultVector.get(i));
        }
        return results;
    }

    public static int decodeAction(String action, Vector actions2) throws WSSecurityException {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions2.add(new Integer(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions2.add(new Integer(2));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions2.add(new Integer(4));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions2.add(new Integer(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions2.add(new Integer(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions2.add(new Integer(32));
                continue;
            }
            if (single[i].equals("NoSerialization")) {
                doAction |= 0x100;
                actions2.add(new Integer(256));
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions2.add(new Integer(64));
                continue;
            }
            if (single[i].equals("enableSignatureConfirmation")) {
                doAction |= 0x80;
                actions2.add(new Integer(128));
                continue;
            }
            throw new WSSecurityException("Unknown action defined: " + single[i]);
        }
        return doAction;
    }

    public static int decodeAction(String action, Vector actions2, WSSConfig wssConfig) throws WSSecurityException {
        int doAction = 0;
        if (action == null) {
            return doAction;
        }
        String[] single = StringUtil.split(action, ' ');
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                doAction = 0;
                return doAction;
            }
            if (single[i].equals("UsernameToken")) {
                doAction |= 1;
                actions2.add(new Integer(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                doAction |= 2;
                actions2.add(new Integer(2));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                doAction |= 4;
                actions2.add(new Integer(4));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                doAction |= 8;
                actions2.add(new Integer(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                doAction |= 0x10;
                actions2.add(new Integer(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                doAction |= 0x20;
                actions2.add(new Integer(32));
                continue;
            }
            if (single[i].equals("NoSerialization")) {
                doAction |= 0x100;
                actions2.add(new Integer(256));
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                doAction |= 0x40;
                actions2.add(new Integer(64));
                continue;
            }
            if (single[i].equals("enableSignatureConfirmation")) {
                doAction |= 0x80;
                actions2.add(new Integer(128));
                continue;
            }
            try {
                int parsedAction = Integer.parseInt(single[i]);
                if (wssConfig.getAction(parsedAction) == null) {
                    throw new WSSecurityException("Unknown action defined: " + single[i]);
                }
                actions2.add(new Integer(parsedAction));
                continue;
            }
            catch (NumberFormatException ex) {
                throw new WSSecurityException("Unknown action defined: " + single[i]);
            }
        }
        return doAction;
    }

    public static int getKeyLength(String algorithm) throws WSSecurityException {
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return 16;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc")) {
            return 24;
        }
        if (algorithm.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return 32;
        }
        if ("http://www.w3.org/2000/09/xmldsig#hmac-sha1".equals(algorithm)) {
            return 20;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256".equals(algorithm)) {
            return 32;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384".equals(algorithm)) {
            return 48;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512".equals(algorithm)) {
            return 64;
        }
        if ("http://www.w3.org/2001/04/xmldsig-more#hmac-md5".equals(algorithm)) {
            return 16;
        }
        throw new WSSecurityException(2, null, null, null);
    }

    public static byte[] generateNonce(int length) throws WSSecurityException {
        try {
            SecureRandom r = WSSecurityUtil.resolveSecureRandom();
            if (r == null) {
                throw new WSSecurityException("Random generator is not initialized.");
            }
            byte[] temp = new byte[length];
            r.nextBytes(temp);
            return temp;
        }
        catch (Exception e) {
            throw new WSSecurityException("Error in generating nonce of length " + length, e);
        }
    }

    public static X509Certificate ensureSignedTogether(Iterator results, Element[] elements) throws WSSecurityException {
        log.debug("ensureSignedTogether()");
        if (results == null) {
            throw new IllegalArgumentException("No results vector");
        }
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("No elements to check!");
        }
        String[] requiredIDs = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            Element e = elements[i];
            if (e == null) {
                throw new IllegalArgumentException("elements[" + i + "] is null!");
            }
            requiredIDs[i] = e.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
            if (requiredIDs[i] == null) {
                throw new WSSecurityException(6, "requiredElementNoID", new Object[]{e.getNodeName()});
            }
            log.debug("Required element " + e.getNodeName() + " has wsu:Id " + requiredIDs[i]);
        }
        WSSecurityException fault = null;
        while (results.hasNext()) {
            WSHandlerResult result = (WSHandlerResult)results.next();
            Iterator actions2 = result.getResults().iterator();
            while (actions2.hasNext()) {
                WSSecurityEngineResult resultItem = (WSSecurityEngineResult)actions2.next();
                int resultAction = (Integer)resultItem.get("action");
                if (resultAction != 2) continue;
                try {
                    WSSecurityUtil.checkSignsAllElements(resultItem, requiredIDs);
                    return (X509Certificate)resultItem.get("x509-certificate");
                }
                catch (WSSecurityException ex) {
                    log.debug("SIGN result does not sign all required elements", ex);
                    fault = ex;
                }
            }
        }
        if (fault != null) {
            throw fault;
        }
        throw new WSSecurityException(6, "noSignResult");
    }

    private static void checkSignsAllElements(WSSecurityEngineResult resultItem, String[] requiredIDs) throws WSSecurityException {
        int resultAction = (Integer)resultItem.get("action");
        if (resultAction != 2) {
            throw new IllegalArgumentException("Not a SIGN result");
        }
        Set sigElems = (Set)resultItem.get("signed-element-ids");
        if (sigElems == null) {
            throw new RuntimeException("Missing signedElements set in WSSecurityEngineResult!");
        }
        log.debug("Found SIGN result...");
        Iterator i = sigElems.iterator();
        while (i.hasNext()) {
            Object sigElement = i.next();
            if (sigElement instanceof String) {
                log.debug("Signature includes element with ID " + sigElement);
                continue;
            }
            log.debug("Signature includes element with null uri " + sigElement.toString());
        }
        log.debug("Checking required elements are in the signature...");
        for (int i2 = 0; i2 < requiredIDs.length; ++i2) {
            if (!sigElems.contains(requiredIDs[i2])) {
                throw new WSSecurityException(6, "requiredElementNotSigned", new Object[]{requiredIDs[i2]});
            }
            log.debug("Element with ID " + requiredIDs[i2] + " was correctly signed");
        }
        log.debug("All required elements are signed");
    }

    public static SecureRandom resolveSecureRandom() throws NoSuchAlgorithmException {
        return WSSecurityUtil.resolveSecureRandom("SHA1PRNG");
    }

    public static synchronized SecureRandom resolveSecureRandom(String algorithm) throws NoSuchAlgorithmException {
        if (random == null || !algorithm.equals(randomAlgorithm)) {
            random = SecureRandom.getInstance(algorithm);
            randomAlgorithm = algorithm;
            random.setSeed(System.currentTimeMillis());
        }
        return random;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

