/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.saml;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Properties;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.util.Loader;

public abstract class SAMLIssuerFactory {
    private static final Log log = LogFactory.getLog(class$org$apache$ws$security$saml$SAMLIssuerFactory == null ? (class$org$apache$ws$security$saml$SAMLIssuerFactory = SAMLIssuerFactory.class$("org.apache.ws.security.saml.SAMLIssuerFactory")) : class$org$apache$ws$security$saml$SAMLIssuerFactory);
    private static final boolean doDebug = log.isDebugEnabled();
    private static final String defaultSAMLClassName = "org.apache.ws.security.saml.SAMLIssuerImpl";
    static /* synthetic */ Class class$org$apache$ws$security$saml$SAMLIssuerFactory;
    static /* synthetic */ Class class$java$util$Properties;

    public static SAMLIssuer getInstance() {
        return SAMLIssuerFactory.getInstance("saml.properties");
    }

    public static SAMLIssuer getInstance(String samlClassName, Properties properties) {
        return SAMLIssuerFactory.loadClass(samlClassName, properties);
    }

    public static SAMLIssuer getInstance(String propFilename) {
        Properties properties = null;
        String samlClassName = null;
        if (samlClassName == null || samlClassName.length() == 0) {
            properties = SAMLIssuerFactory.getProperties(propFilename);
            samlClassName = properties.getProperty("org.apache.ws.security.saml.issuerClass", defaultSAMLClassName);
        }
        return SAMLIssuerFactory.loadClass(samlClassName, properties);
    }

    private static SAMLIssuer loadClass(String samlClassName, Properties properties) {
        Class samlIssuerClass = null;
        SAMLIssuer samlIssuer = null;
        try {
            samlIssuerClass = Loader.loadClass(samlClassName);
        }
        catch (ClassNotFoundException ex) {
            if (log.isDebugEnabled()) {
                log.debug(ex.getMessage(), ex);
            }
            throw new RuntimeException(samlClassName + " Not Found", ex);
        }
        log.info("Using Crypto Engine [" + samlClassName + "]");
        try {
            Class[] classes = new Class[]{class$java$util$Properties == null ? (class$java$util$Properties = SAMLIssuerFactory.class$("java.util.Properties")) : class$java$util$Properties};
            Constructor c = samlIssuerClass.getConstructor(classes);
            samlIssuer = (SAMLIssuer)c.newInstance(properties);
            return samlIssuer;
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug(ex.getMessage(), ex);
            }
            try {
                samlIssuer = (SAMLIssuer)samlIssuerClass.newInstance();
                return samlIssuer;
            }
            catch (Exception ex2) {
                if (log.isDebugEnabled()) {
                    log.debug(ex2.getMessage(), ex2);
                }
                throw new RuntimeException(samlClassName + " cannot create instance", ex2);
            }
        }
    }

    private static Properties getProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
        }
        catch (Exception e) {
            if (doDebug) {
                log.debug("Cannot find SAML property file: " + propFilename, e);
            }
            throw new RuntimeException("SAMLIssuerFactory: Cannot load properties: " + propFilename, e);
        }
        return properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

