/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.discovery.tools;

import com.bmc.thirdparty.org.apache.commons.discovery.DiscoveryException;
import com.bmc.thirdparty.org.apache.commons.discovery.jdk.JDKHooks;
import com.bmc.thirdparty.org.apache.commons.discovery.resource.ClassLoaders;
import com.bmc.thirdparty.org.apache.commons.discovery.tools.DefaultClassHolder;
import com.bmc.thirdparty.org.apache.commons.discovery.tools.DiscoverClass;
import com.bmc.thirdparty.org.apache.commons.discovery.tools.EnvironmentCache;
import com.bmc.thirdparty.org.apache.commons.discovery.tools.PropertiesHolder;
import com.bmc.thirdparty.org.apache.commons.discovery.tools.SPInterface;
import java.util.HashMap;
import java.util.Properties;

public class DiscoverSingleton {
    public static Object find(Class spiClass) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(spiClass), DiscoverClass.nullProperties, DiscoverClass.nullDefaultImpl);
    }

    public static Object find(Class spiClass, Properties properties) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(spiClass), new PropertiesHolder(properties), DiscoverClass.nullDefaultImpl);
    }

    public static Object find(Class spiClass, String defaultImpl) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(spiClass), DiscoverClass.nullProperties, new DefaultClassHolder(defaultImpl));
    }

    public static Object find(Class spiClass, Properties properties, String defaultImpl) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(spiClass), new PropertiesHolder(properties), new DefaultClassHolder(defaultImpl));
    }

    public static Object find(Class spiClass, String propertiesFileName, String defaultImpl) throws DiscoveryException {
        return DiscoverSingleton.find(null, new SPInterface(spiClass), new PropertiesHolder(propertiesFileName), new DefaultClassHolder(defaultImpl));
    }

    public static Object find(ClassLoaders loaders, SPInterface spi, PropertiesHolder properties, DefaultClassHolder defaultImpl) throws DiscoveryException {
        ClassLoader contextLoader = JDKHooks.getJDKHooks().getThreadContextClassLoader();
        Object obj = DiscoverSingleton.get(contextLoader, spi.getSPName());
        if (obj == null) {
            try {
                obj = DiscoverClass.newInstance(loaders, spi, properties, defaultImpl);
                if (obj != null) {
                    DiscoverSingleton.put(contextLoader, spi.getSPName(), obj);
                }
            }
            catch (DiscoveryException de) {
                throw de;
            }
            catch (Exception e) {
                throw new DiscoveryException("Unable to instantiate implementation class for " + spi.getSPName(), e);
            }
        }
        return obj;
    }

    public static synchronized void release() {
        EnvironmentCache.release();
    }

    public static synchronized void release(Class spiClass) {
        HashMap spis = (HashMap)EnvironmentCache.get(JDKHooks.getJDKHooks().getThreadContextClassLoader());
        if (spis != null) {
            spis.remove(spiClass.getName());
        }
    }

    private static synchronized Object get(ClassLoader classLoader, String spiName) {
        HashMap spis = (HashMap)EnvironmentCache.get(classLoader);
        return spis != null ? spis.get(spiName) : null;
    }

    private static synchronized void put(ClassLoader classLoader, String spiName, Object service) {
        if (service != null) {
            HashMap<String, Object> spis = (HashMap<String, Object>)EnvironmentCache.get(classLoader);
            if (spis == null) {
                spis = new HashMap<String, Object>(13);
                EnvironmentCache.put(classLoader, spis);
            }
            spis.put(spiName, service);
        }
    }
}

