/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.discovery.log;

import com.bmc.thirdparty.org.apache.commons.discovery.DiscoveryException;
import com.bmc.thirdparty.org.apache.commons.discovery.log.SimpleLog;
import com.bmc.thirdparty.org.apache.commons.discovery.tools.ClassUtils;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;

public class DiscoveryLogFactory {
    private static LogFactory logFactory = null;
    private static final Hashtable classRegistry = new Hashtable();
    private static final Class[] setLogParamClasses = new Class[]{class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = DiscoveryLogFactory.class$("com.bmc.thirdparty.org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log};
    private static Log log = DiscoveryLogFactory._newLog(class$org$apache$commons$discovery$log$DiscoveryLogFactory == null ? (class$org$apache$commons$discovery$log$DiscoveryLogFactory = DiscoveryLogFactory.class$("com.bmc.thirdparty.org.apache.commons.discovery.log.DiscoveryLogFactory")) : class$org$apache$commons$discovery$log$DiscoveryLogFactory);
    static /* synthetic */ Class class$org$apache$commons$logging$Log;
    static /* synthetic */ Class class$org$apache$commons$discovery$log$DiscoveryLogFactory;

    public static Log newLog(Class clazz) {
        try {
            Method setLog = ClassUtils.findPublicStaticMethod(clazz, Void.TYPE, "setLog", setLogParamClasses);
            if (setLog == null) {
                String msg = "Internal Error: " + clazz.getName() + " required to implement 'public static void setLog(Log)'";
                log.fatal(msg);
                throw new DiscoveryException(msg);
            }
        }
        catch (SecurityException se) {
            String msg = "Required Security Permissions not present";
            log.fatal(msg, se);
            throw new DiscoveryException(msg, se);
        }
        if (log.isDebugEnabled()) {
            log.debug("Class meets requirements: " + clazz.getName());
        }
        return DiscoveryLogFactory._newLog(clazz);
    }

    public static Log _newLog(Class clazz) {
        classRegistry.put(clazz, clazz);
        return logFactory == null ? new SimpleLog(clazz.getName()) : logFactory.getInstance(clazz.getName());
    }

    public static void setLog(Log _log) {
        log = _log;
    }

    public static void setFactory(LogFactory factory) {
        if (logFactory == null) {
            logFactory = factory;
            Enumeration elements = classRegistry.elements();
            while (elements.hasMoreElements()) {
                Class clazz = (Class)elements.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug("Reset Log for: " + clazz.getName());
                }
                Method setLog = null;
                try {
                    setLog = clazz.getMethod("setLog", setLogParamClasses);
                }
                catch (Exception e) {
                    String msg = "Internal Error: pre-check for " + clazz.getName() + " failed?!";
                    log.fatal(msg, e);
                    throw new DiscoveryException(msg, e);
                }
                Object[] setLogParam = new Object[]{factory.getInstance(clazz.getName())};
                try {
                    setLog.invoke(null, setLogParam);
                }
                catch (Exception e) {
                    String msg = "Internal Error: setLog failed for " + clazz.getName();
                    log.fatal(msg, e);
                    throw new DiscoveryException(msg, e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

