/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.discovery;

import com.bmc.thirdparty.org.apache.commons.discovery.ResourceIterator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;

public class Resource {
    protected final String name;
    protected final URL resource;
    protected final ClassLoader loader;

    public Resource(String resourceName, URL resource, ClassLoader loader) {
        this.name = resourceName;
        this.resource = resource;
        this.loader = loader;
    }

    public String getName() {
        return this.name;
    }

    public URL getResource() {
        return this.resource;
    }

    public InputStream getResourceAsStream() {
        try {
            return this.resource.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public String toString() {
        return "Resource[" + this.getName() + ", " + this.getResource() + ", " + this.getClassLoader() + "]";
    }

    public static Resource[] toArray(ResourceIterator iterator) {
        Vector<Resource> vector = new Vector<Resource>();
        while (iterator.hasNext()) {
            vector.add(iterator.nextResource());
        }
        Object[] resources = new Resource[vector.size()];
        vector.copyInto(resources);
        return resources;
    }
}

