/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.wsdl;

import com.bmc.arsys.ws.util.ARWSException;
import com.bmc.arsys.ws.util.WsdlUtil;
import com.bmc.arsys.ws.wsdl.CustomXmlSchemaParser;
import com.bmc.arsys.ws.wsdl.WsdlOperation;
import com.bmc.arsys.ws.wsdl.WsdlPortBindingOperation;
import com.bmc.arsys.ws.wsdl.WsdlService;
import com.bmc.arsys.ws.wsdl.XMLSchemaParser;
import com.ibm.wsdl.ImportImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis.Constants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsdlParser {
    protected String wsdlUri = null;
    protected Document doc = null;
    protected Definition def = null;
    protected Map<String, WsdlService> services = new HashMap<String, WsdlService>();
    protected String tempDir = null;
    protected XMLSchemaParser schemaParser = null;
    protected CustomXmlSchemaParser cSchemaParser = null;
    protected String description = null;
    protected StringBuffer warnings = new StringBuffer();
    protected Element types = null;

    public WsdlParser(String wsdlUri, String tempDir, StringBuffer warnings) {
        this.wsdlUri = wsdlUri;
        this.warnings = warnings;
        this.doc = WsdlUtil.newDocument(wsdlUri, true);
        this.tempDir = tempDir;
        this.cSchemaParser = new CustomXmlSchemaParser(warnings);
        try {
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            this.def = reader.readWSDL(wsdlUri, this.doc);
        }
        catch (WSDLException e) {
            throw new ARWSException(e);
        }
    }

    public WsdlOperation getOperation(String strService, String strPort, String operationName) {
        WsdlPortBindingOperation port;
        WsdlService service;
        WsdlOperation retOp = null;
        if (this.services != null && (service = this.services.get(strService)) != null && (port = service.getPortByName(strPort)) != null) {
            retOp = port.getOperation(operationName);
        }
        return retOp;
    }

    public Map getOperations(String strService, String strPort) {
        WsdlPortBindingOperation port;
        WsdlService service;
        Map operations = null;
        if (this.services != null && (service = this.services.get(strService)) != null && (port = service.getPortByName(strPort)) != null) {
            operations = port.getOperationMap();
        }
        return operations;
    }

    public Document parseWsdl() {
        this.parseServiceAndBinding();
        return this.createMappingDoc();
    }

    public void parseServiceAndBinding() {
        for (Service service : this.def.getServices().values()) {
            WsdlUtil.trace("Service: " + service.getQName());
            WsdlService wsService = new WsdlService(service);
            wsService.parseServiceBinding();
            this.services.put(service.getQName().toString(), wsService);
        }
    }

    public Document createMappingDoc() {
        this.schemaParser = null;
        String xmlSchemaFileName = this.extractSchemaFromWsdl();
        if (xmlSchemaFileName == null) {
            Map map = this.def.getImports();
            ArrayList keyList = new ArrayList(map.keySet());
            if (keyList.size() != 0) {
                Object firstKey = keyList.get(0);
                Object importObj = map.get(firstKey);
                ArrayList importList = new ArrayList((Collection)importObj);
                ImportImpl firstImport = (ImportImpl)importList.get(0);
                String importedURI = firstImport.getLocationURI();
                importedURI = XMLSchemaParser.expandSystemId(importedURI, this.wsdlUri);
                WsdlParser wparser = new WsdlParser(importedURI, this.tempDir, this.warnings);
                xmlSchemaFileName = wparser.extractSchemaFromWsdl();
            }
            if (xmlSchemaFileName != null) {
                this.schemaParser = new XMLSchemaParser(this.wsdlUri, xmlSchemaFileName, this.warnings);
            }
        } else {
            this.schemaParser = new XMLSchemaParser(this.wsdlUri, this.tempDir, xmlSchemaFileName, this.warnings);
        }
        Document mappingDom = null;
        mappingDom = WsdlUtil.newDocument();
        Element rootElement = mappingDom.createElementNS(null, "webservices");
        mappingDom.appendChild(rootElement);
        String targetNamespace = "";
        targetNamespace = this.def.getTargetNamespace();
        if (targetNamespace == null) {
            targetNamespace = this.cSchemaParser.getFirstNamespace();
        }
        Collection<WsdlService> values = this.services.values();
        for (WsdlService service : values) {
            service.createMappingDoc(mappingDom, targetNamespace, this.schemaParser, this.def, this.warnings);
        }
        return mappingDom;
    }

    public String extractSchemaFromWsdl() {
        NodeList childNodes = this.doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String importedSchemaUri;
            if (childNodes.item(i).getNodeType() != 1) continue;
            Element child = (Element)childNodes.item(i);
            if (child.getLocalName().equals("types")) {
                this.types = child;
                break;
            }
            if (!child.getLocalName().equals("import") || (importedSchemaUri = child.getAttribute("schemaLocation")) == null || importedSchemaUri.equals("")) continue;
            return XMLSchemaParser.expandSystemId(importedSchemaUri, this.wsdlUri);
        }
        if (this.types == null) {
            return null;
        }
        ArrayList<Node> xmlnsList = new ArrayList<Node>(10);
        NamedNodeMap attrs = this.doc.getDocumentElement().getAttributes();
        Attr soapEncNs = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            if (attr.getPrefix() != null && attr.getPrefix().equals("xmlns")) {
                xmlnsList.add(attr);
            }
            if (!attr.getNodeValue().equals(Constants.URI_DEFAULT_SOAP_ENC)) continue;
            soapEncNs = (Attr)attr;
        }
        this.cSchemaParser.parseSchema(this.types);
        return this.cSchemaParser.writeSchemasToTempDir(this.tempDir, xmlnsList, soapEncNs);
    }
}

