/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.mapping;

import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ARSOperation {
    protected String name = null;
    protected String type = null;
    protected String qualification = null;
    protected String maxLimit = null;
    protected String startRecord = null;
    protected String options = null;
    protected String soapActionURI = null;
    protected String inputMappingName = null;
    protected String inputTopElement = null;
    protected String outputMappingName = null;
    protected String outputTopElement = null;
    protected String bindingStyle = "document";
    protected String useStyle = "literal";
    protected String inNamespace = null;
    protected String outNamespace = null;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getQualification() {
        return this.qualification;
    }

    public String getMaxLimit() {
        if (this.maxLimit == null || this.maxLimit.equals("")) {
            this.maxLimit = "XPATH(/ROOT/maxLimit)";
        }
        return this.maxLimit;
    }

    public String getStartRecord() {
        if (this.startRecord == null || this.startRecord.equals("")) {
            this.startRecord = "XPATH(/ROOT/startRecord)";
        }
        return this.startRecord;
    }

    public String getOptions() {
        return this.options;
    }

    public String getSoapActionURI() {
        return this.soapActionURI;
    }

    public String getInputMappingName() {
        return this.inputMappingName;
    }

    public String getInputTopElement() {
        return this.inputTopElement;
    }

    public String getOutputMappingName() {
        return this.outputMappingName;
    }

    public String getOutputTopElement() {
        return this.outputTopElement;
    }

    public String getUseStyle() {
        return this.useStyle;
    }

    public String getBindingStyle() {
        return this.bindingStyle;
    }

    public ARSOperation(Element operationElem) {
        this.parseXML(operationElem);
    }

    public ARSOperation(String name, String soapActionURI, String inputMappingName, String inputTopElement, String outputMappingName, String outputTopElement, String bindingStyle, String useStyle, String inNamespace, String outNamespace) {
        this.name = name;
        this.soapActionURI = soapActionURI;
        this.inputMappingName = inputMappingName;
        this.inputTopElement = inputTopElement;
        this.outputMappingName = outputMappingName;
        this.outputTopElement = outputTopElement;
        this.bindingStyle = bindingStyle;
        this.useStyle = useStyle;
        this.inNamespace = inNamespace;
        this.outNamespace = outNamespace;
    }

    public boolean parseXML(Element operationElem) {
        if (operationElem == null || operationElem.getTagName() == null || !operationElem.getTagName().equals("operation")) {
            return false;
        }
        this.name = operationElem.getAttribute("name");
        this.type = operationElem.getAttribute("type");
        this.qualification = operationElem.getAttribute("qualification");
        this.maxLimit = operationElem.getAttribute("maxLimit");
        this.startRecord = operationElem.getAttribute("startRecord");
        this.useStyle = operationElem.getAttribute("useStyle");
        this.bindingStyle = operationElem.getAttribute("bindingStyle");
        this.soapActionURI = operationElem.getAttribute("soapActionURI");
        NodeList childNodes = operationElem.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            Element childElem = (Element)childNodes.item(i);
            if (childElem.getTagName().equals("inputMapping")) {
                this.inputMappingName = childElem.getAttribute("name");
                this.inNamespace = childElem.getAttribute("namespace");
                this.inputTopElement = childElem.getAttribute("topLevelElement");
                continue;
            }
            if (childElem.getTagName().equals("outputMapping")) {
                this.outputMappingName = childElem.getAttribute("name");
                this.outNamespace = childElem.getAttribute("outNamespace");
                this.outputTopElement = childElem.getAttribute("topLevelElement");
                continue;
            }
            if (!childElem.getTagName().equals("arOptions")) continue;
            this.options = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + XMLUtils.ElementToString(childElem);
        }
        return true;
    }

    public void generateXML(Element webServiceElem) {
        Document mappingDom = webServiceElem.getOwnerDocument();
        Element operationElem = mappingDom.createElementNS(null, "operation");
        operationElem.setAttributeNS(null, "name", this.getName());
        operationElem.setAttributeNS(null, "soapActionURI", this.getSoapActionURI());
        operationElem.setAttributeNS(null, "useStyle", this.getUseStyle());
        operationElem.setAttributeNS(null, "bindingStyle", this.getBindingStyle());
        webServiceElem.appendChild(operationElem);
        Element inputMappingNode = mappingDom.createElementNS(null, "inputMapping");
        operationElem.appendChild(inputMappingNode);
        inputMappingNode.setAttributeNS(null, "name", this.inputMappingName);
        if (this.inNamespace != null) {
            inputMappingNode.setAttributeNS(null, "namespace", this.inNamespace);
        }
        inputMappingNode.setAttributeNS(null, "topLevelElement", this.inputTopElement);
        Element outputMappingNode = mappingDom.createElementNS(null, "outputMapping");
        operationElem.appendChild(outputMappingNode);
        outputMappingNode.setAttributeNS(null, "name", this.outputMappingName);
        if (this.outNamespace != null) {
            outputMappingNode.setAttributeNS(null, "namespace", this.outNamespace);
        }
        outputMappingNode.setAttributeNS(null, "topLevelElement", this.outputTopElement);
    }
}

