/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.util;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.ByteListValue;
import com.bmc.arsys.api.CoordinateInfo;
import com.bmc.arsys.api.CurrencyValue;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.StatusHistoryValue;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.internal.ConversionUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class ValueConverter {
    private static final Logger logger = Logger.getLogger(ValueConverter.class);

    public static Value convertToARValue(Object val) {
        Value arVal = null;
        if (val instanceof Integer) {
            arVal = new Value(((Number)val).intValue());
        } else if (val instanceof String) {
            arVal = new Value((String)val);
        } else if (val instanceof Double) {
            arVal = new Value(((Number)val).doubleValue());
        } else if (val instanceof java.util.Date) {
            arVal = new Value(new Timestamp(((java.util.Date)val).getTime() / 1000L));
        } else if (val instanceof BigDecimal) {
            arVal = new Value((BigDecimal)val);
        } else if (val instanceof AttachmentValue) {
            arVal = new Value((AttachmentValue)val);
        } else if (val instanceof CurrencyValue) {
            arVal = new Value((CurrencyValue)val);
        } else if (val instanceof DiaryListValue) {
            arVal = new Value((DiaryListValue)val);
        } else if (val instanceof StatusHistoryValue) {
            String encoded = ((StatusHistoryValue)val).encode();
            arVal = new Value(encoded);
        } else if (val instanceof ByteListValue) {
            arVal = new Value((ByteListValue)val);
        } else if (val instanceof byte[] && ((byte[])val).length > 0) {
            ByteListValue inner = new ByteListValue(0, (byte[])val);
            arVal = new Value(inner);
        } else if (val instanceof Long) {
            arVal = (Long)val == (long)((Long)val).intValue() ? new Value(((Long)val).intValue()) : new Value(((Long)val).longValue());
        } else if (val instanceof ArrayList && ((ArrayList)val).size() > 0 && ((ArrayList)val).get(0) instanceof CoordinateInfo) {
            logger.debug((Object)"convertToARValue(Object) - CoordList values are not supported");
        } else {
            arVal = new Value();
        }
        return arVal;
    }

    public static Object[] convertFromAR(List<Value> list, int[] supportedDataTypes) {
        Object[] varArray = null;
        if (list != null && list.size() > 0) {
            int count = list.size();
            varArray = new Object[count];
            for (int i = 0; i < count; ++i) {
                varArray[i] = ValueConverter.convertFromARValue(list.get(i), false, false, supportedDataTypes);
            }
        }
        return varArray;
    }

    public static List<Value> convertToAR(Object result) {
        ArrayList<Value> list = new ArrayList<Value>();
        if (result == null) {
            return list;
        }
        if (result instanceof Object[]) {
            Object[] givenArray = (Object[])result;
            if (givenArray != null) {
                if (givenArray.length <= 0) {
                    return list;
                }
                for (Object cur : givenArray) {
                    list.add(ValueConverter.convertToARValue(cur));
                }
            }
        } else {
            list.add(ValueConverter.convertToARValue(result));
        }
        return list;
    }

    private static boolean isArgTypeSupported(int typ, int[] supportedDataTypes) {
        int count = supportedDataTypes.length;
        for (int i = 0; i < count; ++i) {
            if (typ != supportedDataTypes[i]) continue;
            return true;
        }
        return false;
    }

    public static Object convertFromARValue(Value val, boolean isStatusHistory, boolean preserveEnumTypeInfo, int[] supportedDataTypes) {
        if (val == null) {
            return null;
        }
        int arTyp = val.getDataType().toInt();
        if (!ValueConverter.isArgTypeSupported(arTyp, supportedDataTypes)) {
            return null;
        }
        switch (arTyp) {
            case 0: {
                return null;
            }
            case 1: {
                return String.format("$-%d$", ConversionUtil.getIntValue((Object)val.getValue()));
            }
            case 2: {
                return ConversionUtil.getIntValue((Object)val.getValue());
            }
            case 3: {
                return ConversionUtil.getDoubleValue((Object)val.getValue());
            }
            case 4: {
                if (isStatusHistory) {
                    try {
                        return StatusHistoryValue.decode((String)val.getValue().toString().trim());
                    }
                    catch (ARException e) {
                        return val.getValue().toString();
                    }
                }
                return val.getValue().toString();
            }
            case 5: {
                try {
                    DiaryListValue diaryList = DiaryListValue.decode((String)val.getValue().toString());
                    return diaryList;
                }
                catch (ARException e) {
                    return val.getValue();
                }
            }
            case 6: {
                if (preserveEnumTypeInfo) {
                    return val;
                }
                return ConversionUtil.getIntValue((Object)val.getValue());
            }
            case 7: {
                if (val.getValue() instanceof java.util.Date) {
                    return val.getValue();
                }
                return ValueConverter.getDateTime(ConversionUtil.getIntValue((Object)val.getValue()));
            }
            case 8: {
                return val.getValue();
            }
            case 9: {
                return ARTypeMgr.getInstance().ObjectFromVariant(ByteListValue.class, val.getValue(), null);
            }
            case 10: {
                return ConversionUtil.getBigDecimalValue((Object)val.getValue());
            }
            case 11: {
                if (val.getValue() instanceof AttachmentValue) {
                    return val.getValue();
                }
                return ARTypeMgr.getInstance().ObjectFromVariant(AttachmentValue.class, val.getValue(), null);
            }
            case 12: {
                if (val.getValue() instanceof CurrencyValue) {
                    return val.getValue();
                }
                return ARTypeMgr.getInstance().ObjectFromVariant(CurrencyValue.class, val.getValue(), null);
            }
            case 13: {
                if (val.getValue() instanceof Date) {
                    Date date = (Date)val.getValue();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    return DateInfo.dateToJulianDate((int)cal.get(1), (int)cal.get(2), (int)cal.get(6));
                }
                return ConversionUtil.getIntValue((Object)val.getValue());
            }
            case 14: {
                return ConversionUtil.getIntValue((Object)val.getValue());
            }
            case 33: {
                return val;
            }
            case 40: {
                return ConversionUtil.getLongValue((Object)val.getValue());
            }
            case 41: {
                return ARTypeMgr.getInstance().ObjectListFromVariant(CoordinateInfo.class, val.getValue(), null);
            }
            case 42: 
            case 43: {
                return val;
            }
        }
        return null;
    }

    private static java.util.Date getDateTime(int arTime) {
        Date date = new Date((long)arTime * 1000L);
        return date;
    }
}

