/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.util;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.plugins.util.MiscUtil;

public class ScriptInvocationData {
    private String sourceSnippet;
    private String language;
    private Object[] actualArgs;

    public ScriptInvocationData(Object[] args, String[] supportedLanguages) throws ARException {
        String string = this.sourceSnippet = args[0] != null ? args[0].toString() : null;
        if (this.sourceSnippet == null || this.sourceSnippet.length() <= 0) {
            throw new ARException(2, 5555, "SCRIPT_PLUGIN_ERR_NOSCRIPT: First argument must specify script sourceSnippet.");
        }
        this.sourceSnippet = MiscUtil.unquoteString(this.sourceSnippet);
        if (!this.isSupportedLanguage(args, supportedLanguages)) {
            throw new ARException(2, 5556, "SCRIPT_PLUGIN_ERR_NOT_VALID: Language is not valid.");
        }
        this.actualArgs = this.extractActualArgs(args);
    }

    private Object[] extractActualArgs(Object[] args) {
        Object[] argsWithoutFunc = null;
        if (args != null && args.length > 2) {
            argsWithoutFunc = new Object[args.length - 2];
            System.arraycopy(args, 2, argsWithoutFunc, 0, args.length - 2);
        }
        return argsWithoutFunc;
    }

    private boolean isSupportedLanguage(Object[] args, String[] languageNames) throws ARException {
        String scriptLanguage;
        String string = scriptLanguage = args[1] != null ? args[1].toString() : null;
        if (scriptLanguage == null || scriptLanguage.length() <= 0) {
            assert (languageNames != null && languageNames.length > 0);
            scriptLanguage = languageNames[0];
            return true;
        }
        int count = languageNames.length;
        for (int i = 0; i < count; ++i) {
            if (scriptLanguage.compareToIgnoreCase(languageNames[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public Object[] getActualArgs() {
        return this.actualArgs;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSourceSnippet() {
        return this.sourceSnippet;
    }
}

