/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.sso;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arencrypt.PasswordReserveFieldEncryption;
import com.bmc.arsys.plugins.sso.AtriumSSOUserMapping;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.atrium.sso.common.AtriumSSOException;
import com.bmc.atrium.sso.sdk.Authentication;
import com.bmc.atrium.sso.sdk.Realms;
import com.bmc.atrium.sso.sdk.SSOServer;
import com.bmc.atrium.sso.sdk.SSOToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class AtriumSSOConfirmPassword
extends ARFilterAPIPlugin {
    private Authentication ssoContext;
    private Realms.Realm defaultRealm;
    private int onEventFlag = 0;
    private String keyStorePasswordCopy = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.ATSSOCONFIRMPWD", (ARPluggable)this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Value> filterAPICall(ARPluginContext context, List<Value> pInValues) throws ARException {
        ArrayList<Value> outValues = null;
        try {
            context.logMessage(this.pluginInfo, 0, "filterapiCall()");
            outValues = new ArrayList<Value>(1);
            outValues.add(new Value(0));
            if (pInValues == null || pInValues.size() < 2) {
                context.logMessage(this.pluginInfo, 0, "Input values not provided.");
                return outValues;
            }
            String name = pInValues.get(0).toString();
            String password = pInValues.get(1).toString();
            if (name.isEmpty()) {
                context.logMessage(this.pluginInfo, 0, "User Name empty");
                return outValues;
            }
            context.logMessage(this.pluginInfo, 0, "User Name : " + name);
            context.logMessage(this.pluginInfo, 0, "Pwd Length : " + password.length());
            String ssoUserName = AtriumSSOUserMapping.getInstance().getSSOUserName(name, context, true);
            context.logMessage(this.pluginInfo, 0, "SSO mapped name : " + ssoUserName);
            Realms.Realm userRealm = this.defaultRealm;
            SSOToken ssoToken = null;
            String tokenId = context.getAuthString();
            if (tokenId != null) {
                try {
                    ssoToken = this.ssoContext.getToken(tokenId);
                    if (ssoToken != null) {
                        userRealm = ssoToken.getAuthenticationRealm();
                    }
                }
                catch (AtriumSSOException e) {
                    context.logMessage(this.pluginInfo, 0, "Could not get realm");
                }
            } else {
                context.logMessage(this.pluginInfo, 0, "Could not get realm:Token id null.");
            }
            String tokenid = null;
            SSOAuthCallbackHandler callbacks = new SSOAuthCallbackHandler(ssoUserName, password);
            context.logMessage(this.pluginInfo, 0, "Connecting to SSO : User name : " + ssoUserName + ": User realm : " + userRealm);
            try {
                tokenid = this.ssoContext.connect(userRealm, (CallbackHandler)callbacks);
            }
            catch (AtriumSSOException e) {
                context.logMessage(this.pluginInfo, 0, "SSO connect failed : " + ssoUserName + ". Get best case mappings.");
                String nameWithoutEmail = AtriumSSOUserMapping.getInstance().getSSOUserNameWithoutEmail(ssoUserName, context);
                String nameWithoutReplace = AtriumSSOUserMapping.getInstance().getSSOUserName(name, context, false);
                try {
                    if (!ssoUserName.equals(nameWithoutEmail)) {
                        context.logMessage(this.pluginInfo, 0, "Connecting to SSO without email with name : " + nameWithoutEmail);
                        SSOAuthCallbackHandler callbacks1 = new SSOAuthCallbackHandler(nameWithoutEmail, password);
                        context.logMessage(this.pluginInfo, 0, "Connecting to SSO");
                        tokenid = this.ssoContext.connect(userRealm, (CallbackHandler)callbacks1);
                    }
                }
                catch (AtriumSSOException e1) {
                    context.logMessage(this.pluginInfo, 0, "SSO connect failed : " + nameWithoutEmail);
                }
                finally {
                    if (tokenid == null || tokenid.isEmpty()) {
                        if (!ssoUserName.equals(nameWithoutReplace)) {
                            context.logMessage(this.pluginInfo, 0, "Connecting to SSO without name replace with name : " + nameWithoutReplace);
                            SSOAuthCallbackHandler callbacks2 = new SSOAuthCallbackHandler(nameWithoutReplace, password);
                            context.logMessage(this.pluginInfo, 0, "Connecting to SSO");
                            tokenid = this.ssoContext.connect(userRealm, (CallbackHandler)callbacks2);
                        } else {
                            throw e;
                        }
                    }
                }
            }
            context.logMessage(this.pluginInfo, 0, "Connected. Valid username/password");
            if (tokenid != null && !tokenid.isEmpty()) {
                outValues.clear();
                outValues.add(new Value(1));
            }
            context.logMessage(this.pluginInfo, 0, "Disconnecting from SSO");
            this.ssoContext.disconnect(tokenid);
            context.logMessage(this.pluginInfo, 0, "Disconnected.");
        }
        catch (AtriumSSOException e) {
            context.logMessage(this.pluginInfo, 0, e.toString());
            throw new ARException(2, 8753, e.getMessage());
        }
        catch (Exception e) {
            context.logMessage(this.pluginInfo, 0, e.toString());
            throw new ARException(2, 8753, e.getMessage());
        }
        return outValues;
    }

    public void initialize(ARPluginContext context) throws ARException {
        System.out.println("Intializing plug-in : " + context.getPluginInfo().getName());
        String atriumSSOLocation = context.getARConfigEntry("Atrium-SSO-Location");
        String keyStoreLocation = context.getARConfigEntry("Atrium-SSO-Keystore-Path");
        String keyStorePassword = context.getARConfigEntry("Atrium-SSO-Keystore-Password");
        if (atriumSSOLocation == null || atriumSSOLocation.length() == 0) {
            context.logMessage(this.pluginInfo, 1, "Atrium SSO Server Location Is Null");
            return;
        }
        try {
            if (keyStorePassword != null && (this.keyStorePasswordCopy == null || keyStorePassword.compareTo(this.keyStorePasswordCopy) != 0)) {
                this.keyStorePasswordCopy = new String(keyStorePassword);
                PasswordReserveFieldEncryption pwdEnc = new PasswordReserveFieldEncryption(false);
                byte[] decPasswd = pwdEnc.decryptPasswordEx(keyStorePassword.getBytes());
                keyStorePassword = new String(decPasswd);
            }
        }
        catch (Exception e1) {
            context.logMessage(this.pluginInfo, 2, e1.toString());
            throw new ARException(2, 8753, e1.getMessage());
        }
        SSOServer server = null;
        try {
            FileInputStream inputStream = null;
            context.logMessage(this.pluginInfo, 0, "Get SSO Server instance");
            server = SSOServer.getInstance((String)atriumSSOLocation);
            context.logMessage(this.pluginInfo, 0, "Get default realm");
            this.defaultRealm = server.getRealms().getDefaultRealm();
            context.logMessage(this.pluginInfo, 0, "Default realm is : " + this.defaultRealm);
            if (keyStoreLocation != null) {
                try {
                    inputStream = new FileInputStream(keyStoreLocation);
                    KeyStore keystore = KeyStore.getInstance("jks");
                    char[] keyPass = keyStorePassword.toCharArray();
                    keystore.load(inputStream, keyPass);
                    server.setTrustStore(keystore);
                }
                catch (Exception e) {
                    context.logMessage(this.pluginInfo, 2, e.toString());
                    throw new ARException(2, 8753, e.getMessage());
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            server.setAcceptAllServerCertificates(true);
            context.logMessage(this.pluginInfo, 0, "Get SSO Context");
            this.ssoContext = server.getAuthentication();
            context.logMessage(this.pluginInfo, 0, "SSO Context created");
        }
        catch (AtriumSSOException e) {
            context.logMessage(this.pluginInfo, 2, e.toString());
            throw new ARException(2, 8753, e.getMessage());
        }
        AtriumSSOUserMapping.getInstance().init(context);
        System.out.println("Intializing plugin " + context.getPluginInfo().getName());
    }

    public void onEvent(ARPluginContext context, int pEventID) throws ARException {
        context.logMessage(this.pluginInfo, 0, "on event called with event id " + String.valueOf(pEventID));
        this.lock.lock();
        try {
            if (pEventID == 10005) {
                this.onEventFlag = 1;
                this.initialize(context);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class SSOAuthCallbackHandler
    implements CallbackHandler {
        private String user;
        private String password;

        public SSOAuthCallbackHandler(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(this.user);
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password.toCharArray());
            }
        }
    }
}

