/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.snmp.helper;

public final class SNMPConfFileHelper {
    public static boolean isMemberWindows(String osname) {
        boolean result = false;
        if (osname != null && osname.startsWith("Windows ")) {
            result = true;
        }
        return result;
    }

    public static String getConfExtension() {
        String osName = SNMPConfFileHelper.getOsName();
        if (SNMPConfFileHelper.isMemberWindows(osName)) {
            return ".cfg";
        }
        return ".conf";
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static boolean digitsOnly(String text) {
        boolean result = true;
        if (SNMPConfFileHelper.isNullOrEmpty(text, true)) {
            result = false;
        } else {
            char[] c = text.toCharArray();
            for (int j = 0; result && j < c.length; ++j) {
                if (Character.isDigit(c[j])) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean isNullOrEmpty(String text, boolean trim) {
        boolean result = true;
        if (text != null) {
            String data = text;
            if (trim) {
                data = data.trim();
            }
            if (data.length() > 0) {
                result = false;
            }
        }
        return result;
    }
}

