/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.ArrayList;
import java.util.List;

public class QueryParserPlugin
extends ARFilterAPIPlugin {
    private final ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.QUERYPARSER", (ARPluggable)this);
    private String serverName = "localhost";
    private ARServerUser serverUser = null;

    public void initialize(ARPluginContext context) throws ARException {
        try {
            int i;
            String[] args = context.getCmdLineArgs();
            String message = "initialize method was invoked with args = ";
            if (args.length >= 0) {
                for (i = 0; i < args.length; ++i) {
                    message = message + " " + args[i];
                }
            }
            context.logMessage(this.pluginInfo, 0, message);
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-x")) continue;
                this.serverName = args[i + 1];
                i = args.length;
            }
            context.logMessage(this.pluginInfo, 0, "Server name = " + this.serverName);
        }
        catch (Throwable th) {
            context.logMessage(this.pluginInfo, 1, th.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Value> filterAPICall(ARPluginContext context, List<Value> inValues) throws ARException {
        if (inValues.size() == 0 || inValues.size() < 4) {
            return null;
        }
        this.initServerUser(context);
        String input = (String)inValues.get(0).getValue();
        String form = (String)inValues.get(1).getValue();
        String locale = (String)inValues.get(2).getValue();
        String type = (String)inValues.get(3).getValue();
        if (type == null || type.length() == 0) {
            type = "parse";
        }
        if (input == null || input.length() == 0) {
            throw new ARException(2, -1, "Input string is null");
        }
        if (form == null || form.length() == 0) {
            throw new ARException(2, -1, "Form is null");
        }
        if (locale == null) {
            locale = "";
        }
        String oldLocale = this.serverUser.getLocale();
        this.serverUser.setLocale(locale);
        try {
            ArrayList<Value> outValues = new ArrayList<Value>();
            if (type.equalsIgnoreCase("format")) {
                QualifierInfo qInfo = this.serverUser.decodeQualification(input);
                if (qInfo != null) {
                    outValues.add(new Value(this.serverUser.formatQualification(qInfo, null, null, 0, false)));
                }
            } else {
                QualifierInfo qualInfo = Utilities.parseQualification(this.serverUser, input, form, locale);
                if (qualInfo != null) {
                    outValues.add(new Value(this.serverUser.encodeQualification(qualInfo)));
                }
            }
            ArrayList<Value> arrayList = outValues;
            return arrayList;
        }
        finally {
            this.serverUser.setLocale(oldLocale);
        }
    }

    private void initServerUser(ARPluginContext context) throws ARException {
        context.logMessage(0, "initServerUser()");
        if (this.serverUser == null) {
            this.serverUser = new ARServerUser((ARNativeAuthenticationInfo)context, "", this.serverName);
            int port = Utilities.getIntegerValue(context.getARConfigEntry("TCD-Specific-Port"));
            this.serverUser.setPort(port);
            int rpcnumber = Utilities.getIntegerValue(context.getARConfigEntry("Plugin-Loopback-RPC-Socket"));
            if (rpcnumber > 0) {
                this.serverUser.usePrivateRpcQueue(rpcnumber);
            }
            this.serverUser.setVUIType(1);
        }
        this.serverUser.setUserContext((ARNativeAuthenticationInfo)context);
    }
}

