/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.report;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.api.View;
import com.bmc.arsys.arreporting.ReportConstants;
import com.bmc.arsys.arreporting.Utilities;
import com.bmc.arsys.plugins.report.IReportForm;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FieldInfoTable
implements IReportForm {
    final int AR_CORE_STATUS_HISTORY = 15;
    final int AR_RESERV_PASSWORD = 102;
    final int AR_RESERV_ENCRYPTED_STRING = 123;

    private List<Entry> buildEntryItems(List<Field> fieldlist, ARServerUser serverUser, ARPluginContext context, String formName, String localeName, int vuiId) throws ARException {
        context.logMessage(0, "buildEntryItems()n fieldList Size = " + fieldlist.size());
        int len = fieldlist.size();
        ArrayList<Entry> entryList = new ArrayList<Entry>();
        Entry e = new Entry();
        StringBuffer sb = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        ArrayList<String> fl = new ArrayList<String>();
        HashMap<String, FormattedOutput> fldLblMap = new HashMap<String, FormattedOutput>();
        HashMap<String, String> labelMap = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            Field field = fieldlist.get(i);
            int dt = field.getDataType();
            if (dt != DataType.CHAR.toInt() && dt != DataType.CURRENCY.toInt() && dt != DataType.DATE.toInt() && dt != DataType.DECIMAL.toInt() && dt != DataType.INTEGER.toInt() && dt != DataType.REAL.toInt() && dt != DataType.TIME.toInt() && dt != DataType.TIME_OF_DAY.toInt() && dt != DataType.ENUM.toInt() || field.getFieldID() == 15 || field.getName().startsWith("z") || field.getFieldID() == 102 || field.getFieldID() == 123 || field.getFieldOption() == 4) continue;
            String vlabel = this.getFieldLabel(serverUser, field, vuiId);
            if (vlabel != null && vlabel.length() > 0) {
                if (labelMap.get(vlabel) != null) {
                    vlabel = vlabel + "(" + field.getName() + ")";
                } else {
                    labelMap.put(vlabel, vlabel);
                }
                fldLblMap.put("" + field.getFieldID(), new FormattedOutput(vlabel, field, serverUser, vuiId, vlabel));
            }
            fl.add("" + field.getFieldID());
        }
        View view = serverUser.getView(formName, vuiId);
        Value formAlias = (Value)view.getDisplayProperties().get((Object)207);
        TreeMap<String, FormattedOutput> sortedMap = new TreeMap<String, FormattedOutput>(new FieldLabelComparator(fldLblMap));
        sortedMap.putAll(fldLblMap);
        Iterator it = sortedMap.keySet().iterator();
        int mapSize = sortedMap.size();
        int i = 3;
        sb1.append("\"");
        while (it.hasNext()) {
            String key = (String)it.next();
            FormattedOutput val = fldLblMap.get(key);
            sb.append(val.formattedOutPut);
            sb1.append(key + "=" + i + (i < mapSize + 2 ? ";" : "\";\n"));
            ++i;
        }
        e.put(Integer.valueOf(1), new Value(formName + "#" + ReportConstants.FIELD_INFO_META_DATA.toInt()));
        e.put(Integer.valueOf(ReportConstants.FIELD_INFO_META_DATA.toInt()), new Value("\"formname=" + formName + ";alias=" + (formAlias == null ? formName : formAlias.toString()) + ";metadata_version=1.0\";\n" + sb1.toString() + sb.toString()));
        e.put(Integer.valueOf(ReportConstants.FIELD_INFO_VUI_ID.toInt()), new Value(vuiId));
        FormCriteria criteria = new FormCriteria();
        criteria.setPropertiesToRetrieve(FormCriteria.SORT_LIST | FormCriteria.ENTRYLIST_FIELDLIST);
        Form form = serverUser.getForm(formName, criteria);
        List resultList = form.getEntryListFieldInfo();
        List sortList = form.getSortInfo();
        e.put(Integer.valueOf(ReportConstants.FIELD_INFO_RESULTS_LIST.toInt()), new Value(this.getFormattedResultsList(resultList, fldLblMap)));
        e.put(Integer.valueOf(ReportConstants.FIELD_INFO_SORT_LIST.toInt()), new Value(this.getFormattedSortList(sortList, fldLblMap)));
        entryList.add(e);
        context.logMessage(0, "buildEntryItems()n fieldList Size = " + entryList.size());
        return entryList;
    }

    private String getFormattedResultsList(List<EntryListFieldInfo> resultList, HashMap<String, FormattedOutput> fldLblMap) {
        if (resultList == null || resultList.size() == 0) {
            if (fldLblMap.get("8") != null) {
                return "\"8=2\";\"id=8;header=\"\"" + fldLblMap.get((Object)"8").label.replace("\"", "\"\"\"\"") + "\"\"\"";
            }
            return "\"\";";
        }
        int length = resultList.size();
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            EntryListFieldInfo elfi = resultList.get(i);
            FormattedOutput fo = fldLblMap.get("" + elfi.getFieldId());
            if (fo == null || !fo.reportable || fo.resultsList_visited) continue;
            sb1.append((count == 0 ? "\"" : "") + elfi.getFieldId() + "=" + (count + 2) + ";");
            sb2.append("\"id=" + elfi.getFieldId() + ";header=\"\"" + fo.label.replace("\"", "\"\"\"\"") + "\"\"\";");
            ++count;
            fo.resultsList_visited = true;
        }
        int len1 = sb1.length();
        int len2 = sb2.length();
        if (len1 == 0 && len2 == 0) {
            return "\"\";";
        }
        return sb1.substring(0, len1 - 1) + "\";" + sb2.substring(0, len2 - 1);
    }

    private String getFormattedSortList(List<SortInfo> sortList, HashMap<String, FormattedOutput> fldLblMap) {
        if (sortList == null || sortList.size() == 0) {
            return "\"\";";
        }
        int length = sortList.size();
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int count = 0;
        for (int i = 0; i < length; ++i) {
            SortInfo si = sortList.get(i);
            FormattedOutput fo = fldLblMap.get("" + si.getFieldID());
            if (fo == null || !fo.sortable) continue;
            sb1.append((count == 0 ? "\"" : "") + si.getFieldID() + "=" + (count + 2) + ";");
            sb2.append("\"id=" + si.getFieldID() + ";group=0;dir=" + (si.getSortOrder() == 1 ? "1" : "0") + "\";");
            ++count;
        }
        int len1 = sb1.length();
        int len2 = sb2.length();
        if (len1 == 0 && len2 == 0) {
            return "\"\";";
        }
        return sb1.substring(0, len1 - 1) + "\";" + sb2.substring(0, len2 - 1);
    }

    private Value getEnumLabel(ARServerUser user, Field f, int vuiId) {
        return f.getDisplayInstance().getProperty(vuiId, Integer.valueOf(230));
    }

    private String getFieldLabel(ARServerUser user, Field f, int vuiId) {
        Value v = null;
        v = f.getDisplayInstance().getProperty(vuiId, Integer.valueOf(20));
        if (v != null && v.getValue() != null) {
            String label = v.getValue().toString();
            if (label == null || label != null && label.trim().length() == 0) {
                return "";
            }
            return label;
        }
        return "";
    }

    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fields, long transid, QualifierInfo qual, List<SortInfo> sortList, List<EntryListFieldInfo> fieldList, int startAt, int maxReturn, OutputInteger numMatches) throws ARException {
        QualifierInfo formQual = qual.getLeftOperand();
        QualifierInfo localeQual = qual.getRightOperand();
        String formName = "";
        String localeName = "";
        int vuiId = -9999;
        if (formQual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals("Form Name") || formQual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(ReportConstants.FIELD_INFO_FORM_NAME.toInt()).toString())) {
            formName = formQual.getRelationalOperationInfo().getRightOperand().getValue().toString();
        }
        if (localeQual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals("Locale") || localeQual.getRelationalOperationInfo().getLeftOperand().getValue().toString().equals(new Long(ReportConstants.FIELD_INFO_LOCALE.toInt()).toString())) {
            localeName = localeQual.getRelationalOperationInfo().getRightOperand().getValue().toString();
        }
        context.logMessage(0, "getListEntryWithFields() - Qual formName = " + formName);
        formName = formName.replace("%", "");
        context.logMessage(0, "getListEntryWithFields() - after replace, formName = " + formName);
        localeName = localeName.replace("%", "");
        vuiId = Utilities.getVuiId(usrContext, formName, localeName);
        List fieldlist = usrContext.getListFieldObjects(formName);
        List<Entry> el = this.buildEntryItems(fieldlist, usrContext, context, formName, localeName, vuiId);
        numMatches.setValue(el.size());
        context.logMessage(0, "nummatches  = " + numMatches.intValue());
        return el;
    }

    private ArrayList<ARVendorField> getFormFieldInfo(VendorForm form) {
        ArrayList<ARVendorField> list = new ArrayList<ARVendorField>();
        ARVendorField field1 = null;
        ARVendorField field2 = null;
        ARVendorField field3 = null;
        CharacterFieldLimit limit = null;
        try {
            limit = new CharacterFieldLimit(255, 2, 1, null, null, 0);
            field1 = new ARVendorField("Meta Data", ReportConstants.FIELD_INFO_META_DATA.toInt(), 4, (FieldLimit)limit);
            field2 = new ARVendorField("Results List", ReportConstants.FIELD_INFO_META_DATA.toInt(), 4, (FieldLimit)limit);
            field3 = new ARVendorField("Sort List", ReportConstants.FIELD_INFO_META_DATA.toInt(), 4, (FieldLimit)limit);
            list.add(field1);
            list.add(field2);
            list.add(field3);
        }
        catch (Exception e) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + form.getTableName(), e.getMessage())));
        }
        return list;
    }

    @Override
    public List<ARVendorField> getMultipleFields(ARPluginContext context, ARServerUser usrContext, VendorForm form) throws ARException {
        return this.getFormFieldInfo(form);
    }

    @Override
    public Entry getEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        return null;
    }

    @Override
    public String createEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        return null;
    }

    @Override
    public void setEntry(ARPluginContext context, ARServerUser usrContext, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
    }

    class FieldLabelComparator
    implements Comparator<String> {
        private Map<String, FormattedOutput> mMap = null;

        public FieldLabelComparator(Map<String, FormattedOutput> map) {
            this.mMap = map;
        }

        public void setMap(Map<String, FormattedOutput> sMap) {
            this.mMap = sMap;
        }

        @Override
        public int compare(String f1, String f2) {
            if (this.mMap == null) {
                return 0;
            }
            if (!this.mMap.containsKey(f1) || !this.mMap.containsKey(f2)) {
                return 0;
            }
            FormattedOutput fo1 = this.mMap.get(f1);
            FormattedOutput fo2 = this.mMap.get(f2);
            if (fo1.label.compareTo(fo2.label) > 0) {
                return 1;
            }
            return -1;
        }
    }

    class FormattedOutput {
        public String label;
        public String formattedOutPut;
        public boolean reportable;
        public boolean sortable;
        public boolean queryable;
        public boolean resultsList_visited = false;

        public FormattedOutput(String l, Field f, ARServerUser user, int vuiId, String v) {
            this.label = l;
            this.formattedOutPut = this.getFormattedOutput(f, user, vuiId, v);
        }

        private String getFormattedOutput(Field f, ARServerUser user, int vuiId, String v) {
            long len;
            String label = v == null ? "" : v;
            int dt = f.getDataType();
            boolean cflength = false;
            if (dt == DataType.CHAR.toInt() && f.getFieldLimit() != null && ((len = (long)((CharacterFieldLimit)f.getFieldLimit()).getMaxLength()) == 0L || len > 255L)) {
                cflength = true;
            }
            StringBuffer metaData = new StringBuffer();
            metaData.append("id=" + f.getFieldID());
            metaData.append(";label=\"\"" + label.replace("\"", "\"\"\"\"") + "\"\"");
            metaData.append(";dt=" + f.getDataType());
            metaData.append(";r=1");
            this.reportable = true;
            this.sortable = !cflength;
            this.queryable = true;
            metaData.append(";s=" + (cflength ? 0 : 1));
            metaData.append(";q=1");
            if (f.getDataType() == DataType.ENUM.toInt()) {
                metaData.append(";menu=\"\"");
                Value enumVal = FieldInfoTable.this.getEnumLabel(user, f, vuiId);
                if (enumVal != null && enumVal.getValue() != null) {
                    String[] str = enumVal.toString().split("\\\\");
                    int strLen = str.length;
                    if (str != null) {
                        for (int i = 2; i < strLen; i += 2) {
                            metaData.append(str[i] + (i == strLen - 1 ? "" : "\n"));
                        }
                    }
                }
                metaData.append("\"\"");
            }
            return "\"" + metaData.toString() + "\";\n";
        }
    }
}

