/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.proxy;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.proxy.ProxyInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.util.ARUtilEgcp;
import java.util.Hashtable;
import java.util.List;

public class ProxyUtil {
    private static Hashtable<String, ProxyInfo> proxyMap = null;
    private static final String PROXY_SETTINGS_FORM = "AR System Proxy Server Settings";
    private static final int FIELD_AR_SERVER = 51001;
    private static final int FIELD_PROXY_HOST = 51002;
    private static final int FIELD_PROXY_PORT = 51012;
    private static final int FIELD_PROXY_USER = 51004;
    private static final int FIELD_PROXY_PASSWORD = 123;
    private static final String SERVER_CONNECT_NAME = "Server-Connect-Name";
    private static final String SERVER_NAME = "Server-Name";
    private static final String TCD_SPECIFIC_PORT = "TCD-Specific-Port";
    private static final String REMEDY_APP_SERVICE_PASSWORD = "Remedy-App-Service-Password";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyInfo getProxyInfo(ARPluginContext pluginContext) throws ARException {
        if (proxyMap == null) {
            proxyMap = new Hashtable();
        }
        ARServerUser serverUser = null;
        ProxyInfo proxyInfo = null;
        try {
            String arServerName = pluginContext.getARConfigEntry(SERVER_CONNECT_NAME);
            if (arServerName == null || arServerName.length() == 0) {
                arServerName = pluginContext.getARConfigEntry(SERVER_NAME);
            }
            if (arServerName == null || arServerName.trim().length() == 0) {
                pluginContext.logMessage(1, "AR server name not found in ar.cfg, not setting proxy parameters");
                ProxyInfo proxyInfo2 = null;
                return proxyInfo2;
            }
            proxyInfo = proxyMap.get(arServerName);
            if (proxyInfo != null) {
                ProxyInfo proxyInfo3 = proxyInfo;
                return proxyInfo3;
            }
            String pwd = pluginContext.getARConfigEntry(REMEDY_APP_SERVICE_PASSWORD);
            ARUtilEgcp egcp = new ARUtilEgcp();
            pwd = egcp.GCEUtilApp(pwd);
            serverUser = new ARServerUser("Remedy Application Service", pwd, pluginContext.getAuthString(), null, arServerName);
            String arServerPort = pluginContext.getARConfigEntry(TCD_SPECIFIC_PORT);
            int localServerPort = 0;
            if (null != arServerPort && arServerPort.length() > 0) {
                try {
                    localServerPort = Integer.parseInt(arServerPort);
                    if (localServerPort != 0) {
                        serverUser.setPort(localServerPort);
                    }
                }
                catch (NumberFormatException e) {
                    pluginContext.logMessage(1, "Failed to convert from String to int. The TCD-Specific-Port property with value:" + arServerPort + " as it configured in the ar.cfg");
                }
            }
            pluginContext.logMessage(0, "Created serverUser: " + serverUser);
            proxyInfo = ProxyUtil.getProxyInfoFromARForm(pluginContext, serverUser, arServerName);
        }
        finally {
            if (serverUser != null) {
                serverUser.logout();
            }
        }
        return proxyInfo;
    }

    private static ProxyInfo getProxyInfoFromARForm(ARPluginContext pluginContext, ARServerUser serverUser, String arServerName) throws ARException {
        ProxyInfo proxyInfo = null;
        String httpProxyHost = null;
        String httpProxyUser = null;
        String httpProxyPassword = null;
        int httpProxyPort = 80;
        ArithmeticOrRelationalOperand opField = new ArithmeticOrRelationalOperand(OperandType.FIELDID, 51001);
        ArithmeticOrRelationalOperand opValue = new ArithmeticOrRelationalOperand(new Value(arServerName + "%"));
        QualifierInfo qualifier = new QualifierInfo(new RelationalOperationInfo(7, opField, opValue));
        List entries = serverUser.getListEntryObjects(PROXY_SETTINGS_FORM, qualifier, 0, 0, null, new int[]{1, 51001, 51002, 51012, 51004, 123}, false, null);
        Entry entry = entries != null && !entries.isEmpty() ? (Entry)entries.get(0) : null;
        pluginContext.logMessage(0, "entry: " + entry);
        if (entry != null) {
            Object value = ((Value)entry.get((Object)51002)).getValue();
            if (value != null) {
                httpProxyHost = value.toString();
            }
            if ((value = ((Value)entry.get((Object)51012)).getValue()) != null) {
                String portString = value.toString();
                try {
                    httpProxyPort = Integer.parseInt(portString);
                }
                catch (NumberFormatException nfe) {
                    pluginContext.logMessage(1, "Wrong port number in config: " + portString + ", using default");
                }
            }
            if ((value = ((Value)entry.get((Object)51004)).getValue()) != null) {
                httpProxyUser = value.toString();
            }
            if ((value = ((Value)entry.get((Object)123)).getValue()) != null) {
                httpProxyPassword = new ARUtilEgcp().GCEUtil(value.toString());
            }
            pluginContext.logMessage(0, "Proxy parameters from config: host=" + httpProxyHost + ", port=" + httpProxyPort + ", user=" + httpProxyUser);
            proxyInfo = new ProxyInfo();
            proxyInfo.setHttpProxyHost(httpProxyHost);
            proxyInfo.setHttpProxyUser(httpProxyUser);
            proxyInfo.setHttpProxyPassword(httpProxyPassword);
            proxyInfo.setHttpProxyPort(httpProxyPort);
            proxyMap.put(arServerName, proxyInfo);
        }
        return proxyInfo;
    }
}

