/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.processors.impl;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.plugins.processors.IProcessor;
import com.bmc.arsys.plugins.processors.Job;
import com.bmc.arsys.plugins.processors.JobService;
import com.bmc.arsys.plugins.processors.SchedulerException;
import com.bmc.arsys.plugins.processors.ServerContext;
import com.bmc.arsys.plugins.processors.impl.ProcessorContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;

public class ProcessingThread
implements Runnable {
    private ARPluginContext mPluginContext;
    private IProcessor mProcessor = null;
    private Job mJob = null;

    public ProcessingThread(ARPluginContext context, IProcessor oProcessor, Job oJob) {
        this.mPluginContext = context;
        this.mProcessor = oProcessor;
        this.mJob = oJob;
    }

    @Override
    public void run() {
        try {
            ProcessorContext oContext = new ProcessorContext(this.mJob.getParams(), this.mJob.getJobItems());
            this.mProcessor.execute(oContext);
            this.mJob.setStatus(2);
        }
        catch (SchedulerException e) {
            this.mPluginContext.logMessage(2, "Internal Error - " + e.getMessage());
            this.mJob.setStatus(3);
            this.mJob.setMessage(e.getMessage());
        }
        try {
            this.mPluginContext.logMessage(0, "Updating Job status - " + this.mJob.getJobId());
            this.updateJob();
        }
        catch (ARException e) {
            this.mPluginContext.logMessage(2, "Failed to update Job - " + e.toString());
        }
    }

    private void updateJob() throws ARException {
        JobService oService = new JobService(this.mPluginContext);
        oService.updateJob(ServerContext.getServerUser(), this.mJob);
    }
}

