/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.processors.impl;

import com.bmc.arsys.plugins.processors.IProcessor;
import com.bmc.arsys.plugins.processors.SchedulerException;
import com.bmc.arsys.plugins.processors.impl.ExecInfo;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;

public class ExecFactory {
    private static List<ExecInfo> mlstProcessors = Collections.synchronizedList(new ArrayList());

    public static IProcessor getProcessorInstance(String szType) {
        for (ExecInfo execInfo : mlstProcessors) {
            if (!execInfo.getName().equalsIgnoreCase(szType)) continue;
            return execInfo.getProcessorInstance();
        }
        return null;
    }

    public static void readProcessors(ARPluginContext context) throws SchedulerException {
        ExecInfo exInfo = null;
        String execLocation = context.getConfigItem(context.getPluginInfo(), "execinstallpath");
        context.logMessage(context.getPluginInfo(), 0, "Loading executables from - " + execLocation);
        File exDir = new File(execLocation);
        if (!exDir.isDirectory()) {
            throw new SchedulerException("No such directory present - " + execLocation);
        }
        for (String entry : exDir.list()) {
            context.logMessage(context.getPluginInfo(), 0, "Loading executable - " + entry);
            File execDetails = new File(exDir.getAbsolutePath() + File.separator + entry, "details.txt");
            if (!execDetails.exists()) {
                throw new SchedulerException("Details information missing for executable - " + entry);
            }
            Properties pp = new Properties();
            InputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(execDetails));
                pp.load(is);
            }
            catch (IOException ioe) {
                throw new SchedulerException("IO Exception for executable - " + entry);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            exInfo = new ExecInfo();
            exInfo.setName(pp.getProperty("Name"));
            exInfo.setVersion(pp.getProperty("Version"));
            exInfo.setClassName(pp.getProperty("EntryClass"));
            File jarFile = new File(exDir + File.separator + exInfo.getName(), entry + ".jar");
            if (!jarFile.exists()) {
                throw new SchedulerException("No Local Executable JAR present for executable - " + entry);
            }
            exInfo.setJarFile(jarFile);
            mlstProcessors.add(exInfo);
        }
    }

    public static synchronized void loadProcessors(ARPluginContext context) throws SchedulerException {
        if (mlstProcessors.size() == 0) {
            ExecFactory.readProcessors(context);
            context.logMessage(context.getPluginInfo(), 0, "Total number of processors - " + mlstProcessors.size());
            ListIterator<ExecInfo> itProcessors = mlstProcessors.listIterator();
            while (itProcessors.hasNext()) {
                ((ExecInfo)itProcessors.next()).loadInstance(context);
            }
        }
    }
}

