/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.javascript;

import com.bmc.arsys.plugins.util.FileChangeListener;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoScriptFile
implements FileChangeListener {
    private Context context;
    private String filePath;
    private String sourceSnippet;
    private Scriptable scope;
    private Script script;
    private HashMap<String, Function> functionMap;
    private static int nextId = 1;

    public boolean isScriptFromFile() {
        return this.filePath != null;
    }

    public boolean isScriptFromBuffer() {
        return !this.isScriptFromFile();
    }

    public RhinoScriptFile(Context cx, Scriptable scope, String sourceSnippet) {
        this.setContext(cx);
        this.setScope(scope);
        this.setFilePath(null);
        this.setSourceSnippet(sourceSnippet);
        this.compileScript();
    }

    private void clearScriptCache() {
        this.functionMap = new HashMap();
        this.setCompiledScript(null);
    }

    private static synchronized int getNextId() {
        return nextId++;
    }

    private synchronized void compileScript() {
        this.clearScriptCache();
        InputStreamReader in = null;
        try {
            Script script = null;
            if (this.isScriptFromFile()) {
                in = new FileReader(this.filePath);
                script = this.context.compileReader((Reader)in, this.filePath, 1, null);
            } else {
                script = this.context.compileString(this.getSourceSnippet(), String.format("Script Id - %d.%d", Thread.currentThread().getId(), RhinoScriptFile.getNextId()), 1, null);
            }
            this.setCompiledScript(script);
            System.out.println("Successfully recompiled " + new Date(System.currentTimeMillis()).toString());
            if (this.isScriptFromFile()) {
                this.getCompiledScript().exec(this.getContext(), this.getScope());
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println("RHINO_PLUGIN_ERR_FILE_NOT_FOUND: Couldn't open file \"" + this.filePath + "\".");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fileChanged(String fileName) {
        System.out.println("File change detected at" + new Date(System.currentTimeMillis()).toString());
        this.setCompiledScript(null);
    }

    public static void main(String[] args) {
        try {
            Context cx = Context.enter();
            ScriptableObject scope = cx.initStandardObjects();
            RhinoScriptFile rsf = new RhinoScriptFile(cx, (Scriptable)scope, "C:\\Dev\\appajee\\Scripts\\rhino\\NumberConverter.js");
            System.out.println("Hit enter to exit");
            System.out.println("Compiled script is available " + (rsf.getCompiledScript() != null ? "Yes" : "No (null)"));
            System.out.println("convert(100, 10, 2) : " + rsf.execFunction("convert", 100, 10, 2));
            System.in.read();
            System.out.println("Compiled script is available " + (rsf.getCompiledScript() != null ? "Yes" : "No (null)"));
            System.out.println("convert(100, 10, 2) : " + rsf.execFunction("convert", 100, 10, 2));
            System.in.read();
            rsf.compileScript();
            System.out.println("Compiled script is available " + (rsf.getCompiledScript() != null ? "Yes" : "No (null)"));
            System.out.println("convert(100, 10, 2) : " + rsf.execFunction("convert", 100, 10, 2));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Script getCompiledScript() {
        if (this.script == null) {
            this.compileScript();
        }
        return this.script;
    }

    public Context getContext() {
        return this.context;
    }

    public String getFilePath() {
        return this.filePath;
    }

    private synchronized void setCompiledScript(Script compiledScript) {
        this.script = compiledScript;
    }

    private void setContext(Context context) {
        this.context = context;
    }

    private void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private Function findFunction(String functionName) {
        Function function = null;
        if (this.getCompiledScript() == null) {
            return function;
        }
        if (this.functionMap.containsKey(functionName)) {
            return this.functionMap.get(functionName);
        }
        Object fObj = this.scope.get(functionName, this.scope);
        if (fObj instanceof Function) {
            function = (Function)fObj;
        }
        this.functionMap.put(functionName, function);
        return function;
    }

    public Object exec(Object ... args) {
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"result", null);
        Object result = null;
        Object jsArgs = Context.javaToJS((Object)args, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"values", (Object)jsArgs);
        this.getCompiledScript().exec(this.getContext(), this.getScope());
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"values", null);
        result = this.scope.get("result", this.scope);
        if (result == Scriptable.NOT_FOUND) {
            System.out.println("result is not defined.");
        } else {
            System.out.println("result = " + Context.toString((Object)result));
        }
        return result;
    }

    public Object execFunction(String functionName, Object ... args) {
        Object result = null;
        Function f = this.findFunction(functionName);
        if (f == null) {
            System.out.println("f is undefined or not a function.");
        } else {
            result = f.call(this.getContext(), this.scope, this.scope, args);
            String report = "f('my args') = " + Context.toString((Object)result);
            System.out.println(report);
        }
        return result;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    private void setScope(Scriptable scope) {
        this.scope = scope;
    }

    public String getSourceSnippet() {
        return this.sourceSnippet;
    }

    public void setSourceSnippet(String snippet) {
        this.sourceSnippet = snippet;
    }
}

