/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsconfig.FtsConfigEntry;
import com.bmc.arsys.plugins.ftsconfig.FtsConfigEntryImpl;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.XMLParser;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import com.bmc.arsys.util.ArrayCentralConfig;
import com.bmc.arsys.util.CentralConfigFactory;
import com.bmc.arsys.utils.ARHostAddressUtil;
import com.bmc.thirdparty.org.apache.commons.lang.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTSConfigPlugin
extends ARDBCPlugin {
    private static final String ENTRY_ID_1 = "000000000000001";
    private static final String COMPONENT_TYPE_SERVER = "com.bmc.arsys.server";
    private static final String FULL_TEXT_MODE = "Full-Text-Mode";
    private static final String PLUGIN_ALIAS = "Server-Plugin-Alias";
    private static final String FTS_PLUGIN_NAME = "ARSYS.ARF.FTS";
    private static final String COMPONENT_TYPE_PLUGIN = "com.bmc.arsys.pluginServer";
    private static final String COMPONENT_NAME_PLUGIN = "/pluginsvr_config/pluginSvrName";
    private static final String PORT_FROM_CENTRAL = "port";
    private static final String PORT_FROM_FILE = "/pluginsvr_config/port";
    private static final Pattern SECONDARY_PATTERN;
    private static File arMonitorFile;
    private static File ftsSecondaryConfigFile;
    private static String ftsCorePath;
    private static String javaExeFilePath;
    private static File arHomeDir;
    private static File pluginsvrDir;
    private static String serverName;

    public static void init(ARPluginContext context) {
        String armonitorPath = context.getConfigItem("armonitorPath");
        File arMonitorDir = new File(armonitorPath);
        arMonitorFile = new File(arMonitorDir, "armonitor" + FTSConfFileHelper.getConfExtension());
        String ftsFolder = context.getConfigItem("ftsFolder");
        File ftsDir = new File(ftsFolder);
        File secondaryFtsDir = new File(ftsDir, "secondary");
        ftsSecondaryConfigFile = new File(secondaryFtsDir, "pluginsvr_config.xml");
        File ftsCoreDir = new File(ftsDir, "core");
        ftsCorePath = ftsCoreDir.getAbsolutePath();
        String ftsJavaPath = context.getConfigItem("ftsJavaPath");
        if ((ftsJavaPath = new File(ftsJavaPath).getAbsolutePath()).contains(" ")) {
            ftsJavaPath = "\"" + ftsJavaPath + "\"";
        }
        javaExeFilePath = ftsJavaPath;
        String arconfPath = context.getConfigItem("arconfPath");
        arHomeDir = new File(arconfPath);
        pluginsvrDir = new File(arHomeDir, "pluginsvr");
        serverName = context.getARConfigEntry("Server-Name");
    }

    private ARServerUser createConnection(ARPluginContext context) throws ARException {
        String serverName = context.getARConfigEntry("Server-Connect-Name");
        if (StringUtils.isEmpty((String)serverName) && StringUtils.isEmpty((String)(serverName = context.getARConfigEntry("Server-Name")))) {
            serverName = "localhost";
        }
        String portString = context.getARConfigEntry("TCD-Specific-Port");
        int tcpPort = 0;
        if (!StringUtils.isEmpty((String)portString)) {
            try {
                tcpPort = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ARServerUser connection = new ARServerUser((ARNativeAuthenticationInfo)context, "", serverName);
        if (tcpPort != 0) {
            connection.setPort(tcpPort);
        }
        connection.login();
        return connection;
    }

    public String createEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, Entry entry) throws ARException {
        context.logMessage(2, "cannot create an entry on " + tableName);
        throw new ARException(2, 8750);
    }

    public Entry getEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int[] idList) throws ARException {
        ARServerUser connection = this.createConnection(context);
        String componentName = context.getARConfigEntry("Configuration-Name");
        ArrayCentralConfig centralConfig = CentralConfigFactory.newInstance((ARServerUser)connection).newArrayCentralConfig();
        FtsConfigEntryImpl entry = this.createEntry(connection, centralConfig, componentName);
        return entry;
    }

    public void setEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, Entry entry, Timestamp getTimestamp) throws ARException {
        ARServerUser connection = this.createConnection(context);
        String componentName = context.getARConfigEntry("Configuration-Name");
        CentralConfigFactory factory = CentralConfigFactory.newInstance((ARServerUser)connection);
        ArrayCentralConfig centralConfig = factory.newArrayCentralConfig();
        FtsConfigEntryImpl existingEntry = this.createEntry(connection, centralConfig, componentName);
        FtsConfigEntryImpl mergedEntry = new FtsConfigEntryImpl();
        mergedEntry.putAll((Map)((Object)existingEntry));
        mergedEntry.putAll((Map)entry);
        boolean useAgent = mergedEntry.getFtsAgent();
        FtsConfigEntry.Mode mode = mergedEntry.getServerConfiguration();
        FullTextMode fullTextMode = !useAgent ? FullTextMode.DISABLED : (mode == FtsConfigEntry.Mode.SERVER_GROUP_PRIMARY ? FullTextMode.PRIMARY : (mode == FtsConfigEntry.Mode.SERVER_GROUP_SECONDARY ? FullTextMode.SECONDARY : FullTextMode.SINGLE_SERVER));
        if (entry.containsKey((Object)500007970) || entry.containsKey((Object)500007980)) {
            centralConfig.updateOrCreateSetting(null, componentName, COMPONENT_TYPE_SERVER, FULL_TEXT_MODE, fullTextMode.value());
        }
        ServerInfoMap serverInfos = new ServerInfoMap();
        Value collectionDirValue = (Value)entry.get((Object)16305);
        Value configDirValue = (Value)entry.get((Object)16323);
        if (collectionDirValue != null) {
            serverInfos.put((Object)231, (Object)collectionDirValue);
        }
        if (configDirValue != null) {
            serverInfos.put((Object)232, (Object)configDirValue);
        }
        if (!serverInfos.isEmpty()) {
            connection.setServerInfo(serverInfos);
        }
        switch (fullTextMode) {
            case SECONDARY: {
                StringBuilder builder = new StringBuilder();
                builder.append(FTS_PLUGIN_NAME).append(' ');
                builder.append(FTS_PLUGIN_NAME).append(' ');
                ARHostAddressUtil.combineHostPort((String)mergedEntry.getPrimaryServerName(), (int)mergedEntry.getFtsPort2(), (StringBuilder)builder);
                this.setFtsPluginAlias(centralConfig, componentName, builder.toString());
                this.disableFtsPluginServer();
                break;
            }
            case DISABLED: 
            case SINGLE_SERVER: {
                this.deleteFtsPluginAlias(connection, factory, componentName);
                this.disableFtsPluginServer();
                break;
            }
            case PRIMARY: {
                this.deleteFtsPluginAlias(connection, factory, componentName);
                this.setSecondaryPort(centralConfig, mergedEntry.getFtsPort2());
                this.enableFtsPluginServer(mergedEntry);
            }
        }
    }

    private void setFtsPluginAlias(ArrayCentralConfig centralConfig, String componentName, String newAliasValue) throws ARException {
        boolean updated = false;
        List settingEntries = centralConfig.getConfigSettingsWithEntryIDs(componentName, COMPONENT_TYPE_SERVER, PLUGIN_ALIAS);
        if (settingEntries != null) {
            String prefix = "ARSYS.ARF.FTS ";
            for (Entry settingEntry : settingEntries) {
                String value = centralConfig.getEntryValue(settingEntry);
                if (value == null || !value.startsWith(prefix)) continue;
                centralConfig.updateConfigSetting(settingEntry.getEntryId(), null, newAliasValue);
                updated = true;
            }
        }
        if (!updated) {
            String[] settingPair = new String[]{PLUGIN_ALIAS, newAliasValue};
            List<String[]> nameValuePair = Collections.singletonList(settingPair);
            centralConfig.createSettingEntries(null, componentName, COMPONENT_TYPE_SERVER, nameValuePair);
        }
    }

    private void deleteFtsPluginAlias(ARServerUser connection, CentralConfigFactory factory, String componentName) throws ARException {
        ArrayCentralConfig centralConfig = factory.newArrayCentralConfig();
        String joinFormName = factory.getJoinFormName();
        List settingEntries = centralConfig.getConfigSettingsWithEntryIDs(componentName, COMPONENT_TYPE_SERVER, PLUGIN_ALIAS);
        if (settingEntries != null) {
            String prefix = "ARSYS.ARF.FTS ";
            for (Entry settingEntry : settingEntries) {
                String value = centralConfig.getEntryValue(settingEntry);
                if (value == null || !value.startsWith(prefix)) continue;
                connection.deleteEntry(joinFormName, settingEntry.getEntryId(), 0);
            }
        }
    }

    private void disableFtsPluginServer() throws ARException {
        try {
            List<String> lines = FTSConfFileHelper.readLines(arMonitorFile, null);
            boolean update = false;
            ListIterator<String> itr = lines.listIterator();
            while (itr.hasNext()) {
                String line = itr.next();
                Matcher matcher = SECONDARY_PATTERN.matcher(line);
                if (!matcher.matches() || line.charAt(0) == '#') continue;
                line = "#" + line;
                itr.set(line);
                update = true;
            }
            if (update) {
                FTSConfFileHelper.writeLines(lines, arMonitorFile);
            }
        }
        catch (IOException e) {
            throw new ARException(2, 8753, "Error while trying to disable the secondary FTS plug-in server: " + e.getMessage());
        }
    }

    private void enableFtsPluginServer(FtsConfigEntry entry) throws ARException {
        String command = this.createCommand(entry);
        try {
            List<String> lines = FTSConfFileHelper.readLines(arMonitorFile, null);
            boolean update = false;
            ListIterator<String> itr = lines.listIterator();
            while (itr.hasNext()) {
                String line = itr.next();
                Matcher matcher = SECONDARY_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                itr.set(command);
                update = true;
                break;
            }
            if (!update) {
                lines.add(command);
            }
            FTSConfFileHelper.writeLines(lines, arMonitorFile);
        }
        catch (IOException e) {
            throw new ARException(2, 8753, "Error while trying to enable the secondary FTS plug-in server: " + e.getMessage());
        }
    }

    private String createCommand(FtsConfigEntry entry) {
        StringBuilder builder = new StringBuilder();
        builder.append(javaExeFilePath);
        builder.append(" -Xmx").append(entry.getMaxJvmMemory2()).append('m');
        StringBuilder classpathBuilder = new StringBuilder();
        classpathBuilder.append(ftsSecondaryConfigFile.getParent()).append(File.pathSeparatorChar);
        classpathBuilder.append(ftsCorePath).append(File.pathSeparatorChar);
        classpathBuilder.append(pluginsvrDir.getAbsolutePath()).append(File.pathSeparatorChar);
        File pluginJarFile = new File(pluginsvrDir, "arpluginsvr91_build001.jar");
        classpathBuilder.append(pluginJarFile.getAbsolutePath());
        String classpath = classpathBuilder.toString();
        builder.append(" -classpath ");
        if (classpath.contains(" ")) {
            builder.append('\"').append(classpath).append('\"');
        } else {
            builder.append(classpath);
        }
        builder.append(" com.bmc.arsys.pluginsvr.ARPluginServerMain -x ").append(serverName);
        builder.append(" -i ");
        String arHomePath = arHomeDir.getAbsolutePath();
        if (arHomePath.contains(" ")) {
            builder.append('\"').append(arHomePath).append('\"');
        } else {
            builder.append(arHomePath);
        }
        builder.append(" -m");
        String command = builder.toString();
        return command;
    }

    public void deleteEntry(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId) throws ARException {
        context.logMessage(2, "cannot delete an entry on " + tableName);
        throw new ARException(2, 8752);
    }

    public AttachmentValue getBLOB(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int fieldId) throws ARException {
        context.logMessage(2, "cannot get a BLOB on " + tableName);
        throw new ARException(2, 8754);
    }

    public void setBLOB(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, String entryId, int fieldId, AttachmentValue info) throws ARException {
        context.logMessage(2, "cannot set a BLOB on " + tableName);
        throw new ARException(2, 8754);
    }

    public List<Entry> getListEntryWithFields(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, List<SortInfo> sortList, List<EntryListFieldInfo> getListFields, int startAt, int maxRetrieve, OutputInteger numMatches) throws ARException {
        int[] idList = null;
        if (getListFields != null) {
            idList = new int[getListFields.size()];
            int i = 0;
            for (EntryListFieldInfo fieldInfo : getListFields) {
                idList[i] = fieldInfo.getFieldId();
                ++i;
            }
        }
        Entry entry = this.getEntry(context, tableName, fieldsList, transId, ENTRY_ID_1, idList);
        return Collections.singletonList(entry);
    }

    public List<StatisticsResultInfo> getEntryStatistics(ARPluginContext context, String tableName, List<ARVendorField> fieldsList, long transId, QualifierInfo qualifier, ArithmeticOrRelationalOperand target, int statistic, int[] groupByList) throws ARException {
        context.logMessage(2, "cannot perform statistics on " + tableName);
        throw new UnsupportedOperationException();
    }

    private FtsConfigEntryImpl createEntry(ARServerUser context, ArrayCentralConfig centralConfig, String componentName) throws ARException {
        FtsConfigEntryImpl entry = new FtsConfigEntryImpl();
        entry.setEntryId(ENTRY_ID_1);
        this.fillServerConfigSettings(entry, context, centralConfig, componentName);
        this.fillFtsReaderSettings(entry, context, centralConfig, componentName);
        return entry;
    }

    private void fillServerConfigSettings(FtsConfigEntryImpl entry, ARServerUser context, ArrayCentralConfig centralConfig, String componentName) throws ARException {
        List values;
        FullTextMode mode = FullTextMode.DISABLED;
        Map settings = centralConfig.getConfigSettingsAsMap(componentName, COMPONENT_TYPE_SERVER, FULL_TEXT_MODE);
        if (settings != null && (values = (List)settings.get(FULL_TEXT_MODE)) != null && !values.isEmpty()) {
            String value = (String)values.get(0);
            mode = FullTextMode.fromServerSetting(value);
        }
        boolean useAgent = mode != FullTextMode.DISABLED;
        entry.setFtsAgent(useAgent);
        entry.setServerConfiguration(mode.getMode());
        int[] serverInfoTags = new int[]{231, 232};
        ServerInfoMap serverInfo = context.getServerInfo(serverInfoTags);
        String collectionDir = null;
        Value value = (Value)serverInfo.get((Object)231);
        if (value != null) {
            collectionDir = (String)value.getValue();
        }
        entry.setFtsCollectionDir(collectionDir);
        String configDir = null;
        value = (Value)serverInfo.get((Object)232);
        if (value != null) {
            configDir = (String)value.getValue();
        }
        entry.setFtsConfigurationDir(configDir);
    }

    private void fillFtsReaderSettings(FtsConfigEntryImpl entry, ARServerUser context, ArrayCentralConfig centralConfig, String componentName) throws ARException {
        String hostname = null;
        Integer port = null;
        if (entry.getServerConfiguration() == FtsConfigEntry.Mode.SERVER_GROUP_SECONDARY) {
            List values;
            Map settings = centralConfig.getConfigSettingsAsMap(componentName, COMPONENT_TYPE_SERVER, PLUGIN_ALIAS);
            if (settings != null && (values = (List)settings.get(PLUGIN_ALIAS)) != null) {
                String prefix = "ARSYS.ARF.FTS ";
                for (String value : values) {
                    String[] parts;
                    if (value == null || !value.startsWith(prefix) || (parts = value.split(" ")).length < 3) continue;
                    String hostAndPort = parts[2];
                    String[] parameters = new String[2];
                    parameters = ARHostAddressUtil.parseConfigLine((String)hostAndPort, (String[])parameters);
                    hostname = parameters[0];
                    if (parameters[1] == null || parameters[1].length() == 0) continue;
                    try {
                        port = Integer.valueOf(parameters[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new ARException(2, 8753, "Error while parsing the port number from the FTS plug-in alias: " + e.getMessage());
                    }
                }
            }
            if (hostname == null) {
                hostname = context.getServer();
            }
            if (port == null) {
                port = this.getSecondaryPort(centralConfig);
            }
        } else {
            hostname = context.getServer();
            port = this.getSecondaryPort(centralConfig);
        }
        entry.setPrimaryServerName(hostname);
        entry.setFtsPort2(port);
        Integer maxMemory = this.getSecondaryMaxMemory();
        entry.setMaxJvmMemory2(maxMemory);
    }

    private Integer getSecondaryPort(ArrayCentralConfig centralConfig) throws ARException {
        List values;
        Map settings;
        XMLParser parser = null;
        try {
            parser = new XMLParser(ftsSecondaryConfigFile);
        }
        catch (Exception e) {
            throw new ARException(2, 8753, "Error while reading the secondary FTS plug-in server config file: " + e.getMessage());
        }
        String portStr = null;
        String componentName = null;
        try {
            componentName = parser.getNodeValue(COMPONENT_NAME_PLUGIN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (componentName != null && (settings = centralConfig.getConfigSettingsAsMap(componentName, COMPONENT_TYPE_PLUGIN, PORT_FROM_CENTRAL)) != null && (values = (List)settings.get(PORT_FROM_CENTRAL)) != null && !values.isEmpty()) {
            portStr = (String)values.get(0);
        }
        if (portStr == null) {
            try {
                portStr = parser.getNodeValue(PORT_FROM_FILE);
            }
            catch (Exception e) {
                throw new ARException(2, 8753, "Error while reading the port number from the secondary FTS plug-in server: /pluginsvr_config/port , The exception is: " + e.getMessage());
            }
        }
        Integer port = 0;
        if (portStr != null && portStr.length() > 0 && !portStr.equals("PLUGINPORT")) {
            try {
                port = Integer.valueOf(portStr);
            }
            catch (NumberFormatException e) {
                throw new ARException(2, 8753, "Error while parsing the port number from the secondary FTS plug-in server: " + e.getMessage());
            }
        }
        return port;
    }

    private void setSecondaryPort(ArrayCentralConfig centralConfig, Integer port) throws ARException {
        String portStr = port == null ? "0" : port.toString();
        try {
            XMLParser parser = new XMLParser(ftsSecondaryConfigFile);
            String componentName = null;
            try {
                componentName = parser.getNodeValue(COMPONENT_NAME_PLUGIN);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List settings = centralConfig.getConfigSettingsWithEntryIDs(componentName, COMPONENT_TYPE_PLUGIN, PORT_FROM_CENTRAL);
            if (settings == null || settings.isEmpty()) {
                parser.updateNodeValue(PORT_FROM_FILE, portStr);
                parser.commit();
            } else {
                Entry setting = (Entry)settings.get(0);
                centralConfig.updateConfigSetting(setting.getEntryId(), null, portStr);
            }
        }
        catch (ARException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ARException(2, 8753, "Error while writing the port number to the secondary FTS plug-in server: " + e.getMessage());
        }
    }

    private Integer getSecondaryMaxMemory() throws ARException {
        Integer maxMemory = null;
        String line = this.getSecondaryCommand();
        if (line != null) {
            String[] parts;
            for (String part : parts = line.split(" +")) {
                if (!part.startsWith("-Xmx")) continue;
                String maxMemoryStr = part.substring(4, part.length() - 1);
                try {
                    maxMemory = Integer.valueOf(maxMemoryStr);
                }
                catch (NumberFormatException e) {
                    throw new ARException(2, 8753, "Error while parsing the max heap size of the secondary FTS plug-in server: " + e.getMessage());
                }
            }
        }
        return maxMemory;
    }

    private String getSecondaryCommand() throws ARException {
        List<String> lines = null;
        try {
            lines = FTSConfFileHelper.readLines(arMonitorFile, null);
        }
        catch (IOException e) {
            throw new ARException(2, 8753, "Error while reading the AR Monitor config file: " + e.getMessage());
        }
        if (lines != null) {
            for (String line : lines) {
                Matcher matcher = SECONDARY_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                return line;
            }
        }
        return null;
    }

    static {
        char separator = File.separatorChar;
        String pattern = separator == '\\' ? ".*fts\\\\secondary.*" : ".*fts" + separator + "secondary.*";
        SECONDARY_PATTERN = Pattern.compile(pattern);
    }

    private static enum FullTextMode {
        DISABLED("Disabled", FtsConfigEntry.Mode.SINGLE_SERVER),
        SINGLE_SERVER("Single-Server", FtsConfigEntry.Mode.SINGLE_SERVER),
        PRIMARY("Server-Group-primary", FtsConfigEntry.Mode.SERVER_GROUP_PRIMARY),
        SECONDARY("Server-Group-secondary", FtsConfigEntry.Mode.SERVER_GROUP_SECONDARY);

        private String value;
        private FtsConfigEntry.Mode mode;

        private FullTextMode(String value, FtsConfigEntry.Mode mode) {
            this.value = value;
            this.mode = mode;
        }

        public String value() {
            return this.value;
        }

        public FtsConfigEntry.Mode getMode() {
            return this.mode;
        }

        public static FullTextMode fromServerSetting(String value) {
            for (FullTextMode mode : FullTextMode.values()) {
                if (!mode.value.equals(value)) continue;
                return mode;
            }
            return DISABLED;
        }
    }
}

