/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.configchecker.ArConfHelper;
import com.bmc.arsys.plugins.configchecker.CheckResultNotifier;
import com.bmc.arsys.plugins.configchecker.CheckStatus;
import com.bmc.arsys.plugins.configchecker.Messages;
import com.bmc.arsys.plugins.configchecker.ServerContext;
import com.bmc.arsys.plugins.configchecker.UDMCheckBase;
import com.bmc.arsys.plugins.configchecker.UdmChecker;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.XMLParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UDMServerConfCheck
extends UDMCheckBase {
    private static int FILTER_MAX_TOTAL = 500000;
    private static int FILTER_MAX_STACK = 10000;

    public UDMServerConfCheck(UdmChecker.UDMChecks name, ServerContext serverContext, CheckResultNotifier notifyUpdate) {
        super(name, serverContext, notifyUpdate);
    }

    @Override
    public void run() throws Exception {
        ServerInfoMap parmMap;
        logger.debug((Object)"UDMServerConfCheck::run -> in ");
        if (this.serverContext == null || this.notifyUpdate == null) {
            throw new Exception("UDMServerConfCheck::run  either serverContext or notifyUpdate is null");
        }
        int[] req = new int[]{143, 79, 80};
        try {
            parmMap = this.serverContext.getUser().getServerInfo(req);
        }
        catch (ARException e) {
            logger.debug((Object)e.toString());
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_ARGETPARM.toString(), e.getMessage()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_QUERY.toString()));
            return;
        }
        int escalationD = ((Value)parmMap.get((Object)143)).getIntValue();
        int maxFilter = ((Value)parmMap.get((Object)79)).getIntValue();
        int maxFilterStack = ((Value)parmMap.get((Object)80)).getIntValue();
        if (escalationD == 1 && !ArConfHelper.isServerGroupEnv(this.serverContext.getUser())) {
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_ESC_DIS_LOCALHOST.toString() + this.serverContext.getUser().getServer(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_ESC_DIS_LOCALHOST.toString()));
        }
        if (maxFilter < FILTER_MAX_TOTAL) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_FILTER_MAX_TOTAL.toString(), maxFilter, FILTER_MAX_TOTAL), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_FILTER_MAX_TOTAL.toString()));
        }
        if (maxFilterStack < FILTER_MAX_STACK) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_FILTER_MAX_STACK.toString(), maxFilterStack, FILTER_MAX_STACK), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_FILTER_MAX_STACK.toString()));
        }
        this.checkCAIForPrivateRPC();
        logger.debug((Object)"UDMServerConfCheck::run -> out ");
    }

    private void checkCAIForPrivateRPC() {
        String portNumber = this.getPluginsvrPort("REMEDY.ARF.CAI");
        if (portNumber != null && portNumber.length() > 0) {
            int portNum = Integer.parseInt(portNumber);
            if (!this.checkCAIRPCPrivate(portNum)) {
                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_PLUGIN_PRIVATE_RPC.toString(), "REMEDY.ARF.CAI", portNumber), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_PLUGIN_PRIVATE_RPC.toString()));
            } else {
                this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_INFO_PLUGIN_PRIVATE_RPC.toString(), CheckStatus.MessageType.INFO, Messages.UDM_CHECK_INFO_PLUGIN_PRIVATE_RPC.toString()));
            }
        }
    }

    private String getPluginsvrPort(String pluginName) {
        String pluginRPCNum = null;
        boolean caiPluginFound = false;
        String xmlPath = this.serverContext.getInstallDir() + File.separator + "pluginsvr" + File.separator + "pluginsvr_config.xml";
        try {
            XMLParser parser = new XMLParser(xmlPath);
            List<Node> plugin_nodes = parser.getNodeList("/pluginsvr_config/plugins/plugin");
            for (Node plguin_node : plugin_nodes) {
                Element eElement;
                if (plguin_node.getNodeType() != 1 || !(eElement = (Element)plguin_node).getElementsByTagName("name").item(0).getTextContent().contains(pluginName)) continue;
                caiPluginFound = true;
                Element userDef = (Element)eElement.getElementsByTagName("userDefined").item(0);
                NodeList nL = userDef.getElementsByTagName("Private-RPC-Socket");
                if (nL.getLength() > 0) {
                    pluginRPCNum = userDef.getElementsByTagName("Private-RPC-Socket").item(0).getTextContent();
                    System.out.println(pluginRPCNum);
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug((Object)("ARException: " + e.getMessage()));
        }
        if (!caiPluginFound) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_PLUGIN_CONFIG.toString(), pluginName, xmlPath), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_PLUGIN_CONFIG.toString()));
        }
        return pluginRPCNum;
    }

    private boolean checkCAIRPCPrivate(int caiRPCNumber) {
        ArrayList<String> resultList;
        boolean portConfigured = false;
        String arConfFile = this.serverContext.getInstallDir() + File.separator + ArConfHelper.getArConfName();
        if (!ArConfHelper.parseARConfigParam(arConfFile, "PRIVATE-RPC-SOCKET", resultList = new ArrayList<String>())) {
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_PRIVATE_RPC.toString(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_PRIVATE_RPC.toString()));
            return false;
        }
        if (resultList.size() > 0) {
            for (String currentRecord : resultList) {
                String val = currentRecord.trim();
                String portVal = val.substring(0, val.indexOf(" "));
                int portNum = Integer.parseInt(portVal);
                if (portNum != caiRPCNumber) continue;
                portConfigured = true;
                break;
            }
        }
        return portConfigured;
    }
}

