/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.configchecker;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.configchecker.ArConfHelper;
import com.bmc.arsys.plugins.configchecker.CheckResultNotifier;
import com.bmc.arsys.plugins.configchecker.CheckStatus;
import com.bmc.arsys.plugins.configchecker.Messages;
import com.bmc.arsys.plugins.configchecker.ServerContext;
import com.bmc.arsys.plugins.configchecker.UDMCheckBase;
import com.bmc.arsys.plugins.configchecker.UdmChecker;
import java.io.File;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UDMConfig
extends UDMCheckBase {
    List<UDMconfigEntry> sList = null;
    private static final String FORM_NAME = "UDM:Config";
    private static final String PENTAHO_PLUGIN_VENDOR_FORM = "UDM:ExecutionStatus";
    private static int REPO_PROG_NUM = 46099;
    private static int ATRIUM_ENGINE_SERVER_NAME = 46087;
    private static int HOST_NAME = 46021;
    private static int HOST_PORT = 46022;
    private static int IS_DEFAULT_CARTE_SERVER = 46023;
    Map<String, String> serRAppPassColl = null;

    public UDMConfig(UdmChecker.UDMChecks name, ServerContext serverContext, CheckResultNotifier notifyUpdate) {
        super(name, serverContext, notifyUpdate);
    }

    @Override
    public void run() throws Exception {
        this.performValidation();
    }

    public void queryUDMConfig() {
        for (UDMconfigEntry en : this.sList) {
            String hostname = en.hostName;
            try {
                Socket soc = new Socket(hostname, en.cartePortNumber);
                if (soc.isConnected()) continue;
                logger.debug((Object)("Connection failed to carte server: " + hostname));
                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_CARTE_CONN.toString(), hostname, en.cartePortNumber), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_CARTE_CONN.toString()));
            }
            catch (Exception e) {
                logger.debug((Object)e.getMessage());
                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_CARTE_CONN2.toString(), hostname, en.cartePortNumber, e.getMessage()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_CARTE_CONN2.toString()));
            }
        }
    }

    public void performValidation() {
        this.sList = this.queryUDMConfigFom();
        String arConfFile = this.serverContext.getInstallDir() + File.separator + ArConfHelper.getArConfName();
        String localHostName = ArConfHelper.getLocalServerName(arConfFile);
        this.verifyLocalNamePresentInUdmConfig(localHostName);
        this.queryUDMConfig();
        HashMap<String, String> members = ArConfHelper.isItServerGroupEnv(this.serverContext.getUser());
        if (members.size() > 1) {
            this.verifyServerGroupMember(members);
            this.verifyRAppPassword(members);
            this.verifyEscInServerGrpEnv(members, localHostName);
        }
    }

    private void verifyRAppPassword(HashMap<String, String> members) {
        try {
            this.serRAppPassColl = ArConfHelper.getServerRAppPaswordColl(this.serverContext.getUser());
        }
        catch (ARException ex) {
            logger.debug((Object)ex.toString());
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_RAPP_QUERY.toString() + ": " + ex.getMessage(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_QUERY.toString()));
            return;
        }
        if (this.serRAppPassColl == null || this.serRAppPassColl.size() == 0) {
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_RAPP_FORM_EMPTY.toString(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_PAAWD_EMPTY.toString()));
            return;
        }
        Set<String> keys = members.keySet();
        for (String server : keys) {
            String passWd = this.serRAppPassColl.get(server);
            if (passWd != null) continue;
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_RAPP_LH_MISSING.toString(), server), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_MISSING.toString()));
        }
    }

    private void verifyEscInServerGrpEnv(HashMap<String, String> members, String localHostName) {
        Set<String> keys = members.keySet();
        int escalationD = 1;
        ArrayList<String> escMembers = new ArrayList<String>();
        for (String server : keys) {
            try {
                ARServerUser lUser = new ARServerUser(this.serverContext.getUser().getUser(), this.serverContext.getUser().getPassword(), null, server, this.serverContext.getUser().getPort());
                int[] req = new int[]{143};
                ServerInfoMap parmMap = null;
                parmMap = lUser.getServerInfo(req);
                escalationD = ((Value)parmMap.get((Object)143)).getIntValue();
                System.out.println("Escaltions disable Flag, " + server + ": " + escalationD);
                if (escalationD == 0) {
                    escMembers.add(server);
                }
                lUser.logout();
            }
            catch (ARException e) {
                logger.debug((Object)("Failed to query server parameters through GSI call " + e.getMessage()));
                this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_ARGETPARM.toString(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_QUERY.toString()));
                return;
            }
        }
        if (escMembers.size() == 0) {
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_ESC_DIS.toString(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_ESC.toString()));
        } else if (escMembers.size() == 1) {
            System.out.println("localHostName:  " + localHostName + " escHHost: " + (String)escMembers.get(0));
            if (localHostName.equalsIgnoreCase((String)escMembers.get(0))) {
                this.queryPentahoPlugin((String)escMembers.get(0));
            } else {
                this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_INFO_ESC_ONLY_MEMBER.toString(), escMembers.get(0)), CheckStatus.MessageType.INFO, Messages.UDM_CHECK_HINT_ESC.toString()));
                this.queryPentahoPlugin((String)escMembers.get(0));
            }
        } else if (escMembers.size() > 0) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_INFO_ESC_MEMBERS.toString(), escMembers.size(), ((Object)escMembers).toString()), CheckStatus.MessageType.WARNING, null));
        }
    }

    private void queryPentahoPlugin(String svgMember) {
        if (this.serRAppPassColl == null || svgMember == null) {
            this.notifyUpdate.addResult(this.getCheckStatus(Messages.UDM_CHECK_FAIL_CONFIG_PENTAHO_PLUGIN.toString(), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_PENTAHO_PLUGIN.toString()));
            return;
        }
        String rAppPassword = this.serRAppPassColl.get(svgMember);
        if (rAppPassword == null) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_PENTAHO_RAPP_FAILED.toString(), svgMember), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_PENTAHO_RAPP_FAILED.toString()));
            return;
        }
        ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(new Value(1));
        ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(1));
        RelationalOperationInfo relOp = new RelationalOperationInfo(1, op1, op2);
        QualifierInfo defaultQualifier = new QualifierInfo(relOp);
        SortInfo sortInfo = new SortInfo(46034, 1);
        ArrayList<SortInfo> sortList = new ArrayList<SortInfo>(1);
        sortList.add(sortInfo);
        int[] fieldIds = new int[]{46034};
        try {
            List entryList;
            block8: {
                ARServerUser user = new ARServerUser("Remedy Application Service", rAppPassword, null, svgMember, this.serverContext.getUser().getPort());
                user.login();
                entryList = null;
                try {
                    entryList = user.getListEntryObjects(PENTAHO_PLUGIN_VENDOR_FORM, defaultQualifier, 0, 0, sortList, fieldIds, false, null);
                }
                catch (ARException ex) {
                    if (!ex.toString().contains("8755")) break block8;
                    this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_PENTAHO_PLUGIN_RUN.toString(), svgMember, ex.toString()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_PENTAHO_PLUGIN_RUN.toString()));
                }
            }
            if (entryList != null) {
                for (Entry entry : entryList) {
                    Value val = (Value)entry.get((Object)46034);
                    if (val.toString() == null || val.toString().length() <= 0) continue;
                    String member = val.toString();
                    System.out.println(member);
                }
            }
        }
        catch (ARException ex) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_PENTAHO_PLUGIN_STAUS.toString(), svgMember, ex.toString()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_PENTAHO_PLUGIN_STAUS.toString()));
        }
    }

    private void verifyServerGroupMember(HashMap<String, String> members) {
        Set<String> keys = members.keySet();
        for (String key : keys) {
            String ip;
            if (this.lookUpUDMConfig(key) || this.lookUpUDMConfig(ip = members.get(key))) continue;
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_MISSING_MEMBER.toString(), key), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_MISSING_MEMBER.toString()));
        }
    }

    private boolean lookUpUDMConfig(String hName) {
        for (UDMconfigEntry en : this.sList) {
            if (!en.carteServerName.equalsIgnoreCase(hName) && (en.carteServerIPAddr == null || !en.carteServerIPAddr.equalsIgnoreCase(hName))) continue;
            return true;
        }
        return false;
    }

    private void verifyLocalNamePresentInUdmConfig(String localName) {
        if (localName == null) {
            logger.debug((Object)"verifyLocalNamePresentInUdmConfig: null arg");
            return;
        }
        for (UDMconfigEntry en : this.sList) {
            String hostname = en.carteServerName;
            if (!hostname.equalsIgnoreCase(localName)) continue;
            return;
        }
        this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_MISSING_LOCALH.toString(), localName), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_CONFIG_MISSING_MEMBER.toString()));
    }

    public List<UDMconfigEntry> queryUDMConfigFom() {
        ArithmeticOrRelationalOperand op1 = new ArithmeticOrRelationalOperand(new Value(1));
        ArithmeticOrRelationalOperand op2 = new ArithmeticOrRelationalOperand(new Value(1));
        RelationalOperationInfo relOp = new RelationalOperationInfo(1, op1, op2);
        QualifierInfo defaultQualifier = new QualifierInfo(relOp);
        SortInfo sortInfo = new SortInfo(1, 1);
        ArrayList<SortInfo> sortList = new ArrayList<SortInfo>(1);
        sortList.add(sortInfo);
        int[] fieldIds = new int[]{REPO_PROG_NUM, ATRIUM_ENGINE_SERVER_NAME, HOST_NAME, HOST_PORT, IS_DEFAULT_CARTE_SERVER};
        ArrayList<UDMconfigEntry> udmConfigColl = null;
        try {
            List entryList = this.serverContext.getUser().getListEntryObjects(FORM_NAME, defaultQualifier, 0, 0, sortList, fieldIds, false, null);
            udmConfigColl = new ArrayList<UDMconfigEntry>();
            if (entryList != null) {
                for (Entry entry : entryList) {
                    UDMconfigEntry en = new UDMconfigEntry();
                    Value val = (Value)entry.get((Object)REPO_PROG_NUM);
                    if (val.toString() != null && val.toString().length() > 0) {
                        en.rpcProgNumber = Integer.parseInt(val.toString());
                    }
                    if ((val = (Value)entry.get((Object)ATRIUM_ENGINE_SERVER_NAME)).toString() != null && val.toString().length() > 0) {
                        en.carteServerName = val.toString().toUpperCase();
                        String[] ip = ArConfHelper.getIpAddresses(en.carteServerName);
                        if (ip != null && ip.length > 0) {
                            en.carteServerIPAddr = ip[0];
                            System.out.println("UDM:Config: " + en.carteServerName + ":" + ip[0]);
                        }
                    }
                    if ((val = (Value)entry.get((Object)HOST_NAME)).toString() != null && val.toString().length() > 0) {
                        en.hostName = val.toString().toUpperCase();
                    }
                    if ((val = (Value)entry.get((Object)HOST_PORT)).toString() != null && val.toString().length() > 0) {
                        en.cartePortNumber = Integer.parseInt(val.toString());
                    }
                    if ((val = (Value)entry.get((Object)IS_DEFAULT_CARTE_SERVER)).toString() != null && val.toString().length() > 0) {
                        en.isDefault = Integer.parseInt(val.toString());
                    }
                    udmConfigColl.add(en);
                }
            }
        }
        catch (ARException e) {
            this.notifyUpdate.addResult(this.getCheckStatus(String.format(Messages.UDM_CHECK_FAIL_CONFIG_QUERY.toString(), FORM_NAME, e.getMessage()), CheckStatus.MessageType.ERROR, Messages.UDM_CHECK_HINT_RAPP_QUERY.toString()));
        }
        return udmConfigColl;
    }

    class UDMconfigEntry {
        public int rpcProgNumber;
        public String carteServerName;
        public String carteServerIPAddr;
        public String hostName;
        public int cartePortNumber;
        public int isDefault;

        UDMconfigEntry() {
        }
    }
}

