/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wseb;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.DecoderInput;
import com.kaazing.gateway.client.html5.impl.bridge.HttpRequestBridgeHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequest;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestHandler;
import com.kaazing.gateway.client.html5.impl.http.HttpRequestListener;
import com.kaazing.gateway.client.html5.impl.http.HttpResponse;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketReAuthenticateHandler;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamChannel;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandler;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandlerFactory;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandlerListener;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedChannel;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedDecoder;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedDecoderListener;
import com.kaazing.gateway.client.html5.util.HexUtil;
import com.kaazing.gateway.client.html5.util.HttpURI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

class DownstreamHandlerImpl
implements DownstreamHandler {
    private static final String CLASS_NAME = DownstreamHandlerImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static DownstreamHandlerFactory FACTORY = new DownstreamHandlerFactory(){

        @Override
        public DownstreamHandler createDownstreamHandler() {
            return new DownstreamHandlerImpl();
        }
    };
    private static final int PROXY_MODE_TIMEOUT_MILLIS = 5000;
    private HttpRequestHandler nextHandler;
    private DownstreamHandlerListener listener;
    DecoderInput<DownstreamChannel> in = new DecoderInput<DownstreamChannel>(){

        @Override
        public ByteBuffer read(DownstreamChannel channel) {
            return channel.buffersToRead.poll();
        }
    };

    DownstreamHandlerImpl() {
        LOG.entering(CLASS_NAME, "<init>");
        HttpRequestBridgeHandler bridgeHandler = new HttpRequestBridgeHandler();
        this.setNextHandler(bridgeHandler);
    }

    @Override
    public void processConnect(DownstreamChannel channel, HttpURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "processConnect");
        this.makeRequest(channel, uri, protocol);
    }

    private void makeRequest(final DownstreamChannel channel, HttpURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "makeRequest");
        try {
            HttpURI requestUri = HttpURI.replaceScheme(uri.getURI(), uri.getScheme().replaceAll("ws", "http"));
            HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.POST, requestUri, true);
            request.parent = channel;
            channel.outstandingRequests.add(request);
            if (channel.cookie != null) {
                request.setHeader("Cookie", channel.cookie);
            }
            this.nextHandler.processOpen(request);
            if (channel.attemptProxyModeFallback.get()) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        DownstreamHandlerImpl.this.fallbackToProxyMode(channel);
                    }
                };
                new Timer().schedule(timerTask, 5000L);
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.downstreamFailed(channel);
        }
    }

    private void fallbackToProxyMode(DownstreamChannel channel) {
        if (channel.attemptProxyModeFallback.get()) {
            LOG.fine("useProxyMode");
            channel.attemptProxyModeFallback.set(false);
            HttpURI uri = channel.location;
            if (!uri.getQuery().contains(".ki=p")) {
                channel.location = uri = (HttpURI)channel.location.addQueryParameter(".ki=p");
            }
            this.makeRequest(channel, uri, channel.protocol);
        }
    }

    private void reconnect(DownstreamChannel channel) {
        LOG.entering(CLASS_NAME, "reconnect");
        if (channel.reconnecting.compareAndSet(true, false)) {
            LOG.fine("Reconnecting: " + channel);
            this.makeRequest(channel, channel.location, channel.protocol);
        } else {
            LOG.fine("Closing: " + channel);
            this.listener.downstreamClosed(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processProgressEvent(DownstreamChannel channel, ByteBuffer buffer) {
        LOG.entering(CLASS_NAME, "processProgressEvent", buffer);
        try {
            channel.buffersToRead.add(buffer);
            WebSocketEmulatedDecoderListener<DownstreamChannel> decoderListener = new WebSocketEmulatedDecoderListener<DownstreamChannel>(){

                @Override
                public void messageDecoded(DownstreamChannel channel, ByteBuffer message) {
                    DownstreamHandlerImpl.this.processMessage(channel, message);
                }

                @Override
                public void commandDecoded(DownstreamChannel channel, ByteBuffer command) {
                    if (command.get() == 1) {
                        LOG.fine("Reconnect command");
                        channel.reconnecting.set(true);
                    }
                }
            };
            WebSocketEmulatedDecoder<DownstreamChannel> webSocketEmulatedDecoder = channel.decoder;
            synchronized (webSocketEmulatedDecoder) {
                channel.decoder.decode(channel, this.in, decoderListener);
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.downstreamFailed(channel);
        }
    }

    private void processMessage(DownstreamChannel channel, ByteBuffer message) {
        if (channel.isEscape.compareAndSet(true, false)) {
            this.listener.messageReceived(channel, message);
        } else {
            int position = message.position();
            byte[] escape = this.getMessageFrameType(channel, message);
            if (escape == null) {
                message.position(position);
                this.listener.messageReceived(channel, message);
            } else if (!message.hasRemaining()) {
                channel.isEscape.compareAndSet(false, true);
            } else {
                int key = HexUtil.byteArrayToInt(escape, 0);
                String controlMessage = message.getString(Charset.forName("UTF-8")).trim();
                if ("x-kaazing-http-revalidate".equals(channel.controlFrames.get(key))) {
                    this.handleReAuthenticationRequested(channel, controlMessage, "x-kaazing-http-revalidate");
                }
            }
        }
    }

    private byte[] getMessageFrameType(DownstreamChannel channel, ByteBuffer message) {
        byte[] result = null;
        if (message.remaining() < 4) {
            return result;
        }
        byte[] prefix = new byte[4];
        message.get(prefix);
        if (channel.controlFrames.containsKey(HexUtil.byteArrayToInt(prefix, 0))) {
            result = prefix;
        }
        return result;
    }

    void handleReAuthenticationRequested(DownstreamChannel channel, String location, String challenge) {
        LOG.entering(CLASS_NAME, "handleAuthenticationRequested");
        String url = channel.location.getScheme() + "://" + channel.location.getURI().getAuthority() + location;
        WebSocketReAuthenticateHandler reAuthHandler = new WebSocketReAuthenticateHandler();
        try {
            WebSocketEmulatedChannel parent = (WebSocketEmulatedChannel)channel.getParent();
            if (parent.redirectUri != null) {
                url = parent.redirectUri.getScheme() + "://" + parent.redirectUri.getURI().getAuthority() + location;
            }
            WebSocketEmulatedChannel revalidateChannel = new WebSocketEmulatedChannel(parent.getLocation(), parent.getProtocol(), parent.isBinary);
            revalidateChannel.redirectUri = parent.redirectUri;
            reAuthHandler.processOpen(revalidateChannel, new HttpURI(url));
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void processClose(DownstreamChannel channel) {
        LOG.entering(CLASS_NAME, "stop");
        for (HttpRequest request : channel.outstandingRequests) {
            this.nextHandler.processAbort(request);
        }
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                DownstreamHandlerImpl.this.nextHandler.processSend(request, ByteBuffer.wrap(">|<".getBytes()));
            }

            @Override
            public void requestOpened(HttpRequest request) {
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                channel.attemptProxyModeFallback.set(false);
                DownstreamHandlerImpl.this.listener.downstreamOpened(channel);
            }

            @Override
            public void requestProgressed(HttpRequest request, ByteBuffer payload) {
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                DownstreamHandlerImpl.this.processProgressEvent(channel, payload);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                LOG.entering(CLASS_NAME, "requestLoaded", request);
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                DownstreamHandlerImpl.this.reconnect(channel);
            }

            @Override
            public void requestClosed(HttpRequest request) {
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                channel.outstandingRequests.remove(request);
            }

            @Override
            public void errorOccurred(HttpRequest request) {
                LOG.entering(CLASS_NAME, "errorOccurred", request);
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                DownstreamHandlerImpl.this.listener.downstreamFailed(channel);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                LOG.entering(CLASS_NAME, "errorOccurred", request);
            }
        });
    }

    @Override
    public void setListener(DownstreamHandlerListener listener) {
        this.listener = listener;
    }
}

