/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.event;

import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.context.ApplicationEvent;
import com.bmc.thirdparty.org.springframework.context.ApplicationListener;
import com.bmc.thirdparty.org.springframework.context.event.AbstractApplicationEventMulticaster;
import com.bmc.thirdparty.org.springframework.util.ErrorHandler;
import java.util.concurrent.Executor;

public class SimpleApplicationEventMulticaster
extends AbstractApplicationEventMulticaster {
    private Executor taskExecutor;
    private ErrorHandler errorHandler;

    public SimpleApplicationEventMulticaster() {
    }

    public SimpleApplicationEventMulticaster(BeanFactory beanFactory) {
        this.setBeanFactory(beanFactory);
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected Executor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void multicastEvent(final ApplicationEvent event) {
        for (final ApplicationListener<?> listener : this.getApplicationListeners(event)) {
            Executor executor = this.getTaskExecutor();
            if (executor != null) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        SimpleApplicationEventMulticaster.this.invokeListener(listener, event);
                    }
                });
                continue;
            }
            this.invokeListener(listener, event);
        }
    }

    protected void invokeListener(ApplicationListener listener, ApplicationEvent event) {
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            try {
                listener.onApplicationEvent(event);
            }
            catch (Throwable err) {
                errorHandler.handleError(err);
            }
        } else {
            listener.onApplicationEvent(event);
        }
    }
}

