/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.springframework.beans.factory.BeanClassLoaderAware;
import com.bmc.thirdparty.org.springframework.beans.factory.annotation.Autowired;
import com.bmc.thirdparty.org.springframework.context.annotation.AnnotationConfigUtils;
import com.bmc.thirdparty.org.springframework.context.annotation.Bean;
import com.bmc.thirdparty.org.springframework.context.annotation.Configuration;
import com.bmc.thirdparty.org.springframework.context.annotation.EnableLoadTimeWeaving;
import com.bmc.thirdparty.org.springframework.context.annotation.ImportAware;
import com.bmc.thirdparty.org.springframework.context.annotation.LoadTimeWeavingConfigurer;
import com.bmc.thirdparty.org.springframework.context.annotation.Role;
import com.bmc.thirdparty.org.springframework.context.weaving.AspectJWeavingEnabler;
import com.bmc.thirdparty.org.springframework.context.weaving.DefaultContextLoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.core.annotation.AnnotationAttributes;
import com.bmc.thirdparty.org.springframework.core.type.AnnotatedTypeMetadata;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.instrument.classloading.LoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.util.Assert;

@Configuration
public class LoadTimeWeavingConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private AnnotationAttributes enableLTW;
    @Autowired(required=false)
    private LoadTimeWeavingConfigurer ltwConfigurer;
    private ClassLoader beanClassLoader;

    @Override
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableLTW = AnnotationConfigUtils.attributesFor((AnnotatedTypeMetadata)importMetadata, EnableLoadTimeWeaving.class);
        Assert.notNull(this.enableLTW, "@EnableLoadTimeWeaving is not present on importing class " + importMetadata.getClassName());
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Bean(name={"loadTimeWeaver"})
    @Role(value=2)
    public LoadTimeWeaver loadTimeWeaver() {
        LoadTimeWeaver loadTimeWeaver = null;
        if (this.ltwConfigurer != null) {
            loadTimeWeaver = this.ltwConfigurer.getLoadTimeWeaver();
        }
        if (loadTimeWeaver == null) {
            loadTimeWeaver = new DefaultContextLoadTimeWeaver(this.beanClassLoader);
        }
        EnableLoadTimeWeaving.AspectJWeaving aspectJWeaving = (EnableLoadTimeWeaving.AspectJWeaving)((Object)this.enableLTW.getEnum("aspectjWeaving"));
        switch (aspectJWeaving) {
            case DISABLED: {
                break;
            }
            case AUTODETECT: {
                if (this.beanClassLoader.getResource("META-INF/aop.xml") == null) break;
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
                break;
            }
            case ENABLED: {
                AspectJWeavingEnabler.enableAspectJWeaving(loadTimeWeaver, this.beanClassLoader);
            }
        }
        return loadTimeWeaver;
    }
}

