/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.qual;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.qual.ARParseFormatInfo;
import com.bmc.arsys.qual.Formatter;
import org.apache.log4j.Logger;

public class ARQualifierFormatter
extends Formatter {
    static final Logger logger = Logger.getLogger(ARQualifierFormatter.class);

    public ARQualifierFormatter(ARParseFormatInfo formatInfo) {
        this.formatInfo = formatInfo;
    }

    public String formatQualifierInfo(QualifierInfo qualInfo) throws ARException {
        logger.debug("Start Format Qualification");
        StringBuffer sbf = new StringBuffer();
        String leftOprnd = "";
        String rightOprnd = "";
        int condOpr = 0;
        if (qualInfo != null) {
            condOpr = qualInfo.getOperation();
        }
        switch (condOpr) {
            case 1: 
            case 2: 
            case 3: {
                boolean hasSameLevelAsParent = this.formatInfo.hasSameCondOprAsParent();
                try {
                    if (condOpr != 3) {
                        this.formatInfo.setSameCondOprAsParent(qualInfo.getOperation() == qualInfo.getLeftOperand().getOperation());
                        leftOprnd = this.formatQualifierInfo(qualInfo.getLeftOperand());
                        this.formatInfo.setSameCondOprAsParent(qualInfo.getOperation() == qualInfo.getRightOperand().getOperation());
                        rightOprnd = this.formatQualifierInfo(qualInfo.getRightOperand());
                    } else {
                        rightOprnd = this.formatQualifierInfo(qualInfo.getNotOperand());
                    }
                }
                catch (ARException e) {
                    logger.error("could not format the qualifier info that involves the " + this.formatConditionalOperator(condOpr) + "operation", e);
                    throw e;
                }
                sbf.append(leftOprnd).append(this.formatConditionalOperator(condOpr)).append(rightOprnd);
                if (hasSameLevelAsParent || !this.formatInfo.includeParanthesis()) break;
                sbf.insert(0, "(").append(")");
                break;
            }
            case 5: {
                String id = Integer.toString(qualInfo.getFromFieldInfo().getValue());
                String frmtdFld = null;
                Field field = null;
                OperandType ot = null;
                int typeOfOperand = -1;
                ot = qualInfo.getFromFieldInfo().getType();
                if (ot != null) {
                    typeOfOperand = ot.toInt();
                }
                switch (typeOfOperand) {
                    case 50: {
                        field = this.formatInfo.getLocalField(Integer.toString(qualInfo.getFromFieldInfo().getValue()));
                        frmtdFld = field != null ? field.getName() : String.valueOf(id);
                        frmtdFld = "'TR." + frmtdFld + "'";
                        break;
                    }
                    case 51: {
                        field = this.formatInfo.getLocalField(Integer.toString(qualInfo.getFromFieldInfo().getValue()));
                        frmtdFld = field != null ? field.getName() : String.valueOf(id);
                        frmtdFld = "'DB." + frmtdFld + "'";
                        break;
                    }
                    default: {
                        frmtdFld = this.formatInfo.getLocalFieldListSize() > 0 && (field = this.formatInfo.getLocalField(id)) != null ? "$" + field.getName() + "$" : ((field = this.formatInfo.getRemoteField(id)) != null ? "'" + field.getName() + "'" : "$" + id + "$");
                    }
                }
                sbf.append(this.formatConditionalOperator(condOpr)).append("(").append(frmtdFld).append(")");
                break;
            }
            case 4: {
                String formatedRoi = null;
                RelationalOperationInfo roi = qualInfo.getRelationalOperationInfo();
                try {
                    formatedRoi = this.formatRelationalOperationInfo(roi);
                }
                catch (ARException e) {
                    logger.error("could not format the qualifer info that involves the REL_OP operation", e);
                    throw e;
                }
                sbf.append(formatedRoi);
                break;
            }
            case 0: {
                break;
            }
            default: {
                logger.error("Unknown operand type " + condOpr);
                throw new ARException(2, 142, "Operation " + condOpr);
            }
        }
        logger.debug("End Format Qalification ");
        return sbf.toString();
    }

    protected String formatRelationalOperationInfo(RelationalOperationInfo relOpnInfo) throws ARException {
        StringBuffer frmtdRelOpn = new StringBuffer();
        ArithmeticOrRelationalOperand arithmOrRelOpndLeft = relOpnInfo.getLeftOperand();
        ArithmeticOrRelationalOperand arithmOrRelOpndRight = relOpnInfo.getRightOperand();
        frmtdRelOpn.append(this.formatArithmeticOrRelationalOperand(arithmOrRelOpndLeft));
        frmtdRelOpn.append(this.formatRelationalOperator(relOpnInfo.getOperation()));
        frmtdRelOpn.append(this.formatArithmeticOrRelationalOperand(arithmOrRelOpndRight));
        if (this.formatInfo.includeParanthesis()) {
            frmtdRelOpn.insert(0, "(").append(")");
        }
        return frmtdRelOpn.toString();
    }
}

