/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class ArSoftByteArrayManager {
    private static Logger log = Logger.getLogger(ArSoftByteArrayManager.class);
    private static final byte[] BYTE0 = new byte[0];
    private static final Object SOFT = ArSoftByteArrayManager.createReference(BYTE0);
    private static int nextExpendIdx = 0;
    private static HashMap<Integer, Object> softMap = new HashMap();
    private static final int BLOCKSIZE = 8192;
    private static final byte[] BLOCKBYTES = new byte[8192];
    private static final int BORDER = 128;
    protected static final ReentrantLock lock = new ReentrantLock();

    public static int toMultipleOfFourBufferSize(int bufferSize) {
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        if ((bufferSize & 3) != 0) {
            bufferSize = bufferSize + 4 & 0xFFFFFFFC;
        }
        return bufferSize;
    }

    private static final Object createReference(Object o) {
        return new SoftReference<Object>(o);
    }

    private static final void zero(byte[] a) {
        int i = a.length;
        while (i >= 8192) {
            System.arraycopy(BLOCKBYTES, 0, a, i -= 8192, 8192);
        }
        if (i > 0) {
            System.arraycopy(BLOCKBYTES, 0, a, 0, i);
        }
    }

    private static final byte[] list(int i) {
        byte[] r;
        lock.lock();
        try {
            Object s = softMap.get(i);
            r = s != SOFT ? (byte[])((SoftReference)s).get() : BYTE0;
            if (r == null) {
                softMap.put(i, SOFT);
                r = BYTE0;
                if (log.isTraceEnabled()) {
                    log.trace("after GC: SoftReference byte array had been collected at " + i + "; reset to BYTE0");
                }
            }
        }
        finally {
            lock.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] search(int minsize, int maxsize) {
        byte[] r = null;
        lock.lock();
        try {
            int p = -1;
            int m = Integer.MAX_VALUE;
            int maxIdx = nextExpendIdx;
            for (int i = 0; i < maxIdx; ++i) {
                int l;
                byte[] b = ArSoftByteArrayManager.list(i);
                if (b == BYTE0 || (l = b.length) < minsize || l > maxsize) continue;
                if (p == -1 || l < m) {
                    r = b;
                    p = i;
                    m = l;
                }
                if (l == minsize && p >= 0) break;
            }
            if (p >= 0) {
                softMap.put(p, SOFT);
                if (log.isTraceEnabled()) {
                    log.trace("found one soft referenced byte[" + m + "] at " + p);
                }
            } else if (log.isTraceEnabled()) {
                if (minsize == maxsize) {
                    log.trace("not found soft referenced byte " + minsize);
                } else {
                    log.trace("not found soft referenced byte between " + minsize + " and " + maxsize);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return r;
    }

    public static final byte[] get(int size, boolean setZeros) {
        return size < 128 ? new byte[size] : ArSoftByteArrayManager.get0(size, size, setZeros);
    }

    public static final byte[] get(int minSize, int maxSize, boolean setZeros) {
        if (minSize < 128 && log.isTraceEnabled()) {
            log.trace("create new byte[] since _size(" + minSize + ") < BORDER(" + 128 + ")");
        }
        return minSize < 128 ? new byte[minSize] : ArSoftByteArrayManager.get0(minSize, maxSize, setZeros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] get0(int minsize, int maxsize, boolean setZeros) {
        byte[] r;
        if (maxsize < minsize) {
            maxsize = minsize << 2 | 0x1FFF;
        }
        lock.lock();
        try {
            r = ArSoftByteArrayManager.search(minsize, maxsize);
            if (r == null) {
                int l = minsize;
                if (log.isTraceEnabled()) {
                    log.trace("no existing byte array found, create new byte[" + l + "]");
                }
                r = new byte[l];
            } else if (setZeros) {
                if (log.isTraceEnabled()) {
                    log.trace("reuse a soft referenced byte array byte[" + r.length + "]");
                }
                ArSoftByteArrayManager.zero(r);
            }
        }
        finally {
            lock.unlock();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void release(byte[] array) {
        if (array == null) {
            return;
        }
        int l = array.length;
        if (l < 128) {
            return;
        }
        lock.lock();
        try {
            int max = nextExpendIdx;
            for (int i = 0; i < max; ++i) {
                byte[] tmp = ArSoftByteArrayManager.list(i);
                if (tmp == BYTE0) {
                    if (log.isTraceEnabled()) {
                        log.trace("released a soft referenced byte[" + l + "] put in " + i);
                    }
                    softMap.put(i, ArSoftByteArrayManager.createReference(array));
                    return;
                }
                if (tmp != null) continue;
                if (log.isTraceEnabled()) {
                    log.trace("after GC: SoftReference byte array had been collected at list(" + i + "), release to " + i);
                }
                softMap.put(i, ArSoftByteArrayManager.createReference(array));
                return;
            }
            int n = nextExpendIdx++;
            softMap.put(n, ArSoftByteArrayManager.createReference(array));
            if (log.isTraceEnabled()) {
                log.trace("expand released byte[" + l + "] over at n=" + n + "; softMap.size = " + softMap.size());
            }
        }
        finally {
            lock.unlock();
        }
    }

    static {
        softMap.put(nextExpendIdx++, SOFT);
    }
}

