/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArClientRequestHandler;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArNioException;
import com.bmc.arsys.arrpc.nio.ArNioXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.nio.ArNioXdrTcpEncodingStream;
import com.bmc.arsys.arrpc.nio.ArRpcCallInformation;
import com.bmc.arsys.arrpc.nio.ArSelectorThread;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpDecodingStream;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import com.bmc.arsys.utils.ARProcessStatus;
import com.bmc.arsys.utils.ProcessUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcAuthenticationException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrAble;
import org.acplt.oncrpc.XdrDecodingStream;
import org.acplt.oncrpc.XdrEncodingStream;
import org.acplt.oncrpc.server.OncRpcCallInformation;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerReplyMessage;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.apache.log4j.Logger;

public abstract class ArRpcCallHandler
extends OncRpcServerTransport
implements ArClientRequestHandler,
ArEncryptionContext {
    private static String osname = System.getProperty("os.name");
    private static boolean NEED_DONE_SIGNAL = "SunOS".equals(osname);
    private static Logger LOGGER = Logger.getLogger(ArRpcCallHandler.class);
    private final SocketChannel socket;
    private SelectionKey sk;
    private ArSelectorThread selectorThread;
    private ArNioXdrTcpEncodingStream sendingXdr;
    private ArNioXdrTcpDecodingStream receivingXdr;
    private boolean pendingDecoding = false;
    private boolean pendingEncoding = false;
    protected int transmissionTimeout;
    private boolean isEncryptedCall;
    private int currentSessionId;
    private Processor processor;
    protected int streamBufferSize;
    protected String remoteHostKey;
    protected String remoteHostCharSet = "utf-8";
    private boolean doneEncoding = false;

    public ArRpcCallHandler(ArSelectorThread selectorThread, SocketChannel channel, OncRpcDispatchable dispatcher, int bufferSize, int transmissionTimeout) throws IOException {
        super(dispatcher, 0, null);
        this.socket = channel;
        this.selectorThread = selectorThread;
        this.socket.configureBlocking(false);
        this.transmissionTimeout = transmissionTimeout;
        this.socket.socket().setSoTimeout(transmissionTimeout);
        this.processor = new Processor();
        this.processor.getCallStatus().setProcessId(this.processor.toString());
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.streamBufferSize = bufferSize;
        this.createXdrTcpEncodingStream(bufferSize);
        this.createXdrTcpDecodingStream(bufferSize);
    }

    protected abstract void createXdrTcpEncodingStream(int var1) throws IOException;

    protected abstract void createXdrTcpDecodingStream(int var1) throws IOException;

    public void register(Selector selector) throws ClosedChannelException {
        this.sk = this.socket.register(selector, 1);
        this.sk.attach(this);
        this.selectorThread.registerForRead(true, this.sk, true);
    }

    @Override
    public void handleRequest(SelectionKey key) {
        if (key.isValid() && key.isReadable() && this.socket.isOpen()) {
            this.sk = key;
            this.selectorThread.unregisterForRead(this.sk);
            this.processor.getCallStatus().setStartTimestamp(System.currentTimeMillis());
            this.executeProcessor(this.processor);
        }
    }

    protected void postEncoding() throws IOException {
        LOGGER.trace("check pendingEncoding " + this.pendingEncoding + " doneEncoding " + this.doneEncoding);
        if (this.doneEncoding && NEED_DONE_SIGNAL) {
            LOGGER.trace("Due to close handler.");
            throw new ArNioException("Due to close handler");
        }
    }

    protected abstract void executeProcessor(Processor var1);

    synchronized void processRpcCall() throws Throwable {
        try {
            ArRpcCallInformation callInfo = new ArRpcCallInformation(this);
            LOGGER.trace("Selector " + this.sk.selector().hashCode() + " reacting on a rpc event. Getting ClientInfo from rpc");
            if (this.getClientInfo(callInfo)) {
                LOGGER.trace("getting RPC Header ");
                if (this.getRPCHeader(callInfo)) {
                    LOGGER.debug("Start processing RPC call in a free thread from the pool. Procedure: " + callInfo.callMessage.procedure);
                    this.callDispatcher(callInfo);
                    LOGGER.debug("Selector " + this.sk.selector().hashCode() + " done processing RPC call in a free thread from the pool. Procedure: " + callInfo.callMessage.procedure);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("processRpcCall failed:" + e.getLocalizedMessage());
        }
        finally {
            if (this.sk.isValid()) {
                this.selectorThread.registerForRead(true, this.sk, true);
            }
        }
    }

    private boolean getClientInfo(OncRpcCallInformation callInfo) {
        if (this.receivingXdr == null) {
            LOGGER.debug("No receivingXdr.");
            return false;
        }
        try {
            this.socket.socket().setSoTimeout(this.transmissionTimeout);
            this.pendingDecoding = true;
            this.receivingXdr.beginDecoding();
            LOGGER.trace("client info getting SenderAddress");
            callInfo.peerAddress = this.receivingXdr.getSenderAddress();
            LOGGER.trace("client info getSenderAddress: " + callInfo.peerAddress.toString());
            LOGGER.trace("client info getting SenderPort");
            callInfo.peerPort = this.receivingXdr.getSenderPort();
            LOGGER.trace("client info getSenderPort: " + callInfo.peerPort);
        }
        catch (IOException e) {
            LOGGER.debug("While getting client info." + e.getLocalizedMessage());
            this.close();
            return false;
        }
        catch (OncRpcException e) {
            if (e.getReason() == -1) {
                LOGGER.debug("Nothing to read from socket.");
                return false;
            }
            if (e.getReason() == 4) {
                try {
                    this.createXdrTcpDecodingStream(this.streamBufferSize);
                }
                catch (IOException e1) {
                    LOGGER.debug("Remote host closed connection because of timeout.");
                    this.close();
                }
                return false;
            }
            if (e.getReason() == 3) {
                try {
                    this.createXdrTcpEncodingStream(this.streamBufferSize);
                }
                catch (IOException e1) {
                    LOGGER.debug("Remote host closed connection.");
                    this.close();
                }
                return false;
            }
            if (e.getReason() == -2) {
                LOGGER.error("System had restarted while getting client info. Closing connection.");
                this.close();
                return false;
            }
            LOGGER.error("OncRpcException while getting client info. Closing connection.", e);
            this.close();
            return false;
        }
        catch (Throwable e) {
            LOGGER.error("RunTimeException while getting client info. Closing connection.", e);
            this.close();
            return false;
        }
        return true;
    }

    private boolean getRPCHeader(OncRpcCallInformation callInfo) {
        try {
            callInfo.callMessage.xdrDecode(this.receivingXdr);
        }
        catch (IOException e) {
            LOGGER.debug("IOException while getting RPC call header. Closing client connection.");
            this.close();
            return false;
        }
        catch (OncRpcException e) {
            if (this.pendingDecoding) {
                this.pendingDecoding = false;
                try {
                    this.receivingXdr.endDecoding();
                }
                catch (IOException iOException) {
                }
                catch (OncRpcException oncRpcException) {
                    // empty catch block
                }
            }
            LOGGER.debug("OncrpcException while getting RPC call header. Closing client connection.");
            this.close();
            return false;
        }
        catch (Throwable e) {
            LOGGER.debug("RunTimeException while getting RPC call header. Closing client connection.", e);
            this.close();
            return false;
        }
        return true;
    }

    private void callDispatcher(OncRpcCallInformation callInfo) {
        try {
            this.dispatchCall(callInfo);
        }
        catch (Throwable e) {
            if (!(e instanceof OncRpcException && ((OncRpcException)e).getReason() != 2 || e instanceof ArNioException)) {
                LOGGER.error("Exception while processing RPC call.", e);
            }
            if (this.pendingEncoding) {
                if (!(e instanceof ArNioException)) {
                    LOGGER.error("Unrecoverable error. Closing connection.", e);
                }
                this.close();
                return;
            }
            if (this.pendingDecoding) {
                this.pendingDecoding = false;
                try {
                    this.receivingXdr.endDecoding();
                }
                catch (IOException e2) {
                    LOGGER.error("Exception while processing RPC call.", e2);
                    this.close();
                    return;
                }
                catch (OncRpcException e2) {
                    // empty catch block
                }
            }
            try {
                if (e instanceof OncRpcAuthenticationException) {
                    callInfo.failAuthenticationFailed(((OncRpcAuthenticationException)e).getAuthStatus());
                } else {
                    callInfo.failSystemError();
                }
            }
            catch (IOException e2) {
                this.close();
                return;
            }
            catch (OncRpcException oncRpcException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void close() {
        try {
            Object deadXdrStream;
            this.sk.cancel();
            this.sk.attach(null);
            this.socket.socket().close();
            this.socket.close();
            this.sk.selector().wakeup();
            if (this.sendingXdr != null) {
                deadXdrStream = this.sendingXdr;
                try {
                    ((XdrEncodingStream)deadXdrStream).close();
                }
                catch (IOException iOException) {
                }
                catch (OncRpcException oncRpcException) {
                    // empty catch block
                }
            }
            if (this.receivingXdr != null) {
                deadXdrStream = this.receivingXdr;
                try {
                    ((XdrDecodingStream)deadXdrStream).close();
                }
                catch (IOException iOException) {
                }
                catch (OncRpcException oncRpcException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.sendingXdr.setCharacterEncoding(characterEncoding);
        this.receivingXdr.setCharacterEncoding(characterEncoding);
        if (LOGGER.isTraceEnabled() && !characterEncoding.equalsIgnoreCase(this.sendingXdr.getCharacterEncoding())) {
            LOGGER.trace("change encode/decode stream to : " + characterEncoding);
        }
    }

    @Override
    public String getCharacterEncoding() {
        return this.sendingXdr.getCharacterEncoding();
    }

    protected void setXdrTcpEncodingStream(ArNioXdrTcpEncodingStream encStream) {
        this.sendingXdr = encStream;
    }

    protected void setXdrTcpDecodingStream(ArNioXdrTcpDecodingStream decStream) {
        this.receivingXdr = decStream;
        this.receivingXdr.setTransmissionTimeout(this.transmissionTimeout);
    }

    protected Socket getSocket() {
        return this.socket.socket();
    }

    protected SocketChannel getSocketChannel() {
        return this.socket;
    }

    @Override
    public boolean isCurrentCallEncrypted() {
        return this.isEncryptedCall;
    }

    @Override
    public void setCurrentCallEncryption(boolean enc) {
        this.isEncryptedCall = enc;
    }

    @Override
    public int getCurrentSessionId() throws OncRpcException {
        if (this.currentSessionId == 0) {
            throw new OncRpcException("Rpc encryption error");
        }
        return this.currentSessionId;
    }

    @Override
    public void setCurrentSessionId(int id) {
        this.currentSessionId = id;
    }

    @Override
    protected XdrDecodingStream getXdrDecodingStream() {
        return this.receivingXdr;
    }

    @Override
    protected XdrEncodingStream getXdrEncodingStream() {
        return this.sendingXdr;
    }

    protected void dispatchCall(OncRpcCallInformation callInfo) throws IOException, OncRpcException {
        if ((callInfo.callMessage.procedure & 0x8000) != 0) {
            callInfo.callMessage.procedure &= 0xFFFF7FFF;
            this.isEncryptedCall = true;
        } else {
            this.isEncryptedCall = false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("task " + this.getCallStatus() + " for procedure number: " + callInfo.callMessage.procedure + " start processing after received for " + ProcessUtil.getElapsedMiliSecTimeToFormatedString(System.currentTimeMillis() - this.getCallStatus().getStartTimestamp(), true));
            LOGGER.debug("Procedure number: " + callInfo.callMessage.procedure + " Call encrypted: " + this.isEncryptedCall);
        }
        this.updateRemoteHostCharSet(callInfo);
        ((ArXdrTcpEncodingStream)this.getXdrEncodingStream()).setArEncryptionOn(this.isEncryptedCall);
        ((ArXdrTcpEncodingStream)this.getXdrEncodingStream()).setArProcessOn(this.isEncryptedCall);
        ((ArXdrTcpDecodingStream)this.getXdrDecodingStream()).setArEncryptionOn(this.isEncryptedCall);
        ((ArXdrTcpDecodingStream)this.getXdrDecodingStream()).setArProcessOn(this.isEncryptedCall);
        int authStatus = this.isEncryptionPolicyValid(this.isEncryptedCall, callInfo.callMessage.procedure);
        if (authStatus != 0) {
            this.isEncryptedCall = false;
            LOGGER.error("Mismatch between encryption policy and RPC call encryption settings");
            callInfo.reply(new OncRpcServerReplyMessage(callInfo.callMessage, 1, 0, 1, 0, 0, authStatus), null);
            return;
        }
        this.setRemoteHostCharSetToStreams();
        this.dispatcher.dispatchOncRpcCall(callInfo, callInfo.callMessage.program, callInfo.callMessage.version, callInfo.callMessage.procedure);
    }

    protected String updateRemoteHostCharSet(OncRpcCallInformation callInfo) {
        return this.remoteHostCharSet;
    }

    protected int isEncryptionPolicyValid(boolean encryptedCall, int proc_num) {
        int authStatus = 0;
        return authStatus;
    }

    @Override
    protected void beginEncoding(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state) throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
        this.pendingEncoding = true;
        this.sendingXdr.beginEncoding(callInfo.peerAddress, callInfo.peerPort);
        state.xdrEncode(this.sendingXdr);
        if (this.getXdrEncodingStream() instanceof ArXdrTcpEncodingStream) {
            ArXdrTcpEncodingStream sendingXdr = (ArXdrTcpEncodingStream)this.getXdrEncodingStream();
            int orgBufferBeginIndex = sendingXdr.getBufferIndex();
            sendingXdr.setOrgBufferBeginIndex(orgBufferBeginIndex);
        }
    }

    @Override
    protected void endEncoding() throws OncRpcException, IOException {
        if (this.sendingXdr != null) {
            this.sendingXdr.endEncoding();
        }
        this.postEncoding();
        this.pendingEncoding = false;
    }

    @Override
    public void retrieveCall(XdrAble call) throws OncRpcException, IOException {
        this.receivingXdr.setCharacterEncoding(this.getCharacterEncoding());
        call.xdrDecode(this.receivingXdr);
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    @Override
    protected void reply(OncRpcCallInformation callInfo, OncRpcServerReplyMessage state, XdrAble reply) throws OncRpcException, IOException {
        LOGGER.trace("beginEncoding for reply. Procedure : " + callInfo.callMessage.procedure);
        this.doneEncoding = false;
        this.sendingXdr.setCharacterEncoding(this.getCharacterEncoding());
        this.beginEncoding(callInfo, state);
        if (reply != null) {
            reply.xdrEncode(this.sendingXdr);
        }
        LOGGER.trace("endEncoding for reply. Procedure : " + callInfo.callMessage.procedure);
        this.doneEncoding = true;
        this.endEncoding();
        this.doneEncoding = false;
    }

    @Override
    protected void endDecoding() throws OncRpcException, IOException {
        if (this.pendingDecoding) {
            this.pendingDecoding = false;
            this.receivingXdr.endDecoding();
        }
    }

    @Override
    public void listen() {
    }

    @Override
    public void register() throws OncRpcException {
        throw new Error("Call not applicable for this object and can not be called.");
    }

    protected boolean isPendingDecoding() {
        return this.pendingDecoding;
    }

    protected void setPendingDecoding(boolean pendingDecoding) {
        this.pendingDecoding = pendingDecoding;
    }

    protected boolean isPendingEncoding() {
        return this.pendingEncoding;
    }

    protected void setPendingEncoding(boolean pendingEncoding) {
        this.pendingEncoding = pendingEncoding;
    }

    public String getRemoteHostCharSet() {
        return this.remoteHostCharSet;
    }

    protected void setRemoteHostCharSet(String remoteHostCharSet) {
        this.remoteHostCharSet = remoteHostCharSet;
    }

    protected void setRemoteHostCharSetToStreams() {
        this.getXdrDecodingStream().setCharacterEncoding(this.remoteHostCharSet);
        this.getXdrEncodingStream().setCharacterEncoding(this.remoteHostCharSet);
    }

    protected String getRemoteHostKey() {
        return this.remoteHostKey;
    }

    protected void setRemoteHostKey(String remoteHostKey) {
        this.remoteHostKey = remoteHostKey;
    }

    public ARProcessStatus getCallStatus() {
        return this.processor.getCallStatus();
    }

    public class Processor
    implements Runnable {
        private ARProcessStatus callStatus = new ARProcessStatus();

        @Override
        public void run() {
            try {
                ArRpcCallHandler.this.processRpcCall();
            }
            catch (Throwable e) {
                LOGGER.error("Process Rpc Call failed " + e.getLocalizedMessage());
            }
        }

        public ARProcessStatus getCallStatus() {
            return this.callStatus;
        }
    }
}

