/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.CleanUpThread;
import java.util.Enumeration;
import java.util.Hashtable;

abstract class ObjectPool {
    private long expirationTime = 5000L;
    private Hashtable<Object, Long> locked = new Hashtable();
    private Hashtable<Object, Long> unlocked = new Hashtable();
    private CleanUpThread cleaner = new CleanUpThread(this, this.expirationTime);

    ObjectPool() {
        this.cleaner.setDaemon(true);
        this.cleaner.start();
    }

    abstract Object create() throws Exception;

    abstract boolean validate(Object var1);

    abstract void expire(Object var1);

    synchronized Object checkOut() throws Exception {
        Object o;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration<Object> e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (this.validate(o)) {
                    this.unlocked.remove(o);
                    this.locked.put(o, new Long(now));
                    return o;
                }
                this.unlocked.remove(o);
                this.expire(o);
                o = null;
            }
        }
        o = this.create();
        this.locked.put(o, new Long(now));
        return o;
    }

    synchronized void checkIn(Object o) {
        if (o != null) {
            this.locked.remove(o);
            this.unlocked.put(o, new Long(System.currentTimeMillis()));
        }
    }

    synchronized void cleanUp() {
        long now = System.currentTimeMillis();
        Enumeration<Object> e = this.unlocked.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (now - this.unlocked.get(o) <= this.expirationTime) continue;
            this.unlocked.remove(o);
            this.expire(o);
            o = null;
        }
        System.gc();
    }
}

