/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ActiveLink;
import com.bmc.arsys.api.ActiveLinkCriteria;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.Association;
import com.bmc.arsys.api.AssociationCriteria;
import com.bmc.arsys.api.ChangeIdInfo;
import com.bmc.arsys.api.ComplexSortInfo;
import com.bmc.arsys.api.Container;
import com.bmc.arsys.api.ContainerCriteria;
import com.bmc.arsys.api.ContainerOwner;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DirectAssociation;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.Escalation;
import com.bmc.arsys.api.EscalationCriteria;
import com.bmc.arsys.api.EscalationTimeCriteria;
import com.bmc.arsys.api.Field;
import com.bmc.arsys.api.FieldCriteria;
import com.bmc.arsys.api.Filter;
import com.bmc.arsys.api.FilterCriteria;
import com.bmc.arsys.api.Form;
import com.bmc.arsys.api.FormCriteria;
import com.bmc.arsys.api.Image;
import com.bmc.arsys.api.ImageCriteria;
import com.bmc.arsys.api.IndirectAssociation;
import com.bmc.arsys.api.LocalizedRequestInfo;
import com.bmc.arsys.api.LocalizedValueCriteria;
import com.bmc.arsys.api.Menu;
import com.bmc.arsys.api.MenuCriteria;
import com.bmc.arsys.api.ObjectPropertyMap;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.OverlaidInfo;
import com.bmc.arsys.api.ParameterValidator;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RegularComplexQuery;
import com.bmc.arsys.api.RegularQuery;
import com.bmc.arsys.api.ServerInfoMap;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.SupportFile;
import com.bmc.arsys.api.SupportFileKey;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.View;
import com.bmc.arsys.api.ViewCriteria;
import com.bmc.arsys.api.WorkflowLockInfo;
import com.bmc.arsys.apitransport.ApiUserContextI;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class MethodValidator
extends ParameterValidator {
    private static Logger logger = Logger.getLogger(ParameterValidator.class);
    private ApiUserContextI context;

    public MethodValidator() {
    }

    public MethodValidator(String serverCharSetName) {
        super(serverCharSetName);
    }

    public void verifyUserContext(ApiUserContextI context) throws ARException {
        this.context = context;
        this.context.setLastStatus(null);
        this.validateARStringType(context.getUser(), 254, 149, 103, false);
        this.validateARStringType(context.getPassword(), 30, true);
        this.validateARStringType(context.getServer(), 64, 150, 103, false);
        this.validateARStringType(context.getAuthentication(), 2047, true);
    }

    public void verifyARGetListForm(ApiUserContextI context, long changedSince, int formType, String formName, int[] fieldIds, ObjectPropertyMap propsToSearch) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetListFormWithAlias(ApiUserContextI context, long changedSince, int formType, String formName, int[] fieldIds, String vuiLabel) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, true);
    }

    public void verifyARGetListFormObjects(ApiUserContextI context, long changedSince, int formType, String formName, int[] fieldIds, FormCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, true);
    }

    public void verifyARCreateForm(ApiUserContextI ctx, Form object) throws ARException {
        this.verifyUserContext(ctx);
        this.validateARForm(object, true);
    }

    public void verifyARSetForm(ApiUserContextI context, Form object) throws ARException {
        this.verifyUserContext(context);
        this.validateARForm(object, false);
        this.validateARNameType(object.getNewName(), true);
    }

    public void verifyARGetForm(ApiUserContextI context, String name, FormCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(name, false);
    }

    public void verifyARDeleteForm(ApiUserContextI context, String arg1, int arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARGetView(ApiUserContextI context, String arg1, int arg2, ViewCriteria arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARCreateView(ApiUserContextI context, View object) throws ARException {
        this.verifyUserContext(context);
        this.validateARView(object);
    }

    public void verifyARSetView(ApiUserContextI context, View arg1) throws ARException {
        this.verifyUserContext(context);
        if (arg1.getName() == null && arg1.getLocale() == null && arg1.getVUIType() == 0 && arg1.getDisplayProperties() == null && arg1.getHelpText() == null && arg1.getOwner() == null && arg1.getDiary() == null) {
            this.throwValidationException(1, 54);
        }
        this.validateARView(arg1);
    }

    public void verifyARDeleteView(ApiUserContextI context, String arg1, int arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARGetListView(ApiUserContextI context, String arg1, long arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, true);
    }

    public void verifyARGetListViewObjects(ApiUserContextI context, String arg1, long arg2, ViewCriteria arg3) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARCreateMenu(ApiUserContextI context, Menu object) throws ARException {
        this.verifyUserContext(context);
        this.validateMenuInfo(object, false);
        this.validateARNameType(object.getName(), false);
        if (object.getRefreshCode() < 1 || object.getRefreshCode() > 3) {
            this.throwValidationException(2, 207);
        }
        this.validateARAccessNameType(object.getOwner(), true);
        this.validateARPropList(object.getProperties(), true);
    }

    public void verifyARSetMenu(ApiUserContextI context, Menu arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateMenuInfo(arg1, false);
        this.validateARNameType(arg1.getName(), false);
        this.validateARNameType(arg1.getNewName(), true);
        if ((arg1.getNewName() == null || arg1.getNewName().length() == 0 || arg1.getName().compareTo(arg1.getNewName()) == 0) && arg1.getRefreshCode() == 0 && arg1.getMenuType() == 0 && arg1.getHelpText() == null && arg1.getOwner() == null && arg1.getDiary() == null && arg1.getProperties() == null) {
            this.throwValidationException(1, 54);
        }
        if (arg1.getRefreshCode() != 0 && (arg1.getRefreshCode() < 1 || arg1.getRefreshCode() > 3)) {
            this.throwValidationException(2, 207);
        }
        this.validateARAccessNameType(arg1.getOwner(), true);
        this.validateARPropList(arg1.getProperties(), true);
    }

    public void verifyARGetMenu(ApiUserContextI context, String arg1, MenuCriteria arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARGetListMenu(ApiUserContextI context, long arg1, List<String> arg2, List<String> arg3, ObjectPropertyMap arg4) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetListMenuObjects(ApiUserContextI context, long arg1, List<String> arg2, List<String> arg3, MenuCriteria arg4) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARDeleteMenu(ApiUserContextI context, String arg1, int arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARExpandMenu(ApiUserContextI context, Menu arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateMenuInfo(arg1, false);
    }

    private void verifyARImage(ApiUserContextI ctx, Image arg1, boolean arg2) throws ARException {
        this.verifyUserContext(ctx);
        this.validateARNameType(arg1.getName(), false);
        this.validateARPropList(arg1.getProperties(), true);
        this.validateARAccessNameType(arg1.getOwner(), !arg2);
        if (arg1.getType() == null && arg2) {
            this.throwValidationException(2, 885);
        }
        if (arg1.getImageData() == null && arg2) {
            this.throwValidationException(2, 884);
        }
    }

    public void verifyARGetImage(ApiUserContextI context, String arg1, ImageCriteria arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARGetMultipleImages(ApiUserContextI context, long arg1, List<String> arg2, ImageCriteria arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameList(arg2, true);
    }

    public void verifyARSetImage(ApiUserContextI context, Image arg1) throws ARException {
        this.verifyARImage(context, arg1, false);
        this.validateARNameType(arg1.getNewName(), true);
    }

    public void verifyARCreateImage(ApiUserContextI ctx, Image arg1) throws ARException {
        this.verifyARImage(ctx, arg1, true);
    }

    public void verifyARDeleteImage(ApiUserContextI context, String arg1, boolean arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARGetListImage(ApiUserContextI context, List<String> arg1, long arg2, String arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameList(arg1, true);
    }

    public void verifyARGetField(ApiUserContextI context, String arg1, int arg2, FieldCriteria arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARGetActiveLink(ApiUserContextI context, String arg1, ActiveLinkCriteria arg2, ActiveLink arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
    }

    public void verifyARCreateEntry(ApiUserContextI context, String arg1, Entry arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
        this.validateAREntry(arg2, true);
    }

    public void verifyARGetEntry(ApiUserContextI context, String formName, String entryId, int[] entryListFields) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntryIdList(entryId, false);
    }

    public void verifyARGetListEntry(ApiUserContextI context, String formName, QualifierInfo qualification, int firstRetrieve, int maxRetrieve, List<EntryListFieldInfo> entryListFields, List<SortInfo> sortList, boolean useLocale, OutputInteger nMatches) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateARQualifierInfo(qualification, true);
        this.validateAREntryListFieldList(entryListFields);
        this.validateARSortList(sortList);
    }

    public void verifyARGetMultipleEntries(ApiUserContextI context, String formName, List<String> entryIds, int[] entryListFields) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntryIdListList(entryIds, false);
    }

    public void verifyARGetListEntryWithFields(ApiUserContextI context, String formName, QualifierInfo qualification, int firstRetrieve, int maxRetrieve, List<SortInfo> sortList, int[] fieldIds, boolean useLocale, OutputInteger nMatches) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateARQualifierInfo(qualification, true);
        this.validateARSortList(sortList);
    }

    public void verifyARGetListValuesFromEntries(ARServerUser arServerUser, String formName, QualifierInfo qualification, int startEntry, int maxEntries, List<ComplexSortInfo> sortList, List<ArithmeticOrRelationalOperand> selectionList, List<ArithmeticOrRelationalOperand> groupByList, QualifierInfo having, boolean distinct, boolean useLocale, OutputInteger nMatches) throws ARException {
        this.verifyUserContext(this.context);
        this.validateARNameType(formName, false);
        this.validateARQualifierInfo(qualification, true);
        this.validateARSortList(sortList);
        this.validateARQualifierInfo(having, true);
        this.validateARFieldValueOrArithInfoList(selectionList);
        this.validateARFieldValueOrArithInfoList(groupByList);
    }

    private void validateARFieldValueOrArithInfoList(List<ArithmeticOrRelationalOperand> operands) throws ARException {
        if (operands != null) {
            for (ArithmeticOrRelationalOperand operand : operands) {
                this.validateARFieldValueOrArithInfo(operand, true);
            }
        }
    }

    public void verifyARGetOneEntryWithFields(ApiUserContextI context, String formName, QualifierInfo qualification, List<SortInfo> sortList, int[] fieldIds, boolean useLocale, OutputInteger nMatches) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateARQualifierInfo(qualification, true);
        this.validateARSortList(sortList);
    }

    public void verifyARGetListEntryBlocks(ApiUserContextI context, String formName, QualifierInfo qualification, int numEntriesPerBlock, int firstRetrieve, int maxRetrieve, List<SortInfo> sortList, int[] fieldIds, boolean useLocale, OutputInteger numReturnedBlocks, OutputInteger numReturnedRows, OutputInteger numTotalMatches) throws ARException {
        this.verifyUserContext(context);
        if (numEntriesPerBlock == 0) {
            this.throwValidationException(2, 105);
        }
        this.validateARNameType(formName, false);
        this.validateARQualifierInfo(qualification, true);
        this.validateARSortList(sortList);
    }

    public void verifyARDeleteEntry(ApiUserContextI context, String formName, String entryId, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntryIdList(entryId, false);
    }

    public void verifyARSetEntry(ApiUserContextI context, String formName, String entryId, Entry entry, Timestamp ts, int option) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntryIdList(entryId, false);
        this.validateAREntry(entry, true);
    }

    public void verifyARServiceEntry(ApiUserContextI context, String formName, String entryId, Entry entry, int[] entryListFields) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntryIdList(entryId, true);
        this.validateAREntry(entry, true);
    }

    public void verifyARXMLServiceEntry(ApiUserContextI context, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARMergeEntry(ApiUserContextI context, String formName, Entry entry, int mergeType, QualifierInfo qualInfo, int multiMatchOpts) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntry(entry, false);
        this.validateARQualifierInfo(qualInfo, true);
        if (qualInfo != null) {
            this.verifyARMergeMultiMatchOpts(multiMatchOpts);
        }
    }

    public void verifyAREndBulkEntryTransaction(ApiUserContextI context, int arg1) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARCreateField(ApiUserContextI context, Field fieldObj, boolean isReservedRangeIdOK) throws ARException {
        this.verifyUserContext(context);
        this.validateOneField(fieldObj, true);
        this.verifyFieldForNullPermission(fieldObj);
    }

    public void verifyARSetField(ApiUserContextI context, Field arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateOneField(arg1, false);
    }

    public void verifyARCreateMultipleFields(ApiUserContextI context, List<Field> arg1) throws ARException {
        this.verifyUserContext(context);
        if (arg1 == null || arg1.size() == 0) {
            this.throwValidationException(1, 54);
        }
        for (Field fi : arg1) {
            this.validateOneField(fi, true);
            this.verifyFieldForNullPermission(fi);
        }
    }

    public void verifyARSetMultipleFields(ApiUserContextI context, List<Field> arg1) throws ARException {
        this.verifyUserContext(context);
        if (arg1 == null || arg1.size() == 0) {
            this.throwValidationException(1, 54);
        }
        for (Field fi : arg1) {
            this.validateOneField(fi, false);
        }
    }

    private void verifyFieldForNullPermission(Field fieldObj) throws ARException {
        if (fieldObj.getDataType() != 32 && (fieldObj.getPermissions() == null || fieldObj.getPermissions().size() == 0)) {
            ArrayList<StatusInfo> statusList = new ArrayList<StatusInfo>();
            statusList.add(new StatusInfo(1, 50L, ""));
            this.context.setLastStatus(statusList);
        }
    }

    public void verifyARGetListField(ApiUserContextI context, String formName, int fieldTypeMask, long changedSince) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
    }

    public void verifyARGetMultipleFields(ApiUserContextI context, String formName, int[] fieldIds, FieldCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
    }

    public void verifyARDeleteField(ApiUserContextI context, String form, int fieldId, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(form, false);
    }

    public void verifyARDeleteMultipleFields(ApiUserContextI context, String form, int[] ids, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(form, false);
    }

    public void verifyARCreateFilter(ApiUserContextI context, Filter arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1.getName(), false);
        this.validateARNameList(arg1.getFormList(), false);
        this.validateARQualifierInfo(arg1.getQualifier(), true);
        this.validateARFilterActionList(arg1.getActionList(), false, false, false);
        this.validateARFilterActionList(arg1.getElseList(), false, true, true);
        this.validateARAccessNameType(arg1.getOwner(), true);
        this.validateARPropList(arg1.getProperties(), true);
        this.validateARStringType(arg1.getErrorHandlingFilter(), 254, 0, 8001, true);
        if ((arg1.getErrorFilterOptions() & 1) != 0 && (arg1.getErrorHandlingFilter() == null || arg1.getErrorHandlingFilter().length() == 0)) {
            this.throwValidationException(2, 8000);
        }
    }

    public void verifyARGetFilter(ApiUserContextI context, String key, FilterCriteria criteria, Filter object) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(key, false);
    }

    public void verifyARGetMultipleFilters(ApiUserContextI context, long changedSince, List<String> names, FilterCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameList(names, true);
    }

    public void verifyARSetFilter(ApiUserContextI context, Filter arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1.getName(), false);
        this.validateARNameType(arg1.getNewName(), true);
        if (!(arg1.getNewName() != null && arg1.getNewName().length() != 0 && arg1.getNewName().compareTo(arg1.getName()) != 0 || arg1.getOrder() != 0 || arg1.getFormList() != null && arg1.getFormList().size() != 0 || arg1.getOpSet() != 0 || arg1.getActionList() != null && !arg1.getActionList().isEmpty() || arg1.getElseList() != null && !arg1.getElseList().isEmpty() || arg1.getHelpText() != null || arg1.getOwner() != null || arg1.getDiary() != null || arg1.getProperties() != null)) {
            this.throwValidationException(1, 54);
        }
        if (arg1.getOrder() != 0 && arg1.getOrder() > 1000) {
            this.throwValidationException(2, 169);
        }
        if (arg1.getFormList() != null && !arg1.getFormList().isEmpty()) {
            this.validateARNameList(arg1.getFormList(), true);
        }
        this.validateARQualifierInfo(arg1.getQualifier(), true);
        this.validateARFilterActionList(arg1.getActionList(), false, false, true);
        this.validateARFilterActionList(arg1.getElseList(), false, true, true);
        this.validateARAccessNameType(arg1.getOwner(), true);
        this.validateARPropList(arg1.getProperties(), true);
        this.validateARStringType(arg1.getErrorHandlingFilter(), 254, 0, 8001, true);
    }

    public void verifyARGetListFilter(ApiUserContextI context, String formName, long changedSince, ObjectPropertyMap propsToSearch) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, true);
    }

    public void verifyARDeleteFilter(ApiUserContextI context, String name, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(name, false);
    }

    public void verifyARCreateEscalation(ApiUserContextI context, Escalation arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1.getName(), false);
        EscalationTimeCriteria escalationTm = arg1.getEscalationTm();
        if (escalationTm == null) {
            this.throwValidationException(2, 247);
        } else {
            try {
                this.validateEscalationTm(escalationTm);
            }
            catch (ARException e) {
                this.throwValidationException(2, 247);
            }
        }
        this.validateARNameList(arg1.getFormList(), false);
        this.validateARQualifierInfo(arg1.getQualifier(), true);
        this.validateARFilterActionList(arg1.getActionList(), true, false, false);
        this.validateARFilterActionList(arg1.getElseList(), true, true, true);
        this.validateARAccessNameType(arg1.getOwner(), true);
        ObjectPropertyMap objPropList = arg1.getProperties();
        this.validateARPropList(objPropList, true);
    }

    public void verifyARGetEscalation(ApiUserContextI context, String key, EscalationCriteria criteria, Escalation object) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(key, false);
    }

    public void verifyARSetEscalation(ApiUserContextI context, Escalation object) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(object.getName(), false);
        this.validateARNameType(object.getNewName(), true);
        if ((object.getNewName() == null || object.getNewName().length() == 0 || object.getName().compareTo(object.getNewName()) == 0) && object.getEscalationTm() == null && object.getFormList() == null && object.getQualifier() == null && object.getActionList() == null && object.getElseList() == null && object.getHelpText() == null && object.getOwner() == null && object.getDiary() == null && object.getProperties() == null) {
            this.throwValidationException(1, 54);
        }
        try {
            this.validateEscalationTm(object.getEscalationTm());
        }
        catch (ARException e) {
            this.throwValidationException(2, 247);
        }
        if (object.getFormList() != null && !object.getFormList().isEmpty()) {
            this.validateARNameList(object.getFormList(), true);
        }
        this.validateARQualifierInfo(object.getQualifier(), true);
        this.validateARFilterActionList(object.getActionList(), true, false, true);
        this.validateARFilterActionList(object.getElseList(), true, true, true);
        this.validateARAccessNameType(object.getOwner(), true);
        this.validateARPropList(object.getProperties(), true);
    }

    public void verifyARGetListEscalation(ApiUserContextI context, String formName, long changedSince, ObjectPropertyMap propsToSearch) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, true);
    }

    public void verifyARGetMultipleEscalations(ApiUserContextI context, long changedSince, List<String> names, EscalationCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameList(names, true);
    }

    public void verifyARDeleteEscalation(ApiUserContextI context, String name, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(name, false);
    }

    public void verifyARCreateActiveLink(ApiUserContextI context, ActiveLink arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1.getName(), false);
        this.validateARNameList(arg1.getFormList(), false);
        if (arg1.getExecuteMask() > 0x1FFFFFFF) {
            this.throwValidationException(2, 187);
        }
        this.validateARQualifierInfo(arg1.getQualifier(), true);
        this.validateARActiveLinkActionList(arg1.getActionList(), false);
        this.validateARActiveLinkActionList(arg1.getElseList(), true);
        this.validateARAccessNameType(arg1.getOwner(), true);
        this.validateARPropList(arg1.getProperties(), true);
        this.validateARStringType(arg1.getErrorActlinkName(), 254, 0, 8001, true);
        if ((arg1.getErrorActlinkOptions() & 1) != 0 && (arg1.getErrorActlinkName() == null || arg1.getErrorActlinkName().length() == 0)) {
            this.throwValidationException(2, 8000);
        }
    }

    public void verifyARSetActiveLink(ApiUserContextI context, ActiveLink object) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(object.getName(), false);
        this.validateARNameType(object.getNewName(), true);
        if ((object.getNewName() == null || object.getNewName().length() == 0 || object.getName().compareTo(object.getNewName()) == 0) && object.getFormList() == null && object.getGroupList() == null && object.getQualifier() == null && object.getActionList() == null && object.getElseList() == null && object.getHelpText() == null && object.getOwner() == null && object.getLastChangedBy() == null && object.getProperties() == null) {
            this.throwValidationException(1, 54);
        }
        if (object.getOrder() != 0 && object.getOrder() > 1000) {
            this.throwValidationException(2, 169);
        }
        if (object.getFormList() != null && !object.getFormList().isEmpty()) {
            this.validateARNameList(object.getFormList(), true);
        }
        if (object.getExecuteMask() > 0x1FFFFFFF) {
            this.throwValidationException(2, 187);
        }
        this.validateARQualifierInfo(object.getQualifier(), true);
        this.validateARActiveLinkActionList(object.getActionList(), true);
        this.validateARActiveLinkActionList(object.getElseList(), true);
        this.validateARAccessNameType(object.getOwner(), true);
        this.validateARPropList(object.getProperties(), true);
        this.validateARStringType(object.getErrorActlinkName(), 254, 0, 8001, true);
    }

    public void verifyARGetListActiveLink(ApiUserContextI context, String formName, long changedSince, ObjectPropertyMap propsToSearch) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, true);
    }

    public void verifyARGetMultipleActiveLinks(ApiUserContextI context, long changedSince, List<String> names, ActiveLinkCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        if (names != null && !names.isEmpty()) {
            this.validateARNameList(names, true);
        }
    }

    public void verifyARDeleteActiveLink(ApiUserContextI context, String name, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(name, false);
    }

    public void verifyARGetListContainer(ApiUserContextI context, long changedSince, int[] containerTypes, boolean hiddenFlag, List<ContainerOwner> ownerList, ObjectPropertyMap propsToSearch) throws ARException {
        this.verifyUserContext(context);
        this.validateARContainerOwnerObjList(ownerList);
    }

    public void verifyARGetMultipleContainerObjects(ApiUserContextI context, long arg1, List<String> arg2, boolean arg3, int[] arg4, List<ContainerOwner> arg5, int[] arg6, ContainerCriteria arg7) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetContainer(ApiUserContextI context, String name, ContainerCriteria criteria) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(name, false);
    }

    public void verifyARSetContainer(ApiUserContextI context, Container object, boolean removeInvalidReference) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(object.getName(), false);
        this.validateARNameType(object.getNewName(), true);
        if ((object.getNewName() == null || object.getNewName().length() == 0 || object.getName().compareTo(object.getNewName()) == 0) && object.getAdminGroupList() == null && object.getContainerOwner() == null && object.getLabel() == null && object.getDescription() == null && object.getReferences() == null && object.getHelpText() == null && object.getOwner() == null && object.getDiary() == null && object.getProperties() == null) {
            this.throwValidationException(1, 54);
        }
        this.validateARContainerOwnerObjList(object.getContainerOwner());
        this.validateARReferenceList(object.getReferences());
        this.validateARAccessNameType(object.getOwner(), true);
        this.validateARPropList(object.getProperties(), true);
    }

    public void verifyARCreateContainer(ApiUserContextI context, Container object, boolean removeInvalidReference) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(object.getName(), false);
        this.validateARPermissionList(object.getPermissions());
        this.validateARContainerOwnerObjList(object.getContainerOwner());
        this.validateARReferenceList(object.getReferences());
        this.validateARAccessNameType(object.getOwner(), true);
        this.validateARPropList(object.getProperties(), true);
    }

    public void verifyARDeleteContainer(ApiUserContextI context, String name, int deleteOption) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(name, false);
    }

    public void verifyARCreateSupportFile(ApiUserContextI context, SupportFile supportFile) throws ARException {
        this.verifyUserContext(context);
        this.validateSupportFileType(supportFile.getKey().getFileType());
        this.validateARNameType(supportFile.getFilePath(), false);
    }

    public void verifyARGetSupportFile(ApiUserContextI context, String arg1, int arg2, int arg3, int arg4, String arg5) throws ARException {
        this.verifyUserContext(context);
        this.validateSupportFileType(arg3);
        this.validateARNameType(arg1, false);
    }

    public void verifyARSetSupportFile(ApiUserContextI context, SupportFile arg1) throws ARException {
        this.verifyUserContext(context);
        if (arg1 != null && arg1.getKey() != null) {
            this.validateSupportFileType(arg1.getKey().getFileType());
            this.validateARNameType(arg1.getKey().getName(), false);
        }
    }

    public void verifyARGetListSupportFile(ApiUserContextI context, int arg1, String arg2, int arg3, long arg4) throws ARException {
        this.verifyUserContext(context);
        this.validateSupportFileType(arg1);
        this.validateARNameType(arg2, false);
    }

    public void verifyARDeleteSupportFile(ApiUserContextI context, SupportFileKey arg1) throws ARException {
        this.verifyUserContext(context);
        if (arg1 != null) {
            this.validateSupportFileType(arg1.getFileType());
            this.validateARNameType(arg1.getName(), false);
        }
    }

    public void verifyARGetEntryBlob(ApiUserContextI context, String arg1, String arg2, int arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
        this.validateAREntryIdList(arg2, false);
    }

    public void verifyARGetEntryBlob(ApiUserContextI context, String arg1, String arg2, int arg3, String arg4) throws ARException {
        this.verifyARGetEntryBlob(context, arg1, arg2, arg3);
    }

    public void verifyARGetServerInfo(ApiUserContextI context, int[] arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateARServerInfoRequestList(arg1);
    }

    public void encryptPasswordInfo(String charSet, ServerInfoMap serverInfoMap) {
        Value value = (Value)serverInfoMap.get(151);
        if (value != null && value.getDataType() == DataType.CHAR && (value = this.encryptValue(charSet, value)) != null) {
            serverInfoMap.put(151, value);
        }
        if ((value = (Value)serverInfoMap.get(153)) != null && value.getDataType() == DataType.CHAR && (value = this.encryptValue(charSet, value)) != null) {
            serverInfoMap.put(153, value);
        }
        if ((value = (Value)serverInfoMap.get(154)) != null && value.getDataType() == DataType.CHAR && (value = this.encryptValue(charSet, value)) != null) {
            serverInfoMap.put(154, value);
        }
        if ((value = (Value)serverInfoMap.get(161)) != null && value.getDataType() == DataType.CHAR && (value = this.encryptValue(charSet, value)) != null) {
            serverInfoMap.put(161, value);
        }
        if ((value = (Value)serverInfoMap.get(164)) != null && value.getDataType() == DataType.CHAR && (value = this.encryptValue(charSet, value)) != null) {
            serverInfoMap.put(164, value);
        }
    }

    public void verifyARSetServerInfo(ApiUserContextI context, ServerInfoMap serverInfoMap) throws ARException {
        this.verifyUserContext(context);
        if (this.validatePasswordFieldsInServerInfoList(serverInfoMap) && context instanceof ARServerUser) {
            this.encryptPasswordInfo(((ARServerUser)context).getServerCharSet(), serverInfoMap);
        }
        this.validateARServerInfoList(serverInfoMap);
    }

    public void verifyARGetServerStatistics(ApiUserContextI context, int[] requestList) throws ARException {
        this.verifyUserContext(context);
        this.validateARServerInfoRequestList2(requestList);
    }

    public void verifyARExport(ApiUserContextI context, List<StructItemInfo> items, String arg2, int arg3, WorkflowLockInfo arg4) throws ARException {
        this.verifyUserContext(context);
        this.validateARStructItemList(items, false);
    }

    public void verifyARImport(ApiUserContextI context, List<StructItemInfo> arg1, int arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARStructItemList(arg1, true);
    }

    public void verifyARImport(ApiUserContextI context, List<StructItemInfo> arg1, int arg2, String arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARStructItemList(arg1, true);
        this.validateBuffer(arg3);
    }

    public void verifyARGetEntryStatistics(ApiUserContextI context, String arg1, QualifierInfo arg2, ArithmeticOrRelationalOperand arg3, int arg4, int[] arg5) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1, false);
        this.validateARQualifierInfo(arg2, true);
        this.validateARFieldValueOrArithInfo(arg3, true);
        this.validateARStatistic(arg4);
    }

    public void verifyARGetListSQL(ApiUserContextI context, String arg1, int arg2, boolean arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARSqlCommand(arg1);
    }

    public void verifyARExecuteProcess(ApiUserContextI context, String arg1, boolean arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARCommand(arg1);
    }

    public void verifyARVerifyUser(ApiUserContextI context) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetListGroup(ApiUserContextI context, String arg1, String arg2) throws ARException {
        this.verifyUserContext(context);
        this.validateARAccessNameType(arg1, true);
    }

    public void verifyARGetListRole(ApiUserContextI context, String arg1, String arg2, String arg3) throws ARException {
        this.verifyUserContext(context);
        this.validateARAccessNameType(arg1, true);
    }

    public void verifyARGetListUser(ApiUserContextI context, int option, long changedSince) throws ARException {
        this.verifyUserContext(context);
        if (option < 0) {
            this.throwValidationException(2, 235);
        }
    }

    public void verifyAREndTransactionOption(ApiUserContextI context, int transactionOption) throws ARException {
        this.verifyUserContext(context);
        if (transactionOption != 1 && transactionOption != 2) {
            this.throwValidationException(2, 900);
        }
    }

    public void verifyARGetLocalizedValue(ApiUserContextI context, LocalizedValueCriteria criteria, LocalizedRequestInfo request) throws ARException {
        this.verifyUserContext(context);
        if (request == null) {
            this.throwValidationException(2, 442, "requestInfo");
        }
    }

    public void verifyARGetMultipleLocalizedValues(ApiUserContextI context, LocalizedValueCriteria arg1, List<LocalizedRequestInfo> arg2) throws ARException {
        this.verifyUserContext(context);
        if (arg2 == null) {
            this.throwValidationException(2, 442, "requestInfo");
        }
    }

    public void verifyARGetListSQLForActiveLink(ApiUserContextI context, String actlinkName, int actionIndex, int actionType, Timestamp timestamp, List<Value> keywordList, List<Value> parameterList, int maxRetrieve, boolean retrieveTotalMatches) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARExecuteProcessForActiveLink(ApiUserContextI context, String actlinkName, int actionIndex, int actionType, int fieldId, Timestamp timestamp, Entry keywordList, Entry parameterList, boolean asyncMode) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARExecuteProcessForActiveLink(ApiUserContextI context, String actlinkName, int actionIndex, int actionType, int fieldId, Timestamp timestamp, List<Value> keywordList, List<Value> parameterList, boolean asyncMode) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetMultipleExtFieldCandidates(ApiUserContextI context, Object[] compoundFormInfo) throws ARException {
        this.verifyUserContext(context);
        if (compoundFormInfo == null) {
            this.throwValidationException(2, 233);
        }
    }

    public void verifyARGetListExtFormCandidates(ApiUserContextI context, int formType) throws ARException {
        this.verifyUserContext(context);
        if (formType > 6) {
            this.throwValidationException(2, 233);
        }
    }

    public void verifyARValidateLicense(ApiUserContextI context, String arg1) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARValidateMultipleLicenses(ApiUserContextI context, List<String> arg1) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetListLicense(ApiUserContextI context, String arg1) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARXMLCreateEntry(ApiUserContextI context, String arg1, String arg2, String arg3, String arg4) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARXMLSetEntry(ApiUserContextI context, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARXMLGetEntry(ApiUserContextI context, String arg1, String arg2, String arg3, String arg4) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetMultipleCurrencyRatioSets(ApiUserContextI context, List<Timestamp> arg1) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetMultipleEntryPoints(ApiUserContextI context, long arg1, List<String> arg2, int[] arg3, int arg4, String arg5, boolean arg6) throws ARException {
        this.verifyUserContext(context);
        if (arg2 != null && arg2.isEmpty()) {
            this.validateARNameList(arg2, true);
        }
    }

    public void verifyARGetListApplicationState(ApiUserContextI context) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetApplicationState(ApiUserContextI context, String arg1) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARSetApplicationState(ApiUserContextI context, String arg1, String arg2) throws ARException {
        this.verifyUserContext(context);
    }

    public void verifyARGetListEntryWithMultiSchemaFields(ApiUserContextI context, RegularQuery arg1, int arg2, int arg3, boolean arg4, OutputInteger arg5) throws ARException {
        this.verifyUserContext(context);
        this.validateRegularQuery(arg1);
    }

    public void verifyARGetListValuesFromMultiSchemaEntries(ApiUserContextI context, RegularComplexQuery arg1, int arg2, int arg3, boolean arg4, OutputInteger arg5) throws ARException {
        this.verifyUserContext(context);
        this.validateComplexRegularQuery(arg1);
    }

    private void throwValidationException(int returnCode, int errorCode) throws ARException {
        this.throwValidationException(returnCode, errorCode, null);
    }

    private void throwValidationException(int returnCode, int errorCode, String appendMsg) throws ARException {
        ARException e = new ARException(returnCode, errorCode, appendMsg);
        this.context.setLastStatus(e.getLastStatus());
        throw e;
    }

    public void verifyARSetGetEntry(ApiUserContextI context, String formName, String entryId, Entry entry, Timestamp ts, int option, int[] entryListFields) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(formName, false);
        this.validateAREntryIdList(entryId, false);
        this.validateAREntry(entry, true);
        this.validateAREntryIdList(entryId, false);
    }

    public void verifyARCreateOverlay(ApiUserContextI context, OverlaidInfo arg) throws ARException {
        this.verifyUserContext(context);
        this.validateAROverlaidInfo(arg);
    }

    public void verifyARCreateOverlayFromObject(ApiUserContextI context, OverlaidInfo baseObj, OverlaidInfo customObj) throws ARException {
        this.verifyUserContext(context);
        if (customObj != null && customObj.getName() != null && customObj.getName().length() > 0) {
            this.validateAROverlaidInfo(customObj);
        }
        if (baseObj != null && baseObj.getName() != null && baseObj.getName().length() > 0) {
            this.validateAROverlaidInfo(baseObj);
        }
        if (baseObj != null && (baseObj.getName() != null && baseObj.getName().length() > 0 || baseObj.getId() != 0) && customObj != null && (customObj.getName() != null && customObj.getName().length() > 0 || customObj.getId() != 0) && baseObj.getObjType() != customObj.getObjType()) {
            this.throwValidationException(2, 8861);
        }
    }

    public void verifyARMergeMultiMatchOpts(int multiMatchOpt) throws ARException {
        switch (multiMatchOpt) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ARException(2, 233, "Bad multiMatch Option:" + multiMatchOpt);
            }
        }
    }

    public void verifyARCreateAssociation(ApiUserContextI ctx, Association arg1) throws ARException {
        this.verifyUserContext(ctx);
        this.validateARNameType(arg1.getName(), false);
        this.validateARNameType(arg1.getPrimaryFormName(), false);
        this.validateARNameType(arg1.getSecondaryFormName(), false);
        if (arg1.getAssociationType() == 1) {
            DirectAssociation directAssociation = (DirectAssociation)arg1;
            this.verifyDirectAssociation(directAssociation);
        } else {
            IndirectAssociation indirectAssociation = (IndirectAssociation)arg1;
            this.validateARNameType(indirectAssociation.getAssociationFormName(), false);
        }
        this.validateARPropList(arg1.getProperties(), true);
    }

    public void verifyARSetAssociation(ApiUserContextI context, Association arg1) throws ARException {
        this.verifyUserContext(context);
        this.validateARNameType(arg1.getName(), false);
        this.validateARNameType(arg1.getNewName(), true);
        this.validateARNameType(arg1.getPrimaryFormName(), true);
        this.validateARNameType(arg1.getSecondaryFormName(), true);
        this.validateARAccessNameType(arg1.getOwner(), true);
        this.validateARPropList(arg1.getProperties(), true);
        if (arg1.getAssociationType() == 1) {
            DirectAssociation directAssoc = (DirectAssociation)arg1;
            this.verifyDirectAssociation(directAssoc);
        } else {
            IndirectAssociation indirectAssociation = (IndirectAssociation)arg1;
            this.validateARNameType(indirectAssociation.getAssociationFormName(), true);
        }
    }

    public void verifyARGetAssociation(ARServerUser context2, String key) throws ARException {
        this.verifyUserContext(context2);
        this.validateARNameType(key, false);
    }

    public void verifyARGetListAssociation(ARServerUser context2, String formName, long changedSince, ObjectPropertyMap props) throws ARException {
        this.verifyUserContext(context2);
        this.validateARNameType(formName, true);
    }

    public void verifyDirectAssociation(DirectAssociation directAssoc) throws ARException {
        if (directAssoc.getPkfkMappingSet() != null && directAssoc.getPkfkMappingSet().isEmpty()) {
            this.throwValidationException(2, 494);
        }
    }

    public void verifyARGetMultipleAssociations(ARServerUser arServerUser, long changedSince, List<String> names, AssociationCriteria criteria) {
    }

    public void verifyARChangeIdInfo(ARServerUser arUser, List<ChangeIdInfo> changeIdInfoList) throws ARException {
        if (changeIdInfoList == null || changeIdInfoList.isEmpty()) {
            this.throwValidationException(2, 571);
        }
        for (ChangeIdInfo changeIdInfo : changeIdInfoList) {
            this.validateARChangeIdInfo(changeIdInfo);
        }
    }
}

