/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.math.BigDecimal;

@ARStructTypeInfo(Name="ARFuncCurrencyStruct", NumberOfMembers=2)
public class FuncCurrencyInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6003158594992334864L;
    @ARStructMemTypeInfo(Name="value", Offset=0)
    private BigDecimal m_value;
    @ARStructMemTypeInfo(Name="currencyCode", Offset=1)
    private String m_currencyCode;

    public FuncCurrencyInfo() {
        this.m_value = null;
        this.m_currencyCode = null;
    }

    public FuncCurrencyInfo(BigDecimal value, String currencyCode) {
        this.m_value = value;
        this.m_currencyCode = currencyCode;
    }

    public FuncCurrencyInfo(String value, String currencyCode) {
        if (value == null || value.length() == 0 || ".".equals(value)) {
            value = "0";
        }
        try {
            this.m_value = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            this.m_value = new BigDecimal(0);
        }
        this.m_currencyCode = currencyCode;
    }

    public BigDecimal getValue() {
        return this.m_value;
    }

    public String getValueString() {
        if (this.m_value == null) {
            return null;
        }
        return this.m_value.toString();
    }

    public void setValue(BigDecimal value) {
        this.m_value = value;
    }

    public String getCurrencyCode() {
        return this.m_currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.m_currencyCode = currencyCode;
    }

    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        this.m_value = ConversionUtil.getBigDecimalValue(ARTypeMgr.GetAt((Object)rawData, 0));
        this.m_currencyCode = ConversionUtil.getStringValue(ARTypeMgr.GetAt((Object)rawData, 1));
    }

    Object toVariant(ARServerUser ctx) {
        Object[] var = new Object[]{ConversionUtil.getStringValue(this.m_value), this.m_currencyCode};
        return var;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Value", this.m_value).append("Currency Code", this.m_currencyCode).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FuncCurrencyInfo)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FuncCurrencyInfo rhs = (FuncCurrencyInfo)obj;
        return new EqualsBuilder().append(this.m_value, rhs.m_value).append(this.m_currencyCode, rhs.m_currencyCode).isEquals();
    }

    public Object clone() throws CloneNotSupportedException {
        FuncCurrencyInfo obj = (FuncCurrencyInfo)super.clone();
        obj.m_value = this.m_value;
        obj.m_currencyCode = this.m_currencyCode;
        return obj;
    }

    public void clear() {
        this.m_value = null;
        this.m_currencyCode = null;
    }

    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_value).append(this.m_currencyCode).toHashCode();
    }
}

