/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.Reference;
import com.bmc.arsys.api.ReferenceType;
import com.bmc.arsys.api.Value;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExternalReference
extends Reference
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4716710275928533278L;
    private List<Integer> m_adminGroupList;
    private Value m_value;

    public ExternalReference() {
    }

    public ExternalReference(String label, String description, ReferenceType refType, List<Integer> adminGroups, Value val) {
        super(label, description, refType, val != null ? val.toString() : "");
        this.m_adminGroupList = adminGroups;
        this.m_value = val;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExternalReference extRef = (ExternalReference)super.clone();
        if (this.m_adminGroupList != null) {
            extRef.m_adminGroupList = new ArrayList<Integer>(this.m_adminGroupList.size());
            for (int i = 0; i < this.m_adminGroupList.size(); ++i) {
                extRef.m_adminGroupList.add(new Integer(this.m_adminGroupList.get(i)));
            }
        }
        if (this.m_value != null) {
            extRef.m_value = (Value)this.m_value.clone();
        }
        return extRef;
    }

    ExternalReference(String label, String description, int refType, int dataType, List<Integer> adminGroups, Value val) {
        this(label, description, ReferenceType.toReferenceType(refType), adminGroups, val);
    }

    public List<Integer> getAdminGroupList() {
        return this.m_adminGroupList;
    }

    public Value getValue() {
        return this.m_value;
    }

    public void setAdminGroupList(List<Integer> groups) {
        this.m_adminGroupList = groups;
    }

    public void setValue(Value val) {
        this.m_value = val;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Admin Group List", this.m_adminGroupList).append("Value", this.m_value).toString();
    }

    @Override
    void fromVariant(Object[] rawData, ARServerUser ctx) {
        if (rawData == null) {
            return;
        }
        super.fromVariant(rawData, ctx);
        this.setAdminGroupList(ARTypeMgr.getInstance().ObjectListFromVariant(Integer.class, ARTypeMgr.GetAt((Object)rawData, new int[]{3, 1, 0}), ctx));
        this.setValue(ARTypeMgr.getInstance().ObjectFromVariant(Value.class, ARTypeMgr.GetAt((Object)rawData, new int[]{3, 1, 1}), ctx));
    }

    @Override
    Object toVariant(ARServerUser ctx) {
        Object[] var = (Object[])super.toVariant(ctx);
        ((Object[])var[3])[1] = new Object[]{ARTypeMgr.getInstance().ObjectToVariant(this.getAdminGroupList(), ctx), ARTypeMgr.getInstance().ObjectToVariant(this.getValue(), ctx)};
        return var;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.m_adminGroupList).append(this.m_value).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExternalReference)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExternalReference rhs = (ExternalReference)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.m_adminGroupList, rhs.m_adminGroupList).append(this.m_value, rhs.m_value).isEquals();
    }
}

