/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.DiaryItem;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.utils.CatalogReader;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DiaryListValue
extends ArrayList<DiaryItem>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -351544304667070934L;
    private static Logger log = Logger.getLogger(DiaryListValue.class);
    private String appendedText;
    public static final String AR_DEFN_DIARY_SEP = new String(new char[]{'\u0003'});
    public static final String AR_DEFN_DIARY_COMMA = new String(new char[]{'\u0004'});

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DiaryListValue)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        DiaryListValue rhs = (DiaryListValue)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.appendedText, rhs.appendedText).isEquals();
    }

    public static DiaryListValue decode(String encoded) throws ARException {
        DiaryListValue diaryList = new DiaryListValue();
        if (encoded != null) {
            String[] lines;
            for (String line : lines = encoded.split(AR_DEFN_DIARY_SEP)) {
                if (line.length() == 0) continue;
                String[] parts = line.split(AR_DEFN_DIARY_COMMA);
                if (parts.length >= 3) {
                    String timeValStr = parts[0];
                    long timeVal = 0L;
                    try {
                        timeVal = Long.parseLong(timeValStr);
                    }
                    catch (Exception e) {
                        String msg = CatalogReader.getInstance().getMessage(339);
                        log.warn(msg + " for timestamp " + line);
                    }
                    String user = parts[1];
                    String text = parts[2];
                    int numParts = parts.length;
                    for (int i = 3; i < numParts; ++i) {
                        text = text + AR_DEFN_DIARY_COMMA + parts[i];
                    }
                    DiaryItem item = new DiaryItem(user, text, new Timestamp(timeVal));
                    diaryList.add(item);
                    continue;
                }
                throw new ARException(2, 339, encoded);
            }
        }
        return diaryList;
    }

    public String encode() {
        StringBuilder sb = new StringBuilder();
        for (DiaryItem di : this) {
            if (di != null) {
                sb.append(new Long(di.getTimestamp().getValue()).toString());
                sb.append(AR_DEFN_DIARY_COMMA);
                sb.append(di.getUser());
                if (di.getText() != null) {
                    sb.append(AR_DEFN_DIARY_COMMA);
                    sb.append(di.getText());
                }
            }
            sb.append(AR_DEFN_DIARY_SEP);
        }
        return sb.toString();
    }

    @Override
    public Object clone() {
        DiaryListValue obj = new DiaryListValue();
        try {
            for (DiaryItem di : this) {
                obj.add((DiaryItem)di.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return obj;
    }

    Object toVariant(ARServerUser ctx) {
        if (this.appendedText != null) {
            return this.appendedText;
        }
        return this.encode();
    }

    public String getAppendedText() {
        return this.appendedText;
    }

    public void setAppendedText(String appendedText) {
        this.appendedText = appendedText;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Appended Text", this.appendedText).toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.appendedText).toHashCode();
    }
}

