/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.CommandLineBase;
import com.bmc.arsys.apiext.definition.CompletionEvent;
import com.bmc.arsys.apiext.definition.DefinitionEvent;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.ExpansionEvent;
import com.bmc.arsys.apiext.definition.ExportCommandParser;
import com.bmc.arsys.apiext.definition.IDefinitionListener;
import com.bmc.arsys.apiext.definition.InitializationEvent;
import com.bmc.arsys.apiext.definition.ProcessEvent;
import com.bmc.arsys.apiext.definition.Util;
import com.bmc.arsys.artranscode.ARCharSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DefinitionImport
extends CommandLineBase {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String OBJECT_DATA_ADDITIONAL_LINE = "   objectdata     :+";
    private static Logger logger = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private boolean hasErrors = false;
    private boolean hasWarnings = false;
    private static final int MINIMUM_ARGS = 5;
    private final int failed = 0;
    private final List<IDefinitionListener> listeners = new ArrayList<IDefinitionListener>();
    private final int successful = 0;
    private final int warnings = 0;
    private List<List<String>> dvdList = null;
    private boolean dvdOnly = true;

    public static void main(String[] args) {
        DefinitionImport instance = new DefinitionImport();
        instance.createListener();
        if (args.length == 1 && args[0].equals("--version")) {
            instance.printVersion();
        } else if (args.length > 5) {
            DefinitionOptions options = null;
            try {
                options = instance.parseCommandLine(args);
                instance.validateCommandLine(options, false);
            }
            catch (Exception e) {
                System.err.println("Unable to parse command line parameters. Please verify your parameters.");
            }
            if (options != null) {
                try {
                    instance.setOptions(options);
                    options.validate();
                    options.connect();
                    if (options.getContext().isAdministrator() || options.getContext().isSubAdministrator()) {
                        if (options.getCommandSetFile() != null) {
                            File file = new File(options.getCommandSetFile());
                            ExportCommandParser parser = new ExportCommandParser(options);
                            parser.populateFromFile(file, false);
                        }
                        instance.importObjects();
                    } else if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)"Only users that belong to the Administrator or Sub Administrator groups can import definitions.");
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)"Import failed: Unable to load the AR System JNI interface. Please make sure your environment includes the location of the AR System native libraries");
                    }
                }
                catch (Error e) {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)MessageFormat.format("Import failed: {0}", e.getMessage()));
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof ARException) && logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.error((Object)MessageFormat.format("Import failed: {0}{1}", System.getProperty("line.separator"), e.getMessage()));
                    }
                }
            }
        } else {
            instance.printUsage(false);
        }
    }

    public void addListener(IDefinitionListener listener) {
        this.listeners.add(listener);
    }

    public List<StatusInfo> importObjects() throws DefinitionException, ARException, IOException {
        boolean isXML = this.getOptions().isXML();
        if (logger.isEnabledFor((Priority)Level.INFO)) {
            logger.info((Object)MessageFormat.format("Importing objects from {0} to {1}", this.getOptions().getFileName(), this.getOptions().getServer()));
        }
        List<StatusInfo> result = null;
        File newFile = null;
        try {
            List<StatusInfo> dvdResult;
            File defFile;
            String fileName;
            if (!isXML && (fileName = this.getOptions().getFileName()) != null && fileName.endsWith(".def") && (defFile = new File(fileName)).exists()) {
                String charset = null;
                charset = this.getOptions().getCharset() != null ? this.getOptions().getCharset() : ARCharSet.getServerKnownCodeSet((String)System.getProperty("file.encoding"));
                if (charset.equalsIgnoreCase("shift_jis")) {
                    charset = "EUC_JP";
                }
                if (System.getProperty("file.encoding").equalsIgnoreCase("MS932")) {
                    charset = "EUC_JP";
                }
                if ((newFile = DefinitionImport.updateDefFileWithCharSet(this.getOptions(), charset, true)) != null) {
                    logger.info((Object)("Charset is missing in the definition file, using charset : " + charset));
                }
            }
            if (!isXML) {
                this.extractDataVisualizationDefinitions();
            } else {
                this.dvdOnly = false;
            }
            this.getOptions().connect();
            this.checkDSOLicense();
            boolean importComplete = false;
            importComplete = this.getOptions().getItems() == null || this.getOptions().getItems() != null && this.getOptions().getItems().isEmpty();
            result = importComplete ? this.importComplete(isXML) : this.importItems(isXML);
            if (this.dvdList != null && !this.dvdList.isEmpty() && (dvdResult = this.importDataVisualizationDefinitions(importComplete)) != null && !dvdResult.isEmpty()) {
                if (result == null) {
                    result = dvdResult;
                } else {
                    result.addAll(dvdResult);
                }
            }
        }
        catch (ARException e) {
            for (IDefinitionListener listener : this.listeners) {
                listener.event(new CompletionEvent(0, 0, 0, e.getLastStatus()));
            }
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (newFile != null) {
                newFile.delete();
            }
        }
        for (IDefinitionListener listener : this.listeners) {
            listener.event(new CompletionEvent(0, 0, 0, result));
        }
        return result;
    }

    public static File updateDefFileWithCharSet(DefinitionOptions options, String requiredCharSet, boolean append) throws DefinitionException {
        String charSet = null;
        FileOutputStream outStream = null;
        File fileCheck = new File(options.getFileName());
        if (append && fileCheck.exists()) {
            charSet = DefinitionImport.getDefFileCharSet(options);
        }
        if (charSet != null) {
            return null;
        }
        File newdefFile = null;
        byte[] originalFileBytes = null;
        try {
            try {
                originalFileBytes = DefinitionImport.getBytesFromFile(new File(options.getFileName()));
            }
            catch (FileNotFoundException e) {
                throw new DefinitionException("Unable to open export file", e);
            }
            catch (IOException e) {
                throw new DefinitionException("Unable to open export file", e);
            }
            File defFile = new File(options.getFileName());
            int lastIndex = options.getFileName().lastIndexOf("\\");
            String newName = options.getFileName().substring(0, lastIndex + 1) + "Fixed_DS_" + defFile.getName();
            newdefFile = new File(newName);
            outStream = new FileOutputStream(newdefFile, append);
            String firstLine = "char-set: " + requiredCharSet + NEWLINE;
            outStream.write(firstLine.getBytes());
            outStream.write(originalFileBytes);
            options.setFileName(newdefFile.getAbsolutePath());
        }
        catch (UnsupportedEncodingException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        catch (FileNotFoundException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        catch (IOException e) {
            throw new DefinitionException("Unable to write to export file", e);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                throw new DefinitionException("Unable to close export file", e);
            }
        }
        return newdefFile;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        is.close();
        return bytes;
    }

    public static String getDefFileCharSet(DefinitionOptions options) throws DefinitionException {
        String charSet = null;
        BufferedReader fileReader = null;
        try {
            FileInputStream inStream = new FileInputStream(options.getFileName());
            InputStreamReader streamReader = new InputStreamReader(inStream);
            fileReader = new BufferedReader(streamReader);
            String line = fileReader.readLine();
            if (line != null && line.startsWith("char-set: ")) {
                charSet = line.substring("char-set: ".length());
                fileReader.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        catch (IOException e) {
            throw new DefinitionException("Unable to open export file", e);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    throw new DefinitionException("Unable to close export file", e);
                }
            }
        }
        return charSet;
    }

    public void removeListener(IDefinitionListener listener) {
        this.listeners.remove(listener);
    }

    private void createListener() {
        this.listeners.add(new IDefinitionListener(){

            @Override
            public void event(DefinitionEvent event) {
                if (event instanceof CompletionEvent) {
                    List<StatusInfo> lastStatus = ((CompletionEvent)event).getStatusList();
                    if (lastStatus != null) {
                        for (StatusInfo statusInfo : lastStatus) {
                            if (statusInfo.getMessageType() == 2) {
                                DefinitionImport.this.hasErrors = true;
                            }
                            if (statusInfo.getMessageType() != 1) continue;
                            DefinitionImport.this.hasWarnings = true;
                        }
                    }
                    if (DefinitionImport.this.hasErrors) {
                        if (logger.isEnabledFor((Priority)Level.ERROR)) {
                            logger.error((Object)"Import completed with errors");
                        }
                    } else if (DefinitionImport.this.hasWarnings) {
                        if (logger.isEnabledFor((Priority)Level.INFO)) {
                            logger.info((Object)"Import completed with warnings");
                        }
                    } else if (logger.isEnabledFor((Priority)Level.INFO)) {
                        logger.info((Object)"Import completed");
                    }
                    if ((DefinitionImport.this.hasErrors || DefinitionImport.this.hasWarnings) && lastStatus != null) {
                        for (StatusInfo statusInfo : lastStatus) {
                            if (statusInfo.getMessageType() == 2) {
                                if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                                logger.error((Object)statusInfo);
                                continue;
                            }
                            if (!logger.isEnabledFor((Priority)Level.INFO)) continue;
                            logger.info((Object)statusInfo);
                        }
                    }
                } else if (event instanceof InitializationEvent) {
                    InitializationEvent init = (InitializationEvent)event;
                    switch (init.getEvent()) {
                        case 1: {
                            if (!logger.isEnabledFor((Priority)Level.INFO)) break;
                            logger.info((Object)"Connecting to server");
                            break;
                        }
                        case 3: {
                            if (!logger.isEnabledFor((Priority)Level.INFO)) break;
                            logger.info((Object)MessageFormat.format("Importing {0} objects to {1}", init.getNumItems(), DefinitionImport.this.getOptions().getFileName()));
                            break;
                        }
                    }
                } else if (event instanceof ExpansionEvent || event instanceof ProcessEvent) {
                    // empty if block
                }
            }
        });
    }

    private String getName(String line) {
        String name = null;
        if (line.startsWith("   name           : ")) {
            name = line.replace("   name           : ", "");
        }
        return name;
    }

    private DefinitionItemType getType(String line) {
        if (line.startsWith("begin active link")) {
            return DefinitionItemType.ACTIVE_LINK;
        }
        if (line.startsWith("begin admin ext")) {
            return DefinitionItemType.ADMIN_EXT;
        }
        if (line.startsWith("begin char menu")) {
            return DefinitionItemType.MENU;
        }
        if (line.startsWith("begin container")) {
            return DefinitionItemType.CONTAINER;
        }
        if (line.startsWith("begin distributed mapping")) {
            return DefinitionItemType.DISTRIBUTED_MAPPING;
        }
        if (line.startsWith("begin filter")) {
            return DefinitionItemType.FILTER;
        }
        if (line.startsWith("begin escalation")) {
            return DefinitionItemType.ESCALATION;
        }
        if (!line.startsWith("begin group")) {
            if (line.startsWith("begin schema")) {
                return DefinitionItemType.FORM;
            }
            if (line.startsWith("begin schema data")) {
                return DefinitionItemType.FORM_DATA;
            }
            if (line.startsWith("begin distributed pool")) {
                return DefinitionItemType.DISTRIBUTED_POOL;
            }
            if (line.startsWith("begin vui")) {
                return DefinitionItemType.VIEW;
            }
            if (!line.startsWith("begin lock block")) {
                if (line.startsWith("begin application")) {
                    return DefinitionItemType.APPLICATION;
                }
                if (line.startsWith("begin image")) {
                    return DefinitionItemType.IMAGE;
                }
                if (line.startsWith("begin association")) {
                    return DefinitionItemType.ASSOCIATION;
                }
            }
        }
        return null;
    }

    private List<StatusInfo> importComplete(boolean isXML) throws ARException, IOException {
        ArrayList<StatusInfo> result = new ArrayList();
        int optionMask = 0;
        if (this.getOptions().isOverwrite()) {
            optionMask |= 1;
            if (!this.getOptions().isDeleteExcessFields()) {
                optionMask |= 0x40;
            }
            if (!this.getOptions().isDeleteExcessViews()) {
                optionMask |= 0x1000;
            }
            if (this.getOptions().isPreserveIndex()) {
                optionMask |= 0x20000;
            }
            if (this.getOptions().isPreserveVUINamespace()) {
                optionMask |= 0x40000;
            }
            if (this.getOptions().isPreserveAppForms()) {
                optionMask |= 0x80000;
            }
            if (this.getOptions().isImportWithAppOwner()) {
                optionMask |= 0x100000;
            }
            if (this.getOptions().isOverwriteFullTextOptions()) {
                optionMask |= 0x800000;
            }
            if (this.getOptions().isOverwriteDisplayProperties()) {
                optionMask |= 0x1000000;
            }
            optionMask |= this.getOptions().getConflictHandling();
        }
        this.getOptions().getContext().importDefFromFile(this.getOptions().getFileName(), optionMask, null, this.getOptions().getLabelName());
        result = this.getOptions().getContext().getLastStatus();
        return result;
    }

    private List<StatusInfo> importItems(boolean isXML) throws ARException, IOException {
        ArrayList<StatusInfo> result = new ArrayList();
        List<StructItemInfo> items = this.convertToItemList(isXML);
        this.getOptions().getContext().login();
        int optionMask = 0;
        if (this.getOptions().isOverwrite()) {
            optionMask |= 1;
            if (!this.getOptions().isDeleteExcessFields()) {
                optionMask |= 0x40;
            }
            if (!this.getOptions().isDeleteExcessViews()) {
                optionMask |= 0x1000;
            }
            if (this.getOptions().isPreserveIndex()) {
                optionMask |= 0x20000;
            }
            if (this.getOptions().isPreserveVUINamespace()) {
                optionMask |= 0x40000;
            }
            if (this.getOptions().isPreserveAppForms()) {
                optionMask |= 0x80000;
            }
            if (this.getOptions().isImportWithAppOwner()) {
                optionMask |= 0x100000;
            }
            if (this.getOptions().isOverwriteFullTextOptions()) {
                optionMask |= 0x800000;
            }
            if (this.getOptions().isOverwriteDisplayProperties()) {
                optionMask |= 0x1000000;
            }
            optionMask |= this.getOptions().getConflictHandling();
        }
        if (items != null && !items.isEmpty()) {
            this.getOptions().getContext().importDefFromFile(this.getOptions().getFileName(), optionMask, items, this.getOptions().getLabelName());
        } else if ((this.dvdList == null || this.dvdList.isEmpty()) && logger.isEnabledFor((Priority)Level.INFO)) {
            logger.info((Object)"Import Aborted. There are no objects to import");
            this.hasErrors = true;
        }
        result = this.getOptions().getContext().getLastStatus();
        return result;
    }

    private List<StatusInfo> importDataVisualizationDefinitions(boolean importComplete) throws IOException, DefinitionException, ARException {
        ArrayList<StatusInfo> result = new ArrayList<StatusInfo>();
        boolean importEntry = true;
        if (this.dvdList != null && !this.dvdList.isEmpty()) {
            for (List<String> definition : this.dvdList) {
                Entry entry = null;
                String module = null;
                String subType = null;
                String name = null;
                boolean flag_flashboards_older_version = false;
                if (definition.get(0).startsWith("begin Flashboards")) {
                    entry = this.processFlashboardsContent(definition);
                    name = (String)((Value)entry.get((Object)8)).getValue();
                    flag_flashboards_older_version = true;
                    module = "Flashboard";
                    subType = "FLASHBOARD";
                } else {
                    entry = this.processDataVisualizationContent(definition);
                    module = (String)((Value)entry.get((Object)41000)).getValue();
                    subType = (String)((Value)entry.get((Object)41052)).getValue();
                    name = (String)((Value)entry.get((Object)41050)).getValue();
                }
                if (!importComplete) {
                    List<BaseItemData> items;
                    DefinitionItemType type;
                    DefinitionItemType definitionItemType = type = !flag_flashboards_older_version ? this.getItemTypeForDataVisualization(module, subType) : DefinitionItemType.FLASHBOARD;
                    if (type != null && (items = this.getOptions().getItems().get((Object)type)) != null && !items.isEmpty()) {
                        for (BaseItemData item : items) {
                            if (name.equals(item.getName())) {
                                importEntry = true;
                                break;
                            }
                            importEntry = false;
                        }
                    }
                }
                if (!importEntry) continue;
                Entry serverEntry = null;
                QualifierInfo qualInfo = this.getDataVisualizationQualifier(module, subType, name);
                List listEntry = this.getOptions().getContext().getListEntry(this.getDataVisualizationForm(), qualInfo, 0, 1, null, null, false, null);
                if (listEntry != null && !listEntry.isEmpty()) {
                    try {
                        serverEntry = this.getOptions().getContext().getEntry(this.getDataVisualizationForm(), ((EntryListInfo)listEntry.get(0)).getEntryID(), null);
                    }
                    catch (ARException e) {
                        List lastStatus = e.getLastStatus();
                        if (lastStatus != null && !lastStatus.isEmpty()) {
                            boolean foundNoEntry = false;
                            for (StatusInfo statusInfo : lastStatus) {
                                if (statusInfo.getMessageNum() != 302L) continue;
                                foundNoEntry = true;
                                break;
                            }
                            if (!foundNoEntry) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                }
                if (serverEntry != null) {
                    for (Integer fieldId : entry.keySet()) {
                        serverEntry.put(fieldId, (Value)entry.get((Object)fieldId));
                    }
                    String entryId = serverEntry.getEntryId();
                    serverEntry.remove((Object)1);
                    serverEntry.remove((Object)2);
                    serverEntry.remove((Object)3);
                    serverEntry.remove((Object)5);
                    serverEntry.remove((Object)6);
                    serverEntry.remove((Object)15);
                    this.getOptions().getContext().setEntry(this.getDataVisualizationForm(), entryId, serverEntry, null, 0);
                    result.addAll(this.getOptions().getContext().getLastStatus());
                    continue;
                }
                entry.remove((Object)1);
                entry.remove((Object)2);
                entry.remove((Object)3);
                entry.remove((Object)5);
                entry.remove((Object)6);
                entry.remove((Object)15);
                this.getOptions().getContext().mergeEntry(this.getDataVisualizationForm(), entry, 0);
                result.addAll(this.getOptions().getContext().getLastStatus());
            }
        }
        return result;
    }

    private DefinitionItemType getItemTypeForDataVisualization(String module, String subType) {
        if ("Flashboard".equals(module)) {
            if ("FLASHBOARD".equals(subType)) {
                return DefinitionItemType.FLASHBOARD;
            }
            if ("ALARM".equals(subType)) {
                return DefinitionItemType.FLASHBOARD_ALARM;
            }
            if ("VARIABLE".equals(subType)) {
                return DefinitionItemType.FLASHBOARD_VARIABLE;
            }
        }
        return null;
    }

    private void extractDataVisualizationDefinitions() throws IOException, DefinitionException {
        String fileName = this.getOptions().getFileName();
        this.dvdList = new ArrayList<List<String>>();
        BufferedReader fileReader = Util.openFile(fileName, null);
        String line = null;
        int lineNumber = 0;
        boolean inDVD = false;
        ArrayList<String> data = null;
        try {
            while ((line = fileReader.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("begin Data Visualization Definition") || line.startsWith("begin Data Visulaization Definition") || line.startsWith("begin Flashboards") || line.startsWith("begin Flashboards")) {
                    data = new ArrayList<String>();
                    inDVD = true;
                } else if (line.startsWith("end")) {
                    inDVD = false;
                    if (data != null) {
                        this.dvdList.add(data);
                    }
                    data = null;
                } else if (line.startsWith("begin ")) {
                    this.dvdOnly = false;
                }
                if (data == null || !inDVD) continue;
                data.add(line);
            }
        }
        catch (Exception e) {
            throw new DefinitionException("Error encountered while parsing definition file for content", e.getCause());
        }
        finally {
            fileReader.close();
        }
    }

    private Entry processDataVisualizationContent(List<String> definition) throws ARException {
        Entry result = null;
        if (definition != null) {
            StringBuilder content = new StringBuilder();
            for (String line : definition) {
                if (line.startsWith(OBJECT_DATA_ADDITIONAL_LINE)) {
                    content.append(line.substring(OBJECT_DATA_ADDITIONAL_LINE.length()).replaceAll("[\r\n]", ""));
                    continue;
                }
                if (!line.startsWith("   objectdata     :")) continue;
                content.append(line.substring("   objectdata     :".length()).replaceAll("[\r\n]", ""));
            }
            int length = content.length();
            if (length > 0) {
                result = new Entry();
                Pattern pattern = Pattern.compile("( \\d+,\\d,\\\"(.*?)\\\";)");
                Matcher matcher = pattern.matcher(content.toString());
                block5: while (matcher.find()) {
                    String group = matcher.group();
                    int firstDelim = group.indexOf(44);
                    int secondDelim = group.indexOf(44, firstDelim + 1);
                    int id = Integer.parseInt(group.substring(1, firstDelim));
                    int type = Integer.parseInt(group.substring(firstDelim + 1, secondDelim));
                    String value = group.substring(secondDelim + 2, group.length() - 2);
                    switch (type) {
                        case 6: {
                            long enumValue = Long.parseLong(value);
                            if (id == 41051) {
                                if (enumValue == 1L) {
                                    result.put(Integer.valueOf(id), new Value((Object)0L, DataType.ENUM));
                                    continue block5;
                                }
                                result.put(Integer.valueOf(id), new Value());
                                continue block5;
                            }
                            result.put(Integer.valueOf(id), new Value((Object)enumValue, DataType.ENUM));
                            continue block5;
                        }
                        case 5: {
                            DiaryListValue decoded = DiaryListValue.decode((String)value);
                            result.put(Integer.valueOf(id), new Value(decoded));
                            continue block5;
                        }
                    }
                    result.put(Integer.valueOf(id), new Value(value, DataType.toDataType((int)type)));
                }
            }
        }
        return result;
    }

    private Entry processFlashboardsContent(List<String> definition) throws ARException {
        Entry result = null;
        String Simple_Definition = null;
        if (definition != null) {
            StringBuilder content = new StringBuilder();
            for (String line : definition) {
                if (line.startsWith(OBJECT_DATA_ADDITIONAL_LINE)) {
                    content.append(line.substring(OBJECT_DATA_ADDITIONAL_LINE.length()).replaceAll("[\r\n]", ""));
                    continue;
                }
                if (!line.startsWith("   objectdata     :")) continue;
                content.append(line.substring("   objectdata     :".length()).replaceAll("[\r\n]", ""));
            }
            int length = content.length();
            if (length > 0) {
                result = new Entry();
                Pattern pattern = Pattern.compile("( \\d+,\\d,\\\"(.*?)\\\";)");
                Matcher matcher = pattern.matcher(content.toString());
                String guid1 = null;
                String guid2 = null;
                String title = "";
                String ltitle = "";
                String chartype = "2";
                String color = null;
                String placement = "3";
                String def_val = "0";
                String color2 = "";
                String label = "";
                String xlabel = "";
                String ylabel = "";
                String xgrid = "1";
                String ygrid = "1";
                String ymin = "0";
                String ymax = "10";
                String auto = "1";
                String showTF = "0";
                String drilldown = "0";
                String custParams = "0";
                String dispType = "0";
                String legendShow = "1";
                String startDate = "0";
                String endDate = "0";
                String varstyle = "0";
                String varshow = "1";
                String fbtype = "0";
                String axis = "0";
                block36: while (matcher.find()) {
                    String group = matcher.group();
                    int firstDelim = group.indexOf(44);
                    int secondDelim = group.indexOf(44, firstDelim + 1);
                    int id = Integer.parseInt(group.substring(1, firstDelim));
                    int type = Integer.parseInt(group.substring(firstDelim + 1, secondDelim));
                    String value = group.substring(secondDelim + 2, group.length() - 2);
                    boolean checkFieldID = id < 40000 || id > 41000;
                    switch (id) {
                        case 40000: {
                            guid2 = value;
                            break;
                        }
                        case 40151: {
                            ylabel = value;
                            break;
                        }
                        case 40152: {
                            ymin = value;
                            break;
                        }
                        case 40153: {
                            ymax = value;
                            break;
                        }
                        case 40155: {
                            xgrid = value;
                            break;
                        }
                        case 40156: {
                            showTF = value;
                            break;
                        }
                        case 40157: {
                            chartype = value;
                            break;
                        }
                        case 40158: {
                            legendShow = value;
                            break;
                        }
                        case 40159: {
                            placement = value;
                            break;
                        }
                        case 40160: {
                            ygrid = value;
                            break;
                        }
                        case 40161: {
                            auto = value;
                            break;
                        }
                        case 40162: {
                            xlabel = value;
                            break;
                        }
                        case 40163: {
                            axis = value;
                            break;
                        }
                        case 40164: {
                            fbtype = value;
                            break;
                        }
                        case 40166: {
                            startDate = value;
                            break;
                        }
                        case 40167: {
                            endDate = value;
                            break;
                        }
                        case 40173: {
                            color = value;
                            break;
                        }
                        case 40174: {
                            drilldown = value;
                            break;
                        }
                        case 40175: {
                            custParams = value;
                            break;
                        }
                        case 40176: {
                            title = value;
                            break;
                        }
                        case 40177: {
                            ltitle = value;
                            break;
                        }
                        case 40178: {
                            dispType = value;
                            break;
                        }
                        case 40200: {
                            guid1 = value;
                            break;
                        }
                        case 40201: {
                            varshow = value;
                            break;
                        }
                        case 40202: {
                            varstyle = value;
                            break;
                        }
                        case 40203: {
                            color2 = value;
                            break;
                        }
                        case 40204: {
                            label = value;
                            break;
                        }
                    }
                    if (!checkFieldID) continue;
                    switch (type) {
                        case 6: {
                            long enumValue = Long.parseLong(value);
                            if (id == 41051) {
                                if (enumValue == 1L) {
                                    result.put(Integer.valueOf(id), new Value((Object)0L, DataType.ENUM));
                                    continue block36;
                                }
                                result.put(Integer.valueOf(id), new Value());
                                continue block36;
                            }
                            result.put(Integer.valueOf(id), new Value((Object)enumValue, DataType.ENUM));
                            continue block36;
                        }
                        case 5: {
                            try {
                                DiaryListValue decoded = DiaryListValue.decode((String)value);
                                result.put(Integer.valueOf(id), new Value(decoded));
                            }
                            catch (ARException e) {
                                result.put(Integer.valueOf(id), new Value(""));
                            }
                            continue block36;
                        }
                    }
                    result.put(Integer.valueOf(id), new Value(value, DataType.toDataType((int)type)));
                }
                result.put(Integer.valueOf(41000), new Value("Flashboard", DataType.CHAR));
                result.put(Integer.valueOf(41050), (Value)result.get((Object)8));
                result.put(Integer.valueOf(41052), new Value("FLASHBOARD", DataType.CHAR));
                Simple_Definition = "<?xml version=\"1.0\" ?><flashboard name=\"" + result.get((Object)8) + "\" guid=\"" + guid1 + "\" title=\"" + title + "\" fbtype=\"" + fbtype + "\" charttype=\"" + chartype + "\" color=\"" + color + "\"><options drilldown=\"" + drilldown + "\" customize=\"" + custParams + "\" displaytype=\"" + dispType + "\"/><legend show=\"" + legendShow + "\" title=\"" + ltitle + "\" placement=\"" + placement + "\"/><axis orientation=\"" + axis + "\"/><x label=\"" + xlabel + "\" showgrid=\"" + xgrid + "\"/><y label=\"" + ylabel + "\" showgrid=\"" + ygrid + "\" auto=\"" + auto + "\" min=\"" + ymin + "\" max=\"" + ymax + "\"/><timeframe show=\"" + showTF + "\" type=\"" + def_val + "\" startdate=\"" + startDate + "\" enddate=\"" + endDate + "\"/><variable name=\"" + result.get((Object)8) + "\" guid=\"" + guid2 + "\" enable=\"" + varshow + "\" label=\"" + label + "\" color=\"" + color2 + "\" style=\"" + varstyle + "\"/></flashboard>";
                result.put(Integer.valueOf(41053), new Value(Simple_Definition, DataType.CHAR));
            }
        }
        return result;
    }

    class ImportItem {
        private String content;
        private boolean inLockedBlock = false;
        private String name;
        private List<String> subItems = new ArrayList<String>();
        private DefinitionItemType type;

        ImportItem() {
        }

        public String getContent() {
            return this.content;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getSubItems() {
            return this.subItems;
        }

        public DefinitionItemType getType() {
            return this.type;
        }

        public boolean isInLockedBlock() {
            return this.inLockedBlock;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setInLockedBlock(boolean inLockedBlock) {
            this.inLockedBlock = inLockedBlock;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSubItems(List<String> subItems) {
            this.subItems = subItems;
        }

        public void setType(DefinitionItemType type) {
            this.type = type;
        }
    }
}

