/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.ws;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.WebSocket;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandler;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketCompositeChannel;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketSelectedChannel;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketSelectedHandler;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketSelectedHandlerImpl;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedChannel;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedHandler;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeChannel;
import com.kaazing.gateway.client.html5.impl.wsn.WebSocketNativeHandler;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketCompositeHandler
implements WebSocketHandler {
    private static final String CLASS_NAME = WebSocketCompositeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static WebSocketSelectedHandlerImpl.WebSocketSelectedHandlerFactory selectHandlerFactory = WebSocketSelectedHandlerImpl.FACTORY;
    private WebSocketHandlerListener handlerListener = this.createListener();
    private final WebSocketSelectedHandler nativeHandler = this.createNativeHandler();
    private final WebSocketSelectedHandler emulatedHandler = this.createEmulatedHandler();
    private final WebSocketSelectedChannelFactory WEBSOCKET_NATIVE_CHANNEL_FACTORY = new WebSocketSelectedChannelFactory(){

        @Override
        public WebSocketSelectedChannel createChannel(WSURI location, String protocol, boolean isBinary) {
            return new WebSocketNativeChannel(location, protocol, isBinary);
        }
    };
    private final WebSocketSelectedChannelFactory WEBSOCKET_EMULATED_CHANNEL_FACTORY = new WebSocketSelectedChannelFactory(){

        @Override
        public WebSocketSelectedChannel createChannel(WSURI location, String protocol, boolean isBinary) {
            return new WebSocketEmulatedChannel(location, protocol, isBinary);
        }
    };
    final Map<String, String[]> strategyChoices = new HashMap<String, String[]>();
    final Map<String, WebSocketStrategy> strategyMap = new HashMap<String, WebSocketStrategy>();
    private WebSocketHandlerListener listener;

    private final WebSocketSelectedHandler createNativeHandler() {
        WebSocketSelectedHandler selectedHandler = selectHandlerFactory.createSelectedHandler();
        WebSocketNativeHandler nativeHandler = new WebSocketNativeHandler();
        selectedHandler.setListener(this.handlerListener);
        selectedHandler.setNextHandler(nativeHandler);
        return selectedHandler;
    }

    private final WebSocketSelectedHandler createEmulatedHandler() {
        WebSocketSelectedHandler selectedHandler = selectHandlerFactory.createSelectedHandler();
        WebSocketEmulatedHandler emulatedHandler = new WebSocketEmulatedHandler();
        selectedHandler.setListener(this.handlerListener);
        selectedHandler.setNextHandler(emulatedHandler);
        return selectedHandler;
    }

    public WebSocketCompositeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
        this.strategyChoices.put("ws", new String[]{"java:ws", "java:wse"});
        this.strategyChoices.put("wss", new String[]{"java:wss", "java:wse+ssl"});
        this.strategyMap.put("java:ws", new WebSocketStrategy("ws", this.nativeHandler, this.WEBSOCKET_NATIVE_CHANNEL_FACTORY));
        this.strategyMap.put("java:wss", new WebSocketStrategy("wss", this.nativeHandler, this.WEBSOCKET_NATIVE_CHANNEL_FACTORY));
        this.strategyMap.put("java:wse", new WebSocketStrategy("ws", this.emulatedHandler, this.WEBSOCKET_EMULATED_CHANNEL_FACTORY));
        this.strategyMap.put("java:wse+ssl", new WebSocketStrategy("wss", this.emulatedHandler, this.WEBSOCKET_EMULATED_CHANNEL_FACTORY));
    }

    @Override
    public void processConnect(WebSocketChannel channel, WSURI location, String protocol) {
        LOG.entering(CLASS_NAME, "connect", channel);
        WebSocketCompositeChannel compositeChannel = (WebSocketCompositeChannel)channel;
        LOG.finest("Current ready state = " + (Object)((Object)compositeChannel.readyState));
        if (compositeChannel.readyState == WebSocket.ReadyState.OPEN) {
            LOG.warning("Attempt to reconnect an existing open WebSocket to a different location");
            throw new IllegalStateException("Attempt to reconnect an existing open WebSocket to a different location");
        }
        String scheme = compositeChannel.getCompositeScheme();
        if (scheme.indexOf(":") >= 0) {
            WebSocketStrategy strategy = this.strategyMap.get(scheme);
            if (strategy == null) {
                throw new IllegalArgumentException("Invalid connection scheme: " + scheme);
            }
            LOG.finest("Turning off fallback since the URL is prefixed with java:");
            compositeChannel.connectionStrategies.add(scheme);
        } else {
            String[] connectionStrategies = this.strategyChoices.get(scheme);
            if (connectionStrategies != null) {
                for (String each : connectionStrategies) {
                    compositeChannel.connectionStrategies.add(each);
                }
            } else {
                throw new IllegalArgumentException("Invalid connection scheme: " + scheme);
            }
        }
        this.fallbackNext(compositeChannel);
    }

    private void fallbackNext(WebSocketCompositeChannel channel) {
        LOG.entering(CLASS_NAME, "fallbackNext");
        try {
            String strategyName = channel.getNextStrategy();
            if (strategyName == null) {
                this.doClose(channel);
            } else {
                this.initDelegate(channel, strategyName);
            }
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void initDelegate(WebSocketCompositeChannel channel, String strategyName) {
        WebSocketSelectedChannel selectedChannel;
        WebSocketStrategy strategy = this.strategyMap.get(strategyName);
        WebSocketSelectedChannelFactory channelFactory = strategy.channelFactory;
        WSURI location = channel.getLocation();
        String protocol = channel.getProtocol();
        boolean isBinary = channel.isBinary();
        channel.selectedChannel = selectedChannel = channelFactory.createChannel(location, protocol, isBinary);
        selectedChannel.setParent(channel);
        selectedChannel.handler = (WebSocketSelectedHandler)strategy.handler;
        selectedChannel.handler.processConnect(channel.selectedChannel, location, protocol);
    }

    @Override
    public synchronized void processTextMessage(WebSocketChannel channel, String message) {
        LOG.entering(CLASS_NAME, "send", message);
        WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel;
        if (parent.readyState != WebSocket.ReadyState.OPEN) {
            LOG.warning("Attempt to post message on unopened or closed web socket");
            throw new IllegalStateException("Attempt to post message on unopened or closed web socket");
        }
        WebSocketSelectedChannel selectedChannel = parent.selectedChannel;
        selectedChannel.handler.processTextMessage(selectedChannel, message);
    }

    @Override
    public synchronized void processBinaryMessage(WebSocketChannel channel, ByteBuffer message) {
        LOG.entering(CLASS_NAME, "send", message);
        WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel;
        if (parent.readyState != WebSocket.ReadyState.OPEN) {
            LOG.warning("Attempt to post message on unopened or closed web socket");
            throw new IllegalStateException("Attempt to post message on unopened or closed web socket");
        }
        WebSocketSelectedChannel selectedChannel = parent.selectedChannel;
        selectedChannel.handler.processBinaryMessage(selectedChannel, message);
    }

    @Override
    public void processAuthorize(WebSocketChannel channel, String authorizeToken) {
    }

    @Override
    public synchronized void processClose(WebSocketChannel channel) {
        LOG.entering(CLASS_NAME, "close");
        WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel;
        if (parent.readyState == WebSocket.ReadyState.CLOSED) {
            LOG.warning("WebSocket already closed");
            throw new IllegalStateException("WebSocket already closed");
        }
        if (!parent.closing) {
            parent.closing = true;
            try {
                WebSocketSelectedChannel selectedChannel = parent.selectedChannel;
                selectedChannel.handler.processClose(selectedChannel);
            }
            catch (Exception e) {
                this.doClose(parent);
            }
        }
    }

    private WebSocketHandlerListener createListener() {
        return new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                WebSocketCompositeHandler.this.doOpen(parent);
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer buf) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                WebSocketCompositeHandler.this.listener.messageReceived(parent, buf);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                if (parent.readyState == WebSocket.ReadyState.CONNECTING && !channel.authenticationReceived) {
                    WebSocketCompositeHandler.this.fallbackNext(parent);
                } else {
                    WebSocketCompositeHandler.this.doClose(parent);
                }
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
                WebSocketCompositeChannel parent = (WebSocketCompositeChannel)channel.getParent();
                if (parent.readyState == WebSocket.ReadyState.CONNECTING && !channel.authenticationReceived) {
                    WebSocketCompositeHandler.this.fallbackNext(parent);
                } else {
                    WebSocketCompositeHandler.this.doClose(parent);
                }
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }
        };
    }

    private void doOpen(WebSocketCompositeChannel channel) {
        if (channel.readyState == WebSocket.ReadyState.CONNECTING) {
            channel.readyState = WebSocket.ReadyState.OPEN;
            this.listener.connectionOpened(channel, channel.getProtocol());
        }
    }

    private void doClose(WebSocketCompositeChannel channel) {
        if (channel.readyState == WebSocket.ReadyState.CONNECTING || channel.readyState == WebSocket.ReadyState.OPEN) {
            channel.readyState = WebSocket.ReadyState.CLOSED;
            this.listener.connectionClosed(channel);
        }
    }

    @Override
    public void setListener(WebSocketHandlerListener listener) {
        this.listener = listener;
    }

    static class WebSocketStrategy {
        String nativeEquivalent;
        WebSocketHandler handler;
        WebSocketSelectedChannelFactory channelFactory;

        WebSocketStrategy(String nativeEquivalent, WebSocketHandler handler, WebSocketSelectedChannelFactory channelFactory) {
            this.nativeEquivalent = nativeEquivalent;
            this.handler = handler;
            this.channelFactory = channelFactory;
        }
    }

    static interface WebSocketSelectedChannelFactory {
        public WebSocketSelectedChannel createChannel(WSURI var1, String var2, boolean var3);
    }
}

