/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.ByteSocketEvent;
import com.kaazing.gateway.client.html5.ByteSocketListener;
import com.kaazing.gateway.client.html5.WebSocket;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerListener;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketCompositeChannel;
import com.kaazing.gateway.client.html5.impl.ws.WebSocketCompositeHandler;
import com.kaazing.gateway.client.html5.util.WSCompositeURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteSocket {
    private static final String CLASS_NAME = ByteSocket.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static WebSocketCompositeHandler handler;
    private WebSocketCompositeChannel channel;
    private final List<ByteSocketListener> eventListeners = new ArrayList<ByteSocketListener>();
    private static final Map<WebSocket.ReadyState, ReadyState> stateMap;
    private static final WebSocketHandlerListener handlerListener;

    public ByteSocket() throws Exception {
        LOG.entering(CLASS_NAME, "<init>");
        if (handler == null) {
            handler = new WebSocketCompositeHandler();
            handler.setListener(handlerListener);
        }
    }

    public ReadyState getReadyState() {
        if (this.channel == null) {
            return ReadyState.CONNECTING;
        }
        WebSocket.ReadyState wsReadyState = this.channel.getReadyState();
        return stateMap.get((Object)wsReadyState);
    }

    public synchronized void connect(URI location, String protocol) throws Exception {
        WSCompositeURI uri = new WSCompositeURI(location);
        this.channel = new WebSocketCompositeChannel(uri, protocol, true);
        this.channel.webSocket = this;
        handler.processConnect(this.channel, uri.getWSEquivalent(), protocol);
    }

    public synchronized void connect(URI location) throws Exception {
        LOG.entering(CLASS_NAME, "connect", location);
        this.connect(location, null);
    }

    public synchronized boolean send(ByteBuffer buf) {
        LOG.entering(CLASS_NAME, "send", buf);
        handler.processBinaryMessage(this.channel, buf);
        return true;
    }

    public synchronized void close() throws Exception {
        handler.processClose(this.channel);
    }

    public int getBufferedAmount() {
        return this.channel.getBufferedAmount();
    }

    public URI getURL() {
        return this.channel.getURL();
    }

    public void addByteSocketListener(ByteSocketListener listener) {
        LOG.entering(CLASS_NAME, "addByteSocketListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners.add(listener);
    }

    public void removeByteSocketListener(ByteSocketListener listener) {
        LOG.entering(CLASS_NAME, "removeByteSocketListener", listener);
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.eventListeners.remove(listener);
    }

    static {
        stateMap = new HashMap<WebSocket.ReadyState, ReadyState>();
        stateMap.put(WebSocket.ReadyState.CONNECTING, ReadyState.CONNECTING);
        stateMap.put(WebSocket.ReadyState.OPEN, ReadyState.OPEN);
        stateMap.put(WebSocket.ReadyState.CLOSED, ReadyState.CLOSED);
        handlerListener = new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                LOG.entering(CLASS_NAME, "onOpen");
                ByteSocket ws = ((WebSocketCompositeChannel)channel).getByteSocket();
                ByteSocketEvent event = new ByteSocketEvent(ws, ByteSocketEvent.Type.OPEN, null);
                for (ByteSocketListener eventListener : ws.eventListeners) {
                    try {
                        eventListener.onOpen(event);
                    }
                    catch (RuntimeException e) {
                        LOG.logp(Level.WARNING, CLASS_NAME, "onOpen", "Application threw an exception during onOpen: " + e.getMessage(), e);
                    }
                }
            }

            @Override
            public void messageReceived(WebSocketChannel channel, ByteBuffer data) {
                LOG.entering(CLASS_NAME, "onMessage");
                ByteSocket ws = ((WebSocketCompositeChannel)channel).getByteSocket();
                ByteSocketEvent event = new ByteSocketEvent(ws, ByteSocketEvent.Type.MESSAGE, data);
                for (ByteSocketListener eventListener : ws.eventListeners) {
                    try {
                        eventListener.onMessage(event);
                    }
                    catch (RuntimeException e) {
                        LOG.logp(Level.WARNING, CLASS_NAME, "onOpen", "Application threw an exception during onMessage: " + e.getMessage(), e);
                    }
                }
            }

            @Override
            public void connectionClosed(WebSocketChannel channel) {
                LOG.entering(CLASS_NAME, "onClose");
                ByteSocket ws = ((WebSocketCompositeChannel)channel).getByteSocket();
                ByteSocketEvent event = new ByteSocketEvent(ws, ByteSocketEvent.Type.CLOSE, null);
                for (ByteSocketListener eventListener : ws.eventListeners) {
                    try {
                        eventListener.onClose(event);
                    }
                    catch (RuntimeException e) {
                        LOG.logp(Level.WARNING, CLASS_NAME, "onOpen", "Application threw an exception during onClose: " + e.getMessage(), e);
                    }
                }
            }

            @Override
            public void connectionFailed(WebSocketChannel channel) {
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
            }
        };
    }

    public static enum ReadyState {
        CONNECTING,
        OPEN,
        CLOSED;

    }
}

