/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext.websocket.kaazing;

import com.bmc.arsys.arrpc.rpcext.ArOncRpcSocketClient;
import com.bmc.arsys.arrpc.rpcext.NetworkSocket;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.Latch;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.LatchImpl;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.WebSocketConnectionManager;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.WebSocketInputStream;
import com.bmc.arsys.arrpc.rpcext.websocket.kaazing.WebSocketOutputStream;
import com.kaazing.gateway.client.html5.ByteSocket;
import com.kaazing.gateway.client.html5.ByteSocketEvent;
import com.kaazing.gateway.client.html5.ByteSocketListener;
import com.kaazing.gateway.client.security.BasicChallengeHandler;
import com.kaazing.gateway.client.security.ChallengeHandler;
import com.kaazing.gateway.client.security.ChallengeHandlers;
import com.kaazing.gateway.client.security.DispatchChallengeHandler;
import com.kaazing.gateway.client.security.LoginHandler;
import com.kaazing.gateway.client.security.impl.DefaultBasicChallengeHandler;
import com.kaazing.gateway.client.security.impl.DefaultDispatchChallengeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class NetworkWebSocketImpl
implements NetworkSocket,
ByteSocketListener {
    private static Logger logger = Logger.getLogger(NetworkWebSocketImpl.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 120000;
    private final String url;
    private final String login;
    private final String password;
    private ByteSocket socket;
    private WebSocketInputStream inputStream;
    private WebSocketOutputStream outputStream;
    private int sendBufferSize = 0;
    private int receiveBufferSize = 0;
    private volatile int timeout = 0;
    private volatile boolean loginFailed = false;
    private int loginCount = 0;
    private int connectionTimeout;
    private volatile ByteSocket.ReadyState state = ByteSocket.ReadyState.CONNECTING;
    private Latch connectLatch = new LatchImpl();
    int id;
    private static AtomicInteger NEXT_ID_FACTORY = new AtomicInteger(0);
    public static AtomicInteger COUNT = new AtomicInteger(0);
    static AtomicInteger ON_MESSAGE_COUNT = new AtomicInteger(0);

    public NetworkWebSocketImpl(InetAddress address, int port, int connectionTimeout, String url, String login, String password) {
        this.connectionTimeout = connectionTimeout <= 0 ? 120000 : connectionTimeout;
        this.url = url;
        this.login = login;
        this.password = password;
        this.id = NEXT_ID_FACTORY.incrementAndGet();
    }

    void log(String m, Exception e) {
        if (logger.isDebugEnabled()) {
            ArOncRpcSocketClient.logNetworkMsg(m, this.id, e);
        }
    }

    void log(byte[] in, int start, int len, String msg) {
        if (logger.isDebugEnabled()) {
            ArOncRpcSocketClient.logNetworkBytes(in, start, len, msg, this.id);
        }
    }

    public void connect() throws IOException {
        this.log("WebSocketImpl.connect() called", null);
        WebSocketConnectionManager.getInstance().produce(this);
        while (!this.state.equals((Object)ByteSocket.ReadyState.OPEN)) {
        }
    }

    void blockedConnect() throws IOException {
        this.log("consume the WebSocketImpl.blockedConnect()", null);
        this.state = ByteSocket.ReadyState.CONNECTING;
        this.loginFailed = false;
        BasicChallengeHandler challengeHandler = null;
        try {
            if (this.login != null && this.password != null) {
                challengeHandler = this.initChallengeHandling();
            }
            if (this.socket != null) {
                this.close();
            }
            try {
                this.socket = new ByteSocket();
                this.socket.addByteSocketListener((ByteSocketListener)this);
                this.inputStream = new WebSocketInputStream(this, this.socket);
                this.outputStream = new WebSocketOutputStream(this, this.socket);
                this.inputStream.setTimeout(this.timeout);
                this.loginCount = 0;
                this.log("connecting tunnel " + this.url + ". Calling socket.connect().", null);
                this.socket.connect(new URI(this.url));
                try {
                    this.log("Waiting for connect latch.", null);
                    this.connectLatch.await(this.connectionTimeout);
                    if (this.loginFailed) {
                        logger.error((Object)"WebSocket gateway Authentication failed");
                        this.log("WebSocket gateway Authentication failed", null);
                        throw new Exception("Authentication failed");
                    }
                    if (this.state.equals((Object)ByteSocket.ReadyState.CONNECTING) || this.state.equals((Object)ByteSocket.ReadyState.CLOSED)) {
                        String curState = "Cannot connect: network socket state is " + (this.state.equals((Object)ByteSocket.ReadyState.CLOSED) ? "CLOSED" : "CONNECTING");
                        logger.error((Object)curState);
                        this.log(curState, null);
                        throw new Exception(curState);
                    }
                    this.log("Received connect latch.", null);
                    COUNT.incrementAndGet();
                }
                catch (InterruptedException e) {
                    this.log("throw new Interrupted exception " + e.getMessage(), null);
                    logger.error((Object)("throw new Interrupted exception " + e.getMessage()), (Throwable)e);
                    throw new Exception("Interrupted");
                }
            }
            catch (Exception e) {
                this.log("WebSocket connect got exception " + e.getMessage(), null);
                logger.error((Object)("WebSocket connect got exception " + e.getMessage()), (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            this.log("Will call close(): WebSocket connect got exception " + e.getMessage(), null);
            logger.error((Object)("Will call close(): WebSocket connect got exception " + e.getMessage()), (Throwable)e);
            this.close();
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            ChallengeHandler ch;
            if (challengeHandler != null && (ch = ChallengeHandlers.getDefault()) instanceof DispatchChallengeHandler) {
                ((DispatchChallengeHandler)ch).unregister(this.url, (ChallengeHandler)challengeHandler);
            }
        }
    }

    private BasicChallengeHandler initChallengeHandling() {
        LoginHandler loginHandler = new LoginHandler(){

            public PasswordAuthentication getCredentials() {
                NetworkWebSocketImpl.this.loginCount++;
                if (NetworkWebSocketImpl.this.loginCount > 1) {
                    NetworkWebSocketImpl.this.loginFailed = true;
                    return new PasswordAuthentication(NetworkWebSocketImpl.this.login, NetworkWebSocketImpl.this.password.toCharArray());
                }
                return new PasswordAuthentication(NetworkWebSocketImpl.this.login, NetworkWebSocketImpl.this.password.toCharArray());
            }
        };
        DefaultBasicChallengeHandler challengeHandler = new DefaultBasicChallengeHandler();
        challengeHandler.setLoginHandler(loginHandler);
        ChallengeHandler ch = ChallengeHandlers.getDefault();
        if (ch instanceof DispatchChallengeHandler) {
            ((DispatchChallengeHandler)ch).register(this.url, (ChallengeHandler)challengeHandler);
        } else {
            ChallengeHandlers.setDefault((ChallengeHandler)new DefaultDispatchChallengeHandler().register(this.url, (ChallengeHandler)challengeHandler));
        }
        return challengeHandler;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) throws SocketException {
    }

    public void setSendBufferSize(int sendBufferSize) throws SocketException {
        this.sendBufferSize = sendBufferSize;
    }

    public int getSendBufferSize() throws SocketException {
        return this.sendBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) throws SocketException {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.receiveBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.outputStream = null;
            }
        }
        if (this.socket != null && ByteSocket.ReadyState.CLOSED != this.socket.getReadyState()) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
        if (this.inputStream != null) {
            this.inputStream.setTimeout(timeout);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void onClose(ByteSocketEvent event) {
        this.log("onClose tunnel " + this.url, null);
        this.state = ByteSocket.ReadyState.CLOSED;
        this.connectLatch.unlatch();
    }

    public void onMessage(ByteSocketEvent event) {
    }

    public void onOpen(ByteSocketEvent event) {
        this.log("onOpen tunnel " + this.url, null);
        this.state = ByteSocket.ReadyState.OPEN;
        this.connectLatch.unlatch();
    }

    public Object getSocket() {
        return this.socket;
    }

    public void setSocket(Object newSocket) {
        this.socket = (ByteSocket)newSocket;
    }
}

