/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArClientRequestHandler;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import com.bmc.arsys.arrpc.nio.ArSelectorThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.acplt.oncrpc.ArRpcBindHelper;
import org.acplt.oncrpc.ArRpcThreadLocalStorageBlock;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.apache.log4j.Logger;

public abstract class ArTcpServerTransportBase {
    private static Logger LOGGER = Logger.getLogger(ArTcpServerTransportBase.class);
    private final ServerSocketChannel serverSocket = ServerSocketChannel.open();
    private final Selector acceptSelector;
    private int nextSelector = 0;
    protected ArClientConnectionAcceptor acceptor;
    private boolean isRegPortMapper;
    private OncRpcDispatchable callDispatcher;
    private int socketBufferSize;
    private OncRpcServerTransportRegistrationInfo[] registrationInfo;
    private int port;
    ArSelectorThread[] callSelectors;
    protected int transmissionTimeout = 90000;
    protected int rpcBindFastTimeout = 120;
    private String characterEncoding;

    public ArTcpServerTransportBase(InetAddress hostId, int port) throws IOException {
        boolean tcpBind = ArRpcThreadLocalStorageBlock.getTLB().isTcpBind();
        if (tcpBind) {
            this.serverSocket.socket().bind(new InetSocketAddress(hostId, port));
        } else {
            this.serverSocket.socket().bind(new InetSocketAddress(port));
        }
        this.serverSocket.configureBlocking(false);
        this.acceptSelector = Selector.open();
        SelectionKey sk = this.serverSocket.register(this.acceptSelector, 16);
        this.acceptor = this.createAcceptor();
        sk.attach(this.acceptor);
        this.initCallSelector();
    }

    protected ArClientConnectionAcceptor createAcceptor() {
        return new ArClientConnectionAcceptor();
    }

    protected abstract void initCallSelector() throws IOException;

    public ArTcpServerTransportBase(OncRpcDispatchable dispatcher, InetAddress bindAddr, int port, OncRpcServerTransportRegistrationInfo[] info, int bufferSize, boolean regPM) throws OncRpcException, IOException {
        this(bindAddr, port);
        String portStr = "";
        if (port == 0) {
            this.port = this.serverSocket.socket().getLocalPort();
            portStr = " on localPort " + this.port;
        } else {
            this.port = port;
            portStr = " on assigned port " + String.valueOf(port);
        }
        if (ArRpcBindHelper.rpcbind_client_debug.booleanValue()) {
            System.out.println("ServerSocketChannel opened TCP for " + bindAddr + portStr);
        }
        LOGGER.debug((Object)("ServerSocketChannel opened TCP for " + bindAddr + portStr));
        this.callDispatcher = dispatcher;
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        this.socketBufferSize = bufferSize;
        this.registrationInfo = info;
        this.isRegPortMapper = regPM;
    }

    public void register() throws OncRpcException {
        if (this.isRegPortMapper) {
            try {
                OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getLocalHost(), 6, this.rpcBindFastTimeout);
                int size = this.registrationInfo.length;
                for (int idx = 0; idx < size; ++idx) {
                    portmapper.setPort(this.registrationInfo[idx].program, this.registrationInfo[idx].version, 6, this.port);
                }
            }
            catch (Throwable e) {
                throw new OncRpcException(16);
            }
        }
    }

    public void registerByName(String hostName, boolean isRegPortMapper) throws OncRpcException {
        if (isRegPortMapper) {
            try {
                OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName(hostName), 6, this.rpcBindFastTimeout);
                int minRegVer = ArRpcBindHelper.getPluginSvrMinVersionToRegisger((InetAddress)InetAddress.getByName(hostName));
                int size = this.registrationInfo.length;
                for (int idx = 0; idx < size; ++idx) {
                    if (this.registrationInfo[idx].version < minRegVer) continue;
                    portmapper.setPort(this.registrationInfo[idx].program, this.registrationInfo[idx].version, 6, this.port);
                }
            }
            catch (Throwable e) {
                throw new OncRpcException(16);
            }
        }
    }

    public void unregister() throws OncRpcException {
        if (this.isRegPortMapper) {
            try {
                OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getLocalHost(), 6, this.rpcBindFastTimeout);
                int size = this.registrationInfo.length;
                for (int idx = 0; idx < size; ++idx) {
                    portmapper.unsetPort(this.registrationInfo[idx].program, this.registrationInfo[idx].version);
                }
            }
            catch (Throwable e) {
                throw new OncRpcException(16);
            }
        }
    }

    public void unregisterByName(String hostName) throws OncRpcException {
        if (this.isRegPortMapper) {
            try {
                OncRpcPortmapClient portmapper = new OncRpcPortmapClient(InetAddress.getByName(hostName), 6, this.rpcBindFastTimeout);
                int minRegVer = ArRpcBindHelper.getPluginSvrMinVersionToRegisger((InetAddress)InetAddress.getByName(hostName));
                int size = this.registrationInfo.length;
                for (int idx = 0; idx < size; ++idx) {
                    if (this.registrationInfo[idx].version < minRegVer) continue;
                    portmapper.unsetPort(this.registrationInfo[idx].program, this.registrationInfo[idx].version);
                }
            }
            catch (Throwable e) {
                throw new OncRpcException(16);
            }
        }
    }

    public void setTransmissionTimeout(int milliseconds) {
        if (milliseconds <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = milliseconds;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            LOGGER.debug((Object)("Starting Reactor thread thats listening for client connections " + Thread.currentThread().getId()));
            Selector selector = this.acceptSelector;
            while (!Thread.interrupted()) {
                Set<SelectionKey> selected;
                selector.select();
                LOGGER.trace((Object)"******************************selector selected");
                Set<SelectionKey> set = selected = selector.selectedKeys();
                synchronized (set) {
                    Iterator<SelectionKey> it = selected.iterator();
                    ArrayList<Object> keyHandlers = new ArrayList<Object>();
                    while (it.hasNext()) {
                        SelectionKey key = it.next();
                        LOGGER.trace((Object)("******************************Selector " + key.selector().hashCode() + " SelectionKey " + key.hashCode()));
                        if (!key.isValid() || !key.isAcceptable() || keyHandlers.contains(key.attachment())) continue;
                        keyHandlers.add(key.attachment());
                        LOGGER.trace((Object)("******************************Selector " + key.selector().hashCode() + " SelectionKey " + key.hashCode() + " contains a package"));
                        this.dispatch(key);
                    }
                    keyHandlers.clear();
                    selected.clear();
                }
            }
            return;
        }
        catch (Throwable e) {
            LOGGER.error((Object)"Exception in reactor thread.", e);
            return;
        }
        finally {
            this.cleanUp();
        }
    }

    private void dispatch(SelectionKey key) {
        ArClientRequestHandler r = (ArClientRequestHandler)key.attachment();
        LOGGER.debug((Object)("dispatch SelectionKey " + key.hashCode() + " to attached connection acceptor: " + (r == null ? null : Integer.valueOf(r.hashCode()))));
        if (r != null) {
            r.handleRequest(key);
        }
    }

    public void cleanUp() {
        if (this.serverSocket != null) {
            try {
                this.acceptSelector.close();
                this.acceptor.close();
                this.serverSocket.socket().close();
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() throws Throwable {
        this.cleanUp();
        super.finalize();
    }

    protected ArSelectorThread[] getCallSelectors() {
        return this.callSelectors;
    }

    protected void setCallSelectors(ArSelectorThread[] callSelectors) {
        this.callSelectors = callSelectors;
    }

    protected void setCallSelector(int i, ArSelectorThread callSelector) {
        if (this.callSelectors != null) {
            this.callSelectors[i] = callSelector;
        }
    }

    protected OncRpcDispatchable getCallDispatcher() {
        return this.callDispatcher;
    }

    protected int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void unregister(String hostName) {
    }

    public boolean isRegPortMapper() {
        return this.isRegPortMapper;
    }

    protected class ArClientConnectionAcceptor
    implements ArClientRequestHandler {
        protected ArClientConnectionAcceptor() {
        }

        synchronized ArSelectorThread getNextSelector() {
            if (ArTcpServerTransportBase.this.nextSelector == ArTcpServerTransportBase.this.callSelectors.length) {
                ArTcpServerTransportBase.this.nextSelector = 0;
            }
            ArSelectorThread ret = ArTcpServerTransportBase.this.callSelectors[ArTcpServerTransportBase.this.nextSelector++];
            return ret;
        }

        @Override
        public void handleRequest(SelectionKey key) {
            SocketChannel channel = null;
            try {
                if (key.isValid() && key.isAcceptable() && (channel = ArTcpServerTransportBase.this.serverSocket.accept()) != null) {
                    LOGGER.debug((Object)"Client connection accepted. Registering handler");
                    ArSelectorThread selectionThread = this.getNextSelector();
                    ArRpcCallHandler handler = this.createHandler(selectionThread, channel);
                    selectionThread.addHandler(handler);
                }
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Error accepting a connection or registering the handler for a connection", e);
                key.cancel();
                try {
                    key.channel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public ArRpcCallHandler createHandler(ArSelectorThread selectionThread, SocketChannel channel) throws IOException {
            throw new IOException("Method need to be overridden");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            int i = 0;
            ArSelectorThread[] arSelectorThreadArray = ArTcpServerTransportBase.this.callSelectors;
            synchronized (ArTcpServerTransportBase.this.callSelectors) {
                while (i < ArTcpServerTransportBase.this.callSelectors.length) {
                    ArTcpServerTransportBase.this.callSelectors[i++].close();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

