/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.apps.jrpcgen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenConst;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenDeclaration;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenEnDecodingInfo;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenStruct;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnion;
import org.acplt.oncrpc.apps.jrpcgen.JrpcgenUnionArm;
import org.acplt.oncrpc.apps.jrpcgen.jrpcgen;

public class ARJrpcgenHelper {
    static boolean arrpcBaseInterfaceChanges = false;
    static boolean arPasswordChanges = false;
    static boolean arAddNoVersionProcedureNumber = false;
    static boolean arServerChanges = false;
    static boolean arNoUDP = false;
    static boolean arInitMembers = false;
    static boolean arAddNonDefaultConstructor = false;
    private static int passwordChangeMinVersion = 12;
    private static List<String> arVersionIndependentConstantList = new ArrayList<String>();
    private static String arParamInExclusiveFileName = null;
    private static List<String> arParamInExclusiveList = new ArrayList<String>();
    private static String arParamOutExclusiveFileName = null;
    private static List<String> arParamOutExclusiveList = new ArrayList<String>();
    private static String arStatusListExclusiveFileName = null;
    private static List<String> arStatusListExclusiveList = new ArrayList<String>();
    private static List<String> arStatusListInclusivePrefixList = null;
    private static String arStatusStructExclusiveFileName = null;
    private static List<String> arStatusStructExclusiveList = new ArrayList<String>();
    private static List<String> arStatusStructInclusivePrefixList = null;
    private static String arControlStructExclusiveFileName = null;
    private static List<String> arControlStructDefaultInclusivePrefixList = null;
    private static List<String> arControlStructExclusiveList = new ArrayList<String>();
    private static String arRpcPasswordChangeInclusiveFileName = null;
    private static List<String> arRpcPasswordChangeInclusiveList = new ArrayList<String>();
    private static boolean arEsControlStructChange = false;
    private static int arEsControlStructChangeMinVersion = 4;
    private static List<String> arEsControlStructDefaultInclusivePrefixList = null;
    private static String arEsClassForArEsControlStructChangeExclusiveFileName = null;
    private static List<String> arEsClassForArEsControlStructChangeExclusiveList = new ArrayList<String>();
    private static boolean arNameTypeChange = false;
    private static boolean arImportArrpcPackageChange = false;

    static void addNoVersionProcedureNumber(PrintWriter out, JrpcgenConst jrpcgenConst) {
        String iden;
        int idx = jrpcgenConst.identifier.indexOf("_");
        int lastIdx = jrpcgenConst.identifier.lastIndexOf("_");
        if (idx > 0 && idx == lastIdx && !arVersionIndependentConstantList.contains(iden = jrpcgenConst.identifier.substring(0, idx))) {
            arVersionIndependentConstantList.add(iden);
            out.println("    public static final int " + iden + " = " + jrpcgenConst.value + ";");
        }
    }

    private static boolean checkIdentifierStartWith(String identifier, List<String> list) {
        boolean flag = false;
        for (String id : list) {
            if (!identifier.startsWith(id)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    static void addArParamInOutBaseClassAndImport(PrintWriter out, JrpcgenStruct s) {
        if (ARJrpcgenHelper.checkClassImportForArRpcNameTypeChange(s, "ArNameType15", "ArRpcNameType15")) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcNameType15;");
        }
        if (ARJrpcgenHelper.checkClassImportForArRpcNameTypeChange(s, "ArAccessNameType15", "ArRpcAccessNameType15")) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcAccessNameType15;");
        }
        if (ARJrpcgenHelper.checkIdentifierStartWith(s.identifier, arControlStructDefaultInclusivePrefixList) || ARJrpcgenHelper.checkIdentifierInPasswordChangeList(s.identifier, false)) {
            if (ARJrpcgenHelper.checkIdentifierStartWith(s.identifier, arControlStructDefaultInclusivePrefixList)) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcControlStruct;");
            } else if (s.identifier.endsWith("In")) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;");
            }
            if (ARJrpcgenHelper.checkClassForPasswordChange(s.identifier)) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcPassword;");
            }
            out.println("");
            if (ARJrpcgenHelper.checkIdentifierStartWith(s.identifier, arControlStructDefaultInclusivePrefixList)) {
                out.print("public class " + s.identifier + " extends ArRpcControlStruct implements XdrAble");
            } else if (ARJrpcgenHelper.checkIdentifierInPasswordChangeList(s.identifier, false) && s.identifier.endsWith("In")) {
                out.print("public class " + s.identifier + " extends ArRpcXdrIn implements XdrAble");
            } else {
                out.print("public class " + s.identifier + " implements XdrAble");
            }
        } else if (arPasswordChanges && ARJrpcgenHelper.checkIdentifierInPasswordChangeList(s.identifier, false)) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcPassword;");
            out.println("");
            out.print("public class " + s.identifier + " extends ArRpcXdrIn implements XdrAble");
        } else if (s.identifier.startsWith("ArEs") && (s.identifier.endsWith("In") || s.identifier.endsWith("Out"))) {
            if (ARJrpcgenHelper.checkArEsClassForArEsControlStructChange(s)) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArEsRpcControlStruct;");
            }
            if (s.identifier.endsWith("In")) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;");
                out.println("");
                out.print("public class " + s.identifier + " extends ArRpcXdrIn implements XdrAble");
            } else if (s.identifier.endsWith("Out")) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;");
                out.println("");
                out.print("public class " + s.identifier + " extends ArRpcXdrOut implements XdrAble");
            }
        } else if ((s.identifier.startsWith("Ar") || s.identifier.startsWith("Cmdb")) && s.identifier.endsWith("Out") && !arParamOutExclusiveList.contains(s.identifier)) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;");
            out.println("");
            out.print("public class " + s.identifier + " extends ArRpcXdrOut implements XdrAble");
        } else if ((s.identifier.startsWith("Ar") || s.identifier.startsWith("Cmdb")) && s.identifier.endsWith("In") && !arParamInExclusiveList.contains(s.identifier)) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcXdrIn;");
            out.println("");
            out.print("public class " + s.identifier + " extends ArRpcXdrIn implements XdrAble");
        } else if (ARJrpcgenHelper.checkIdentifierStartWith(s.identifier, arStatusStructInclusivePrefixList) && !arStatusStructExclusiveList.contains(s.identifier)) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcStatusStruct;");
            out.println("");
            out.print("public class " + s.identifier + " extends ArRpcStatusStruct implements XdrAble");
        } else {
            out.print("public class " + s.identifier + " implements XdrAble");
        }
    }

    static boolean checkClassForPasswordChange(String identifier) {
        boolean flag = false;
        if (ARJrpcgenHelper.checkIdentifierStartWith(identifier, arControlStructDefaultInclusivePrefixList) && !ARJrpcgenHelper.checkClassLowerThanGivenVersion(identifier, passwordChangeMinVersion) || ARJrpcgenHelper.checkIdentifierInPasswordChangeList(identifier, true)) {
            flag = true;
        }
        return flag;
    }

    private static boolean checkIdentifierInPasswordChangeList(String identifier, boolean checkMinVersion) {
        boolean flag = false;
        if ((identifier.endsWith("In") || identifier.contains("Struct")) && ARJrpcgenHelper.checkIdentifierStartWith(identifier, arRpcPasswordChangeInclusiveList) && (!checkMinVersion || checkMinVersion && !ARJrpcgenHelper.checkClassLowerThanGivenVersion(identifier, passwordChangeMinVersion))) {
            flag = true;
        }
        return flag;
    }

    private static boolean checkDeclarationInPasswordChangeList(JrpcgenDeclaration d) {
        boolean flag = false;
        if (d.type.toLowerCase().contains("password") || d.identifier.equals("password")) {
            flag = true;
        }
        return flag;
    }

    static boolean checkClassLowerThanGivenVersion(String identifier, int givenVersion) {
        boolean flag = false;
        if (identifier == null) {
            return flag;
        }
        String noVersionName = "";
        int r = -1;
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (!Character.isDigit(c)) continue;
            r = i;
            break;
        }
        if ((noVersionName = r > 0 && r < identifier.length() ? identifier.substring(0, r) : identifier).length() > identifier.length()) {
            String msg = "lowVersionCheck : noVersionName should be the leading non version structure name";
            throw new InvalidParameterException(msg);
        }
        int lastIdx = 0;
        lastIdx = identifier.endsWith("In") ? identifier.length() - 2 : (identifier.endsWith("Out") ? identifier.length() - 3 : identifier.length());
        if (noVersionName == null || lastIdx > noVersionName.length()) {
            String ver = identifier.substring(noVersionName.length(), lastIdx);
            if (ver == null || ver.length() == 0 || ver.length() > 0 && Integer.parseInt(ver) < givenVersion) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    static boolean addArPasswordClassImport(PrintWriter out, JrpcgenStruct s) {
        boolean flag = false;
        if (ARJrpcgenHelper.checkClassForPasswordChange(s.identifier)) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcPassword;");
            out.println("");
            flag = true;
        }
        return flag;
    }

    static boolean changeArPasswordGetter(PrintWriter out, String sIdentifier, JrpcgenDeclaration d, String jbName) {
        boolean flag = false;
        if (arPasswordChanges && ARJrpcgenHelper.checkClassForPasswordChange(sIdentifier) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(d)) {
            out.println("    public ArRpcPassword get" + jbName + "() { return this." + d.identifier + "; }");
            flag = true;
        }
        return flag;
    }

    static boolean changeArPasswordEncode(PrintWriter out, String sIdentifier, JrpcgenDeclaration decl) {
        boolean flag = false;
        if (arPasswordChanges && ARJrpcgenHelper.checkClassForPasswordChange(sIdentifier) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(decl)) {
            out.println("        " + decl.identifier + ".xdrEncode(xdr);");
            flag = true;
        }
        return flag;
    }

    static boolean changeArPasswordDecode(PrintWriter out, String sIdentifier, JrpcgenDeclaration decl) {
        boolean flag = false;
        if (arPasswordChanges && ARJrpcgenHelper.checkClassForPasswordChange(sIdentifier) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(decl)) {
            out.println("        " + decl.identifier + ".xdrDecode(xdr);");
            flag = true;
        }
        return flag;
    }

    static boolean changeArStatusListBaseClass(PrintWriter out, JrpcgenDeclaration d) {
        boolean flag = false;
        if (arrpcBaseInterfaceChanges && ARJrpcgenHelper.checkIdentifierStartWith(d.identifier, arStatusListInclusivePrefixList) && !arStatusListExclusiveList.contains(d.identifier)) {
            out.println("import com.bmc.arsys.arrpc.xdr.ArRpcStatusList;");
            out.println("");
            out.print("public class " + d.identifier + " extends ArRpcStatusList implements XdrAble");
            flag = true;
        }
        return flag;
    }

    static void addArServerClassImport(PrintWriter out) {
        out.println("import java.lang.reflect.*;");
        out.println("import com.bmc.arsys.pluginsvr.oncrpcext.*;");
        out.println("import com.bmc.arsys.pluginsvr.*;");
        out.println();
    }

    static boolean changeArPasswordInitialization(PrintWriter out, String sIdentifiler, JrpcgenDeclaration d) {
        boolean flag = false;
        if (arPasswordChanges && ARJrpcgenHelper.checkClassForPasswordChange(sIdentifiler) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(d)) {
            out.print("    public ArRpcPassword ");
            out.println(d.identifier + " = new ArRpcPassword();");
            flag = true;
        }
        return flag;
    }

    static boolean changeArPasswordSetter(PrintWriter out, String sIdentifier, JrpcgenDeclaration d, String jbName) {
        boolean flag = false;
        if (arPasswordChanges && ARJrpcgenHelper.checkClassForPasswordChange(sIdentifier) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(d)) {
            out.println("    public void set" + jbName + "(" + "ArRpcPassword x) { this." + d.identifier + " = x; }");
            flag = true;
        }
        return flag;
    }

    static void initMembers(PrintWriter out, JrpcgenDeclaration d) {
        boolean isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
        JrpcgenEnDecodingInfo data = jrpcgen.baseEnDecodingSyllable(d);
        boolean isIntrinsic = data != null;
        if (isArray) {
            if (d.kind == 1) {
                out.println("       this.value = new " + jrpcgen.checkForSpecials(d.type) + "[arrpc." + d.size + "];");
            } else {
                out.println("       this.value = new " + jrpcgen.checkForSpecials(d.type) + "[0];");
            }
        } else if (!isIntrinsic) {
            out.println("       this.value = new " + jrpcgen.checkForSpecials(d.type) + "();");
        }
    }

    static void generateGetterForUnion(PrintWriter out, JrpcgenUnion u) {
        String jbName = u.descriminant.identifier.substring(0, 1).toUpperCase() + u.descriminant.identifier.substring(1);
        out.println("    public " + u.descriminant.type + " get" + jbName + "() { return this." + u.descriminant.identifier + "; }");
        out.println();
        out.println("    public Object getElement() {");
        out.println("        switch ( " + u.descriminant.identifier + " ) {");
        Enumeration arms = u.elements.elements();
        boolean defaultPrinted = false;
        while (arms.hasMoreElements()) {
            JrpcgenUnionArm a = (JrpcgenUnionArm)arms.nextElement();
            if (a.value != null) {
                out.println("        case " + jrpcgen.checkForEnumValue(a.value) + ":");
            } else {
                out.println("        default:");
                defaultPrinted = true;
            }
            if (a.element == null) continue;
            if (a.element.identifier != null) {
                out.println("            return " + a.element.identifier + ";");
                continue;
            }
            out.println("            return null;");
        }
        if (!defaultPrinted) {
            out.println("        default:");
            out.println("            return null;");
        }
        out.println("        }");
        out.println("    }");
        out.println();
    }

    static void generateNonDefaultConstructor(PrintWriter out, JrpcgenUnion u) {
        out.println("    public " + u.identifier + "(" + u.descriminant.type + " " + u.descriminant.identifier + ", Object element) {");
        out.println("        this." + u.descriminant.identifier + " = " + u.descriminant.identifier + ";");
        out.println("        switch ( " + u.descriminant.identifier + " ) {");
        Enumeration arms = u.elements.elements();
        while (arms.hasMoreElements()) {
            JrpcgenUnionArm a = (JrpcgenUnionArm)arms.nextElement();
            if (a.value != null) {
                out.println("        case " + jrpcgen.checkForEnumValue(a.value) + ":");
            } else {
                out.println("        default:");
            }
            if (a.element == null) continue;
            if (a.element.identifier != null) {
                out.print("            " + a.element.identifier + " = ");
                String elemType = a.element.type;
                if (elemType.equals("int")) {
                    out.println("((Integer)element).intValue();");
                } else if (elemType.equals("double")) {
                    out.println("((Double)element).doubleValue();");
                } else {
                    out.println("(" + elemType + ")element;");
                }
            }
            out.println("            break;");
        }
        out.println("        }");
        out.println("    }");
        out.println();
    }

    static void generateGetterForTypeDef(PrintWriter out, String paramType) {
        out.println("    public " + jrpcgen.checkForSpecials(paramType) + " getValue" + "() { return this.value; }");
        out.println("");
    }

    static void initMembers(PrintWriter out, JrpcgenStruct s) {
        out.println("        /* Initialize members */");
        Enumeration decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            boolean isArray;
            JrpcgenDeclaration d = (JrpcgenDeclaration)decls.nextElement();
            String jbName = d.identifier.substring(0, 1).toUpperCase() + d.identifier.substring(1);
            JrpcgenEnDecodingInfo data = jrpcgen.baseEnDecodingSyllable(d);
            boolean isIntrinsic = data != null;
            boolean bl = isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
            if (ARJrpcgenHelper.checkClassForPasswordChange(s.identifier) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(d)) continue;
            if (isArray) {
                String arraySize = "0";
                if (isIntrinsic) {
                    if (data.encodingOptions != null) {
                        arraySize = data.encodingOptions;
                    }
                    out.println("        " + d.identifier + " = new " + jrpcgen.checkForSpecials(d.type) + "[" + arraySize + "];");
                    continue;
                }
                out.println("        " + d.identifier + " = new " + jrpcgen.checkForSpecials(d.type) + "[0];");
                continue;
            }
            if (isIntrinsic) continue;
            out.println("        set" + jbName + "(new " + jrpcgen.checkForSpecials(d.type) + "());");
        }
    }

    static void generateNonDefaultConstructor(PrintWriter out, JrpcgenStruct s) {
        boolean isArray;
        JrpcgenDeclaration d;
        out.print("    public " + s.identifier + "(");
        boolean isFirstElement = true;
        Enumeration decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            d = (JrpcgenDeclaration)decls.nextElement();
            if (isFirstElement) {
                isFirstElement = false;
            } else {
                out.print(", ");
            }
            if (ARJrpcgenHelper.checkClassForPasswordChange(s.identifier) && ARJrpcgenHelper.checkDeclarationInPasswordChangeList(d)) {
                out.print("ArRpcPassword");
            } else if (ARJrpcgenHelper.checkDeclarationInArEsControlStructChangeList(d) && ARJrpcgenHelper.checkClassForArEsControlStructChange(s.identifier)) {
                out.print("ArEsRpcControlStruct");
            } else if (ARJrpcgenHelper.checkSpecialArNameType(s.identifier, "ArNameType15")) {
                out.print("ArRpcNameType15");
            } else if (ARJrpcgenHelper.checkSpecialArNameType(s.identifier, "ArAccessNameType15")) {
                out.print("ArRpcAccessNameType15");
            } else {
                out.print(jrpcgen.checkForSpecials(d.type));
            }
            isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
            out.print((isArray ? "[] " : " ") + d.identifier);
        }
        out.println(") {");
        decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            d = (JrpcgenDeclaration)decls.nextElement();
            boolean bl = isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
            if (!ARJrpcgenHelper.checkDeclarationInPasswordChangeList(d) && !isArray) {
                if (d.type.equals("String")) {
                    out.println("        this." + d.identifier + " = " + "(" + d.identifier + " == null) ? \"\" : " + d.identifier + ";");
                    continue;
                }
                if (d.type.equals("int") || d.type.equals("long") || d.type.equals("short") || d.type.equals("char") || d.type.equals("float") || d.type.equals("double") || d.type.equals("boolean") || d.type.equals("byte")) {
                    out.println("        this." + d.identifier + " = " + d.identifier + ";");
                    continue;
                }
                out.println("        this." + d.identifier + " = " + "(" + d.identifier + " == null) ? new " + jrpcgen.checkForSpecials(d.type) + "(): " + d.identifier + ";");
                continue;
            }
            out.println("        this." + d.identifier + " = " + d.identifier + ";");
        }
        out.println("    }");
        out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fatchClassList(String filePathName, List<String> list) {
        String line = null;
        BufferedReader rdr = null;
        try {
            rdr = new BufferedReader(new FileReader(filePathName));
            while ((line = rdr.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                list.add(line.trim());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    static int arArgsParser(String arg, String[] args, int argIdx) {
        int argc = args.length;
        if (arg.equals("-arNoUDP")) {
            arNoUDP = true;
        } else if (arg.equals("-arServerChanges")) {
            arServerChanges = true;
        } else if (arg.equals("-arrpcBaseInterfaceChanges")) {
            arrpcBaseInterfaceChanges = true;
        } else if (arg.equals("-arPasswordChanges")) {
            arPasswordChanges = true;
        } else if (arg.equals("-arAddNoVersionProcedureNumber")) {
            arAddNoVersionProcedureNumber = true;
        } else if (arg.equals("-arInitMembers")) {
            arInitMembers = true;
            arAddNonDefaultConstructor = true;
        } else if (arg.equals("-arXdrInExcl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing ArRpcXdrInExclusiveFileName");
                System.exit(1);
            }
            arParamInExclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arParamInExclusiveFileName, arParamInExclusiveList);
        } else if (arg.equals("-arXdrOutExcl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing ArRpcXdrExclusiveFileName");
                System.exit(1);
            }
            arParamOutExclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arParamOutExclusiveFileName, arParamOutExclusiveList);
        } else if (arg.equals("-arControlStructExcl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing ArControlStructExclusiveFileName");
                System.exit(1);
            }
            arControlStructExclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arControlStructExclusiveFileName, arControlStructExclusiveList);
        } else if (arg.equals("-arStatusListExcl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing ArStatusListExclusiveFileName");
                System.exit(1);
            }
            arStatusListExclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arStatusListExclusiveFileName, arStatusListExclusiveList);
        } else if (arg.equals("-arStatusStructExcl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing ArStatusStructExclusiveFileName");
                System.exit(1);
            }
            arStatusStructExclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arStatusStructExclusiveFileName, arStatusStructExclusiveList);
        } else if (arg.equals("-arPasswordChangeIncl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing ArRpcPasswordChangeInclusiveFileName");
                System.exit(1);
            }
            arRpcPasswordChangeInclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arRpcPasswordChangeInclusiveFileName, arRpcPasswordChangeInclusiveList);
        } else if (arg.equals("-arEsControlStructChange")) {
            arEsControlStructChange = true;
        } else if (arg.equals("-arEsClassForArEsControlStructChangeExcl")) {
            if (++argIdx >= argc) {
                System.out.println("jrpcgen: missing arEsClassForArEsControlStructChangeExclusiveFileName");
                System.exit(1);
            }
            arEsClassForArEsControlStructChangeExclusiveFileName = args[argIdx];
            ARJrpcgenHelper.fatchClassList(arEsClassForArEsControlStructChangeExclusiveFileName, arEsClassForArEsControlStructChangeExclusiveList);
        } else if (arg.equals("-arNameTypeChange")) {
            arNameTypeChange = true;
        } else if (arg.equals("-arImportArrpcPkg")) {
            arImportArrpcPackageChange = true;
        }
        return argIdx;
    }

    static boolean checkClassForArEsControlStructChange(String identifier) {
        boolean flag = false;
        if (arEsControlStructChange && (ARJrpcgenHelper.checkIdentifierStartWith(identifier, arEsControlStructDefaultInclusivePrefixList) && !ARJrpcgenHelper.checkClassLowerThanGivenVersion(identifier, arEsControlStructChangeMinVersion) || ARJrpcgenHelper.checkIdentifierInEsControlStructChangeList(identifier, true))) {
            flag = true;
        }
        return flag;
    }

    static boolean changeArEsControlStructDecode(String sIdentifier, JrpcgenDeclaration decl) {
        boolean flag = false;
        if (arEsControlStructChange && ARJrpcgenHelper.checkClassForArEsControlStructChange(sIdentifier)) {
            flag = true;
        }
        return flag;
    }

    private static boolean checkIdentifierInEsControlStructChangeList(String identifier, boolean checkMinVersion) {
        boolean flag = false;
        if (arEsControlStructChange && identifier.contains("ArEsControlStruct") && ARJrpcgenHelper.checkIdentifierStartWith(identifier, arEsControlStructDefaultInclusivePrefixList) && ARJrpcgenHelper.checkIdentifierStartWith(identifier, arEsClassForArEsControlStructChangeExclusiveList) && (!checkMinVersion || checkMinVersion && !ARJrpcgenHelper.checkClassLowerThanGivenVersion(identifier, arEsControlStructChangeMinVersion))) {
            flag = true;
        }
        return flag;
    }

    private static boolean checkDeclarationInArEsControlStructChangeList(JrpcgenDeclaration d) {
        boolean flag = false;
        if (arEsControlStructChange && (d.type.toLowerCase().contains("control") || d.identifier.equals("control"))) {
            flag = true;
        }
        return flag;
    }

    static boolean changeArEsControlStructInitialization(PrintWriter out, String sIdentifiler, JrpcgenDeclaration d) {
        boolean flag = false;
        if (arEsControlStructChange && ARJrpcgenHelper.checkClassForArEsControlStructChange(sIdentifiler) && ARJrpcgenHelper.checkDeclarationInArEsControlStructChangeList(d)) {
            out.print("    public ArEsRpcControlStruct ");
            out.println(d.identifier + " = new ArEsRpcControlStruct();");
            flag = true;
        }
        return flag;
    }

    private static boolean checkArEsClassForArEsControlStructChange(JrpcgenStruct s) {
        return arEsControlStructChange && !ARJrpcgenHelper.checkClassLowerThanGivenVersion(s.identifier, arEsControlStructChangeMinVersion) && !ARJrpcgenHelper.checkIdentifierStartWith(s.identifier, arEsClassForArEsControlStructChangeExclusiveList);
    }

    private static boolean checkClassImportForArRpcNameTypeChange(JrpcgenStruct s, String orgClass, String newClass) {
        boolean flag = false;
        if (!arNameTypeChange) {
            return false;
        }
        Enumeration decls = s.elements.elements();
        while (decls.hasMoreElements()) {
            JrpcgenDeclaration d = (JrpcgenDeclaration)decls.nextElement();
            if (!ARJrpcgenHelper.checkChangeArNameTypeClassType(d, s, orgClass, newClass, false)) continue;
            flag = true;
        }
        return flag;
    }

    private static boolean checkSpecialArNameType(String identifier, String nameChecked) {
        boolean flag = false;
        if (arNameTypeChange && identifier.equals(nameChecked)) {
            flag = true;
        }
        return flag;
    }

    static boolean changeArNameTypeGetter(PrintWriter out, String sIdentifier, JrpcgenDeclaration d, String jbName) {
        boolean flag = false;
        if (arNameTypeChange && ARJrpcgenHelper.checkSpecialArNameType(sIdentifier, "ArNameType15")) {
            boolean isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
            out.println("    public ArRpcNameType15");
            out.print((isArray ? "[] " : " ") + d.identifier);
            out.println("get" + jbName + "() { return this." + d.identifier + "; }");
            flag = true;
        } else if (arNameTypeChange && ARJrpcgenHelper.checkSpecialArNameType(sIdentifier, "ArAccessNameType15")) {
            boolean isArray = (d.kind == 1 || d.kind == 2) && !d.type.equals("String");
            out.println("    public ArRpcAccessNameType15");
            out.print((isArray ? "[] " : " ") + d.identifier);
            out.println("get" + jbName + "() { return this." + d.identifier + "; }");
            flag = true;
        }
        return flag;
    }

    public static String checkForSpecialsType(String dataType) {
        if (ARJrpcgenHelper.checkClassForArEsControlStructChange(dataType)) {
            return "ArEsRpcControlStruct";
        }
        return ARJrpcgenHelper.checkForSpecialArrayType(dataType);
    }

    public static String checkForSpecialArrayType(String dataType) {
        if (ARJrpcgenHelper.checkSpecialArNameType(dataType, "ArNameType15")) {
            return "ArRpcNameType15";
        }
        if (ARJrpcgenHelper.checkSpecialArNameType(dataType, "ArAccessNameType15")) {
            return "ArRpcAccessNameType15";
        }
        return dataType;
    }

    static StringBuffer changeforSpecialDecode(String sIdentifier, JrpcgenDeclaration decl, StringBuffer code) {
        if (arEsControlStructChange && ARJrpcgenHelper.checkClassForArEsControlStructChange(sIdentifier)) {
            code.append("ArEsRpcControlStruct");
        } else {
            code.append(sIdentifier);
        }
        return code;
    }

    static boolean checkChangeClassType(JrpcgenDeclaration d, JrpcgenStruct s, boolean change) {
        boolean flag = false;
        if (arNameTypeChange && ARJrpcgenHelper.checkChangeArNameTypeClassType(d, s, "ArNameType15", "ArRpcNameType15", change)) {
            flag = true;
        }
        if (arNameTypeChange && ARJrpcgenHelper.checkChangeArNameTypeClassType(d, s, "ArAccessNameType15", "ArRpcAccessNameType15", change)) {
            flag = true;
        }
        return flag;
    }

    private static boolean checkChangeArNameTypeClassType(JrpcgenDeclaration d, JrpcgenStruct s, String orgClass, String newClass, boolean change) {
        boolean flag = false;
        if (arNameTypeChange && d.type.equals(orgClass)) {
            if (newClass != null && change) {
                d.type = newClass;
            }
            flag = true;
        }
        return flag;
    }

    static boolean checkChangeTypeDef(PrintWriter out, JrpcgenDeclaration d) {
        boolean flag1 = false;
        boolean flag2 = false;
        if (arNameTypeChange && ARJrpcgenHelper.checkChangeSpecialArNameTypeClassImportForTypeDef(out, d, true)) {
            flag1 = true;
        }
        if (arrpcBaseInterfaceChanges && ARJrpcgenHelper.changeArStatusListBaseClass(out, d)) {
            flag2 = true;
        }
        if (flag1 && !flag2) {
            out.print("public class " + d.identifier + " implements XdrAble");
        }
        return flag1 || flag2;
    }

    private static boolean checkChangeSpecialArNameTypeClassImportForTypeDef(PrintWriter out, JrpcgenDeclaration d, boolean change) {
        boolean flag = false;
        if (arNameTypeChange && ARJrpcgenHelper.checkSpecialArNameType(d.identifier, "ArNameList15")) {
            if (change) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcNameType15;");
            }
            flag = true;
        }
        if (arNameTypeChange && ARJrpcgenHelper.checkSpecialArNameType(d.identifier, "ArAccessNameList15")) {
            if (change) {
                out.println("import com.bmc.arsys.arrpc.xdr.ArRpcAccessNameType15;");
            }
            flag = true;
        }
        if (flag) {
            out.println("");
        }
        return flag;
    }

    static void arMoreInImportSection(PrintWriter out) {
        if (arImportArrpcPackageChange) {
            out.println("import com.bmc.arsys.arrpc.*;");
        }
    }

    static {
        arControlStructDefaultInclusivePrefixList = new ArrayList<String>();
        arControlStructDefaultInclusivePrefixList.add("ArControlStruct");
        arControlStructDefaultInclusivePrefixList.add("ArEsControlStruct");
        arStatusListInclusivePrefixList = new ArrayList<String>();
        arStatusListInclusivePrefixList.add("ArStatusList");
        arStatusStructInclusivePrefixList = new ArrayList<String>();
        arStatusStructInclusivePrefixList.add("ArStatusStruct");
        arEsControlStructDefaultInclusivePrefixList = new ArrayList<String>();
        arEsControlStructDefaultInclusivePrefixList.add("ArEsControlStruct");
    }
}

