/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;

public class OncRpcTcpSocketHelper {
    protected Socket socket;
    private Method methodSetSendBufferSize;
    private Method methodSetReceiveBufferSize;
    private Method methodGetSendBufferSize;
    private Method methodGetReceiveBufferSize;
    private Method methodConnect;
    private Constructor ctor;

    public OncRpcTcpSocketHelper(Socket socket) {
        this();
        this.socket = socket;
    }

    public OncRpcTcpSocketHelper() {
        this.inspectSocketClassMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket connect(InetAddress address, int port, int timeout) throws IOException {
        if (timeout < 0) {
            this.socket = new Socket(address, port);
            return this.socket;
        }
        if (this.methodConnect != null) {
            try {
                this.socket = (Socket)this.ctor.newInstance(new Object[0]);
                this.methodConnect.invoke((Object)this.socket, address, new Integer(timeout));
                return this.socket;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                if (!(t instanceof IllegalArgumentException)) return this.socket;
                throw (IllegalArgumentException)t;
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new SocketException(e.getMessage());
            }
        }
        Connectiator connectiator = new Connectiator(address, port);
        connectiator.start();
        Connectiator connectiator2 = connectiator;
        synchronized (connectiator2) {
            try {
                connectiator.wait(timeout);
            }
            catch (InterruptedException ie) {
                connectiator.notRequiredAnyMore();
                throw new IOException("connect interrupted");
            }
            IOException ie = connectiator.getIOException();
            if (ie != null) {
                throw ie;
            }
            this.socket = connectiator.getSocket();
            if (this.socket != null) return this.socket;
            throw new NoRouteToHostException("Operation timed out: connect");
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetSendBufferSize.invoke((Object)this.socket, new Integer(size));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                if (t instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
    }

    public int getSendBufferSize() throws SocketException {
        if (this.methodGetSendBufferSize != null) {
            try {
                Object result = this.methodGetSendBufferSize.invoke((Object)this.socket, (Object[])null);
                if (result instanceof Integer) {
                    return (Integer)result;
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                throw new SocketException(t.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
        return 65536;
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.methodSetSendBufferSize != null) {
            try {
                this.methodSetReceiveBufferSize.invoke((Object)this.socket, new Integer(size));
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                if (t instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.methodGetReceiveBufferSize != null) {
            try {
                Object result = this.methodGetReceiveBufferSize.invoke((Object)this.socket, (Object[])null);
                if (result instanceof Integer) {
                    return (Integer)result;
                }
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof SocketException) {
                    throw (SocketException)t;
                }
                throw new SocketException(t.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new SocketException(e.getMessage());
            }
        }
        return 65536;
    }

    protected void inspectSocketClassMethods() {
        Class<Socket> socketClass = Socket.class;
        try {
            this.methodSetSendBufferSize = socketClass.getMethod("setSendBufferSize", Integer.TYPE);
            this.methodGetSendBufferSize = socketClass.getMethod("getSendBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.methodSetReceiveBufferSize = socketClass.getMethod("setReceiveBufferSize", Integer.TYPE);
            this.methodGetReceiveBufferSize = socketClass.getMethod("getReceiveBufferSize", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ctor = socketClass.getConstructor(new Class[0]);
            this.methodConnect = socketClass.getMethod("connect", InetAddress.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Connectiator
    extends Thread {
        private InetAddress address;
        private int port;
        private IOException ioexception;
        private Socket socket;
        private boolean hitTheBucket = false;

        public Connectiator(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Socket mysocket = null;
            IOException myie = null;
            try {
                mysocket = new Socket(this.address, this.port);
            }
            catch (IOException ie) {
                myie = ie;
            }
            Connectiator connectiator = this;
            synchronized (connectiator) {
                this.socket = mysocket;
                this.ioexception = myie;
                this.notify();
                if (this.hitTheBucket && this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        public IOException getIOException() {
            return this.ioexception;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void notRequiredAnyMore() {
            this.hitTheBucket = true;
            try {
                this.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

