/*
 * Decompiled with CFR 0.152.
 */
package com.kaazing.gateway.client.html5.impl.wseb;

import com.kaazing.gateway.client.html5.ByteBuffer;
import com.kaazing.gateway.client.html5.impl.WebSocketChannel;
import com.kaazing.gateway.client.html5.impl.WebSocketHandlerAdapter;
import com.kaazing.gateway.client.html5.impl.wseb.CreateChannel;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandler;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandlerFactory;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandlerImpl;
import com.kaazing.gateway.client.html5.impl.wseb.CreateHandlerListener;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamChannel;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandler;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandlerFactory;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandlerImpl;
import com.kaazing.gateway.client.html5.impl.wseb.DownstreamHandlerListener;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamChannel;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandler;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandlerFactory;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandlerImpl;
import com.kaazing.gateway.client.html5.impl.wseb.UpstreamHandlerListener;
import com.kaazing.gateway.client.html5.impl.wseb.WebSocketEmulatedChannel;
import com.kaazing.gateway.client.html5.util.HttpURI;
import com.kaazing.gateway.client.html5.util.WSURI;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketEmulatedHandler
extends WebSocketHandlerAdapter {
    static final String CLASS_NAME = WebSocketEmulatedHandler.class.getName();
    static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_COOKIE = "Cookie";
    static final String HEADER_SET_COOKIE = "Set-Cookie";
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static CreateHandlerFactory createHandlerFactory = CreateHandlerImpl.FACTORY;
    static DownstreamHandlerFactory downstreamHandlerFactory = DownstreamHandlerImpl.FACTORY;
    static UpstreamHandlerFactory upstreamHandlerFactory = UpstreamHandlerImpl.FACTORY;
    private final CreateHandler createHandler = createHandlerFactory.createCreateHandler();
    private final UpstreamHandler upstreamHandler = upstreamHandlerFactory.createUpstreamHandler();
    private final DownstreamHandler downstreamHandler = downstreamHandlerFactory.createDownstreamHandler();

    public WebSocketEmulatedHandler() {
        LOG.entering(CLASS_NAME, "<init>");
        this.initCreateHandler(this.createHandler);
        this.initUpstreamHandler(this.upstreamHandler);
        this.initDownstreamHandler(this.downstreamHandler);
    }

    void initCreateHandler(CreateHandler handler) {
        handler.setListener(new CreateHandlerListener(){

            @Override
            public void createCompleted(CreateChannel channel, HttpURI upstreamUri, HttpURI downstreamUri) {
                LOG.entering(CLASS_NAME, "createCompleted");
                WebSocketEmulatedChannel parent = (WebSocketEmulatedChannel)channel.getParent();
                parent.createChannel = null;
                UpstreamChannel upstreamChannel = new UpstreamChannel(upstreamUri, channel.cookie);
                upstreamChannel.setParent(parent);
                parent.upstreamChannel = upstreamChannel;
                DownstreamChannel downstreamChannel = new DownstreamChannel(downstreamUri, channel.cookie);
                downstreamChannel.setParent(parent);
                parent.downstreamChannel = downstreamChannel;
                for (int key : channel.controlFrames.keySet()) {
                    downstreamChannel.controlFrames.put(key, channel.controlFrames.get(key));
                }
                parent.cookie = channel.cookie;
                WebSocketEmulatedHandler.this.downstreamHandler.processConnect(parent.downstreamChannel, downstreamUri, parent.getProtocol());
            }

            @Override
            public void createFailed(CreateChannel channel) {
                LOG.entering(CLASS_NAME, "createFailed");
                WebSocketEmulatedChannel parent = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.connectionFailed(parent);
            }
        });
    }

    void initUpstreamHandler(UpstreamHandler handler) {
        handler.setListener(new UpstreamHandlerListener(){

            @Override
            public void upstreamCompleted(UpstreamChannel channel) {
            }

            @Override
            public void upstreamFailed(UpstreamChannel channel) {
                if (channel == null || channel.parent == null) {
                    throw new IllegalStateException("WebSocket upstream channel already closed");
                }
                WebSocketEmulatedChannel parent = channel.parent;
                parent.upstreamChannel = null;
                WebSocketEmulatedHandler.this.doError(parent);
            }
        });
    }

    void initDownstreamHandler(DownstreamHandler handler) {
        handler.setListener(new DownstreamHandlerListener(){

            @Override
            public void downstreamOpened(DownstreamChannel channel) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.connectionOpened(wsebChannel, wsebChannel.getProtocol());
            }

            @Override
            public void messageReceived(DownstreamChannel channel, ByteBuffer data) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.messageReceived(wsebChannel, data);
            }

            @Override
            public void downstreamFailed(DownstreamChannel channel) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.connectionFailed(wsebChannel);
            }

            @Override
            public void downstreamClosed(DownstreamChannel channel) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.connectionClosed(wsebChannel);
            }
        });
    }

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI location, String protocol) {
        LOG.entering(CLASS_NAME, "connect", channel);
        String path = location.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            CreateChannel createChannel = new CreateChannel();
            createChannel.setParent(channel);
            HttpURI createUri = (HttpURI)HttpURI.replaceScheme(location, location.getHttpEquivalentScheme()).replacePath(path + "/;e/cb");
            this.createHandler.processOpen(createChannel, createUri);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.connectionFailed(channel);
        }
    }

    @Override
    public synchronized void processClose(WebSocketChannel channel) {
        LOG.entering(CLASS_NAME, "processDisconnect");
        WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel;
        this.upstreamHandler.processClose(wsebChannel.upstreamChannel);
        this.listener.connectionClosed(channel);
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String message) {
        LOG.entering(CLASS_NAME, "processTextMessage", message);
        WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel;
        this.upstreamHandler.processTextMessage(wsebChannel.upstreamChannel, message);
    }

    @Override
    public void processBinaryMessage(WebSocketChannel channel, ByteBuffer message) {
        LOG.entering(CLASS_NAME, "processBinaryMessage", message);
        WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel;
        this.upstreamHandler.processBinaryMessage(wsebChannel.upstreamChannel, message);
    }

    private void doError(WebSocketEmulatedChannel channel) {
        this.listener.connectionFailed(channel);
    }
}

