/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.ui.context.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.context.HierarchicalMessageSource;
import com.bmc.thirdparty.org.springframework.context.MessageSource;
import com.bmc.thirdparty.org.springframework.context.support.ResourceBundleMessageSource;
import com.bmc.thirdparty.org.springframework.ui.context.HierarchicalThemeSource;
import com.bmc.thirdparty.org.springframework.ui.context.Theme;
import com.bmc.thirdparty.org.springframework.ui.context.ThemeSource;
import com.bmc.thirdparty.org.springframework.ui.context.support.SimpleTheme;
import java.util.HashMap;
import java.util.Map;

public class ResourceBundleThemeSource
implements HierarchicalThemeSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ThemeSource parentThemeSource;
    private String basenamePrefix = "";
    private final Map<String, Theme> themeCache = new HashMap<String, Theme>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParentThemeSource(ThemeSource parent) {
        this.parentThemeSource = parent;
        Map<String, Theme> map = this.themeCache;
        synchronized (map) {
            for (Theme theme : this.themeCache.values()) {
                this.initParent(theme);
            }
        }
    }

    @Override
    public ThemeSource getParentThemeSource() {
        return this.parentThemeSource;
    }

    public void setBasenamePrefix(String basenamePrefix) {
        this.basenamePrefix = basenamePrefix != null ? basenamePrefix : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Theme getTheme(String themeName) {
        if (themeName == null) {
            return null;
        }
        Map<String, Theme> map = this.themeCache;
        synchronized (map) {
            Theme theme = this.themeCache.get(themeName);
            if (theme == null) {
                String basename = this.basenamePrefix + themeName;
                MessageSource messageSource = this.createMessageSource(basename);
                theme = new SimpleTheme(themeName, messageSource);
                this.initParent(theme);
                this.themeCache.put(themeName, theme);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Theme created: name '" + themeName + "', basename [" + basename + "]");
                }
            }
            return theme;
        }
    }

    protected MessageSource createMessageSource(String basename) {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename(basename);
        return messageSource;
    }

    protected void initParent(Theme theme) {
        if (theme.getMessageSource() instanceof HierarchicalMessageSource) {
            Theme parentTheme;
            HierarchicalMessageSource messageSource = (HierarchicalMessageSource)theme.getMessageSource();
            if (this.getParentThemeSource() != null && messageSource.getParentMessageSource() == null && (parentTheme = this.getParentThemeSource().getTheme(theme.getName())) != null) {
                messageSource.setParentMessageSource(parentTheme.getMessageSource());
            }
        }
    }
}

