/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scripting.groovy;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanClassLoaderAware;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.BeanFactoryAware;
import com.bmc.thirdparty.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bmc.thirdparty.org.springframework.scripting.ScriptCompilationException;
import com.bmc.thirdparty.org.springframework.scripting.ScriptFactory;
import com.bmc.thirdparty.org.springframework.scripting.ScriptSource;
import com.bmc.thirdparty.org.springframework.scripting.groovy.GroovyObjectCustomizer;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;

public class GroovyScriptFactory
implements ScriptFactory,
BeanFactoryAware,
BeanClassLoaderAware {
    private final String scriptSourceLocator;
    private final GroovyObjectCustomizer groovyObjectCustomizer;
    private GroovyClassLoader groovyClassLoader;
    private Class<?> scriptClass;
    private Class<?> scriptResultClass;
    private CachedResultHolder cachedResult;
    private final Object scriptClassMonitor = new Object();
    private boolean wasModifiedForTypeCheck = false;

    public GroovyScriptFactory(String scriptSourceLocator) {
        this(scriptSourceLocator, null);
    }

    public GroovyScriptFactory(String scriptSourceLocator, GroovyObjectCustomizer groovyObjectCustomizer) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
        this.groovyObjectCustomizer = groovyObjectCustomizer;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ((ConfigurableListableBeanFactory)beanFactory).ignoreDependencyType(MetaClass.class);
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.groovyClassLoader = new GroovyClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyClassLoader getGroovyClassLoader() {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            if (this.groovyClassLoader == null) {
                this.groovyClassLoader = new GroovyClassLoader(ClassUtils.getDefaultClassLoader());
            }
            return this.groovyClassLoader;
        }
    }

    @Override
    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    @Override
    public Class<?>[] getScriptInterfaces() {
        return null;
    }

    @Override
    public boolean requiresConfigInterface() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getScriptedObject(ScriptSource scriptSource, Class<?> ... actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            Class<?> scriptClassToExecute;
            Object object = this.scriptClassMonitor;
            synchronized (object) {
                this.wasModifiedForTypeCheck = false;
                if (this.cachedResult != null) {
                    Object result = this.cachedResult.object;
                    this.cachedResult = null;
                    return result;
                }
                if (this.scriptClass == null || scriptSource.isModified()) {
                    this.scriptClass = this.getGroovyClassLoader().parseClass(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
                    if (Script.class.isAssignableFrom(this.scriptClass)) {
                        Object result = this.executeScript(scriptSource, this.scriptClass);
                        this.scriptResultClass = result != null ? result.getClass() : null;
                        return result;
                    }
                    this.scriptResultClass = this.scriptClass;
                }
                scriptClassToExecute = this.scriptClass;
            }
            return this.executeScript(scriptSource, scriptClassToExecute);
        }
        catch (CompilationFailedException ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        try {
            Object object = this.scriptClassMonitor;
            synchronized (object) {
                if (this.scriptClass == null || scriptSource.isModified()) {
                    this.wasModifiedForTypeCheck = true;
                    this.scriptClass = this.getGroovyClassLoader().parseClass(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
                    if (Script.class.isAssignableFrom(this.scriptClass)) {
                        Object result = this.executeScript(scriptSource, this.scriptClass);
                        this.scriptResultClass = result != null ? result.getClass() : null;
                        this.cachedResult = new CachedResultHolder(result);
                    } else {
                        this.scriptResultClass = this.scriptClass;
                    }
                }
                return this.scriptResultClass;
            }
        }
        catch (CompilationFailedException ex) {
            throw new ScriptCompilationException(scriptSource, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            return scriptSource.isModified() || this.wasModifiedForTypeCheck;
        }
    }

    protected Object executeScript(ScriptSource scriptSource, Class<?> scriptClass) throws ScriptCompilationException {
        try {
            GroovyObject goo = (GroovyObject)scriptClass.newInstance();
            if (this.groovyObjectCustomizer != null) {
                this.groovyObjectCustomizer.customize(goo);
            }
            if (goo instanceof Script) {
                return ((Script)goo).run();
            }
            return goo;
        }
        catch (InstantiationException ex) {
            throw new ScriptCompilationException(scriptSource, "Could not instantiate Groovy script class: " + scriptClass.getName(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ScriptCompilationException(scriptSource, "Could not access Groovy script constructor: " + scriptClass.getName(), ex);
        }
    }

    public String toString() {
        return "GroovyScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }

    private static class CachedResultHolder {
        public final Object object;

        public CachedResultHolder(Object object) {
            this.object = object;
        }
    }
}

