/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scripting.config;

import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.TypedStringValue;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.BeanDefinitionParser;
import com.bmc.thirdparty.org.springframework.beans.factory.xml.ParserContext;
import com.bmc.thirdparty.org.springframework.scripting.config.LangNamespaceUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ScriptingDefaultsParser
implements BeanDefinitionParser {
    private static final String REFRESH_CHECK_DELAY_ATTRIBUTE = "refresh-check-delay";
    private static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";

    @Override
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String proxyTargetClass;
        BeanDefinition bd = LangNamespaceUtils.registerScriptFactoryPostProcessorIfNecessary(parserContext.getRegistry());
        String refreshCheckDelay = element.getAttribute(REFRESH_CHECK_DELAY_ATTRIBUTE);
        if (StringUtils.hasText(refreshCheckDelay)) {
            bd.getPropertyValues().add("defaultRefreshCheckDelay", new Long(refreshCheckDelay));
        }
        if (StringUtils.hasText(proxyTargetClass = element.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE))) {
            bd.getPropertyValues().add("defaultProxyTargetClass", new TypedStringValue(proxyTargetClass, Boolean.class));
        }
        return null;
    }
}

