/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.format.number;

import com.bmc.thirdparty.org.springframework.context.support.EmbeddedValueResolutionSupport;
import com.bmc.thirdparty.org.springframework.format.AnnotationFormatterFactory;
import com.bmc.thirdparty.org.springframework.format.Formatter;
import com.bmc.thirdparty.org.springframework.format.Parser;
import com.bmc.thirdparty.org.springframework.format.Printer;
import com.bmc.thirdparty.org.springframework.format.annotation.NumberFormat;
import com.bmc.thirdparty.org.springframework.format.number.CurrencyFormatter;
import com.bmc.thirdparty.org.springframework.format.number.NumberFormatter;
import com.bmc.thirdparty.org.springframework.format.number.PercentFormatter;
import com.bmc.thirdparty.org.springframework.util.NumberUtils;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.util.Set;

public class NumberFormatAnnotationFormatterFactory
extends EmbeddedValueResolutionSupport
implements AnnotationFormatterFactory<NumberFormat> {
    @Override
    public Set<Class<?>> getFieldTypes() {
        return NumberUtils.STANDARD_NUMBER_TYPES;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation);
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation) {
        if (StringUtils.hasLength(annotation.pattern())) {
            return new NumberFormatter(this.resolveEmbeddedValue(annotation.pattern()));
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentFormatter();
        }
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyFormatter();
        }
        return new NumberFormatter();
    }
}

