/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.annotation;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.config.BeanDefinition;
import com.bmc.thirdparty.org.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bmc.thirdparty.org.springframework.context.annotation.Bean;
import com.bmc.thirdparty.org.springframework.context.annotation.ComponentScan;
import com.bmc.thirdparty.org.springframework.context.annotation.Configuration;
import com.bmc.thirdparty.org.springframework.context.annotation.ConfigurationClassPostProcessor;
import com.bmc.thirdparty.org.springframework.context.annotation.Import;
import com.bmc.thirdparty.org.springframework.context.annotation.ImportResource;
import com.bmc.thirdparty.org.springframework.core.Conventions;
import com.bmc.thirdparty.org.springframework.core.type.AnnotationMetadata;
import com.bmc.thirdparty.org.springframework.core.type.StandardAnnotationMetadata;
import com.bmc.thirdparty.org.springframework.core.type.classreading.MetadataReader;
import com.bmc.thirdparty.org.springframework.core.type.classreading.MetadataReaderFactory;
import com.bmc.thirdparty.org.springframework.stereotype.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

abstract class ConfigurationClassUtils {
    private static final String CONFIGURATION_CLASS_FULL = "full";
    private static final String CONFIGURATION_CLASS_LITE = "lite";
    private static final String CONFIGURATION_CLASS_ATTRIBUTE = Conventions.getQualifiedAttributeName(ConfigurationClassPostProcessor.class, "configurationClass");
    private static final Log logger = LogFactory.getLog(ConfigurationClassUtils.class);
    private static final Set<String> candidateIndicators = new HashSet<String>(4);

    ConfigurationClassUtils() {
    }

    public static boolean checkConfigurationClassCandidate(BeanDefinition beanDef, MetadataReaderFactory metadataReaderFactory) {
        AnnotationMetadata metadata;
        String className = beanDef.getBeanClassName();
        if (className == null) {
            return false;
        }
        if (beanDef instanceof AnnotatedBeanDefinition && className.equals(((AnnotatedBeanDefinition)beanDef).getMetadata().getClassName())) {
            metadata = ((AnnotatedBeanDefinition)beanDef).getMetadata();
        } else if (beanDef instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)beanDef).hasBeanClass()) {
            Class<?> beanClass = ((AbstractBeanDefinition)beanDef).getBeanClass();
            metadata = new StandardAnnotationMetadata(beanClass, true);
        } else {
            try {
                MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(className);
                metadata = metadataReader.getAnnotationMetadata();
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not find class file for introspecting configuration annotations: " + className, ex);
                }
                return false;
            }
        }
        if (ConfigurationClassUtils.isFullConfigurationCandidate(metadata)) {
            beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, CONFIGURATION_CLASS_FULL);
            return true;
        }
        if (ConfigurationClassUtils.isLiteConfigurationCandidate(metadata)) {
            beanDef.setAttribute(CONFIGURATION_CLASS_ATTRIBUTE, CONFIGURATION_CLASS_LITE);
            return true;
        }
        return false;
    }

    public static boolean isConfigurationCandidate(AnnotationMetadata metadata) {
        return ConfigurationClassUtils.isFullConfigurationCandidate(metadata) || ConfigurationClassUtils.isLiteConfigurationCandidate(metadata);
    }

    public static boolean isFullConfigurationCandidate(AnnotationMetadata metadata) {
        return metadata.isAnnotated(Configuration.class.getName());
    }

    public static boolean isLiteConfigurationCandidate(AnnotationMetadata metadata) {
        if (metadata.isInterface()) {
            return false;
        }
        for (String indicator : candidateIndicators) {
            if (!metadata.isAnnotated(indicator)) continue;
            return true;
        }
        return metadata.hasAnnotatedMethods(Bean.class.getName());
    }

    public static boolean isFullConfigurationClass(BeanDefinition beanDef) {
        return CONFIGURATION_CLASS_FULL.equals(beanDef.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE));
    }

    public static boolean isLiteConfigurationClass(BeanDefinition beanDef) {
        return CONFIGURATION_CLASS_LITE.equals(beanDef.getAttribute(CONFIGURATION_CLASS_ATTRIBUTE));
    }

    static {
        candidateIndicators.add(Component.class.getName());
        candidateIndicators.add(ComponentScan.class.getName());
        candidateIndicators.add(Import.class.getName());
        candidateIndicators.add(ImportResource.class.getName());
    }
}

