/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.antlr.runtime.debug;

import com.bmc.thirdparty.org.antlr.runtime.RecognitionException;
import com.bmc.thirdparty.org.antlr.runtime.Token;
import com.bmc.thirdparty.org.antlr.runtime.debug.DebugEventListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.StringTokenizer;

public class RemoteDebugEventSocketListener
implements Runnable {
    static final int MAX_EVENT_ELEMENTS = 8;
    DebugEventListener listener;
    String machine;
    int port;
    Socket channel = null;
    PrintWriter out;
    BufferedReader in;
    String event;
    public String version;
    public String grammarFileName;
    int previousTokenIndex = -1;
    boolean tokenIndexesInvalid = false;

    public RemoteDebugEventSocketListener(DebugEventListener debugEventListener, String string, int n) throws IOException {
        this.listener = debugEventListener;
        this.machine = string;
        this.port = n;
        if (!this.openConnection()) {
            throw new ConnectException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventHandler() {
        try {
            this.handshake();
            this.event = this.in.readLine();
            while (this.event != null) {
                this.dispatch(this.event);
                this.ack();
                this.event = this.in.readLine();
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        finally {
            this.closeConnection();
        }
    }

    protected boolean openConnection() {
        boolean bl = false;
        try {
            this.channel = new Socket(this.machine, this.port);
            this.channel.setTcpNoDelay(true);
            OutputStream outputStream = this.channel.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            InputStream inputStream = this.channel.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this.in = new BufferedReader(inputStreamReader);
            bl = true;
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection() {
        try {
            this.in.close();
            this.in = null;
            this.out.close();
            this.out = null;
            this.channel.close();
            this.channel = null;
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
    }

    protected void handshake() throws IOException {
        String string = this.in.readLine();
        String[] stringArray = this.getEventElements(string);
        this.version = stringArray[1];
        String string2 = this.in.readLine();
        String[] stringArray2 = this.getEventElements(string2);
        this.grammarFileName = stringArray2[1];
        this.ack();
        this.listener.commence();
    }

    protected void ack() {
        this.out.println("ack");
        this.out.flush();
    }

    protected void dispatch(String string) {
        String[] stringArray = this.getEventElements(string);
        if (stringArray == null || stringArray[0] == null) {
            System.err.println("unknown debug event: " + string);
            return;
        }
        if (stringArray[0].equals("enterRule")) {
            this.listener.enterRule(stringArray[1]);
        } else if (stringArray[0].equals("exitRule")) {
            this.listener.exitRule(stringArray[1]);
        } else if (stringArray[0].equals("enterAlt")) {
            this.listener.enterAlt(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("enterSubRule")) {
            this.listener.enterSubRule(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("exitSubRule")) {
            this.listener.exitSubRule(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("enterDecision")) {
            this.listener.enterDecision(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("exitDecision")) {
            this.listener.exitDecision(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("location")) {
            this.listener.location(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("consumeToken")) {
            ProxyToken proxyToken = this.deserializeToken(stringArray, 1);
            if (proxyToken.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = proxyToken.getTokenIndex();
            this.listener.consumeToken(proxyToken);
        } else if (stringArray[0].equals("consumeHiddenToken")) {
            ProxyToken proxyToken = this.deserializeToken(stringArray, 1);
            if (proxyToken.getTokenIndex() == this.previousTokenIndex) {
                this.tokenIndexesInvalid = true;
            }
            this.previousTokenIndex = proxyToken.getTokenIndex();
            this.listener.consumeHiddenToken(proxyToken);
        } else if (stringArray[0].equals("LT")) {
            ProxyToken proxyToken = this.deserializeToken(stringArray, 2);
            this.listener.LT(Integer.parseInt(stringArray[1]), proxyToken);
        } else if (stringArray[0].equals("mark")) {
            this.listener.mark(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("rewind")) {
            if (stringArray[1] != null) {
                this.listener.rewind(Integer.parseInt(stringArray[1]));
            } else {
                this.listener.rewind();
            }
        } else if (stringArray[0].equals("beginBacktrack")) {
            this.listener.beginBacktrack(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("endBacktrack")) {
            int n = Integer.parseInt(stringArray[1]);
            int n2 = Integer.parseInt(stringArray[2]);
            this.listener.endBacktrack(n, n2 == 1);
        } else if (stringArray[0].equals("exception")) {
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            String string4 = stringArray[3];
            String string5 = stringArray[4];
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string2);
                RecognitionException recognitionException = (RecognitionException)clazz.newInstance();
                recognitionException.index = Integer.parseInt(string3);
                recognitionException.line = Integer.parseInt(string4);
                recognitionException.charPositionInLine = Integer.parseInt(string5);
                this.listener.recognitionException(recognitionException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("can't find class " + classNotFoundException);
                classNotFoundException.printStackTrace(System.err);
            }
            catch (InstantiationException instantiationException) {
                System.err.println("can't instantiate class " + instantiationException);
                instantiationException.printStackTrace(System.err);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.err.println("can't access class " + illegalAccessException);
                illegalAccessException.printStackTrace(System.err);
            }
        } else if (stringArray[0].equals("beginResync")) {
            this.listener.beginResync();
        } else if (stringArray[0].equals("endResync")) {
            this.listener.endResync();
        } else if (stringArray[0].equals("terminate")) {
            this.listener.terminate();
        } else if (stringArray[0].equals("semanticPredicate")) {
            Boolean bl = Boolean.valueOf(stringArray[1]);
            String string6 = stringArray[2];
            string6 = this.unEscapeNewlines(string6);
            this.listener.semanticPredicate(bl, string6);
        } else if (stringArray[0].equals("consumeNode")) {
            String string7 = stringArray[3];
            string7 = this.unEscapeNewlines(string7);
            this.listener.consumeNode(Integer.parseInt(stringArray[1]), string7, Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("LN")) {
            String string8 = stringArray[4];
            string8 = this.unEscapeNewlines(string8);
            this.listener.LT(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), string8, Integer.parseInt(stringArray[3]));
        } else if (stringArray[0].equals("createNodeFromToken")) {
            String string9 = stringArray[3];
            string9 = this.unEscapeNewlines(string9);
            this.listener.createNode(Integer.parseInt(stringArray[1]), string9, Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("createNode")) {
            this.listener.createNode(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("nilNode")) {
            this.listener.nilNode(Integer.parseInt(stringArray[1]));
        } else if (stringArray[0].equals("becomeRoot")) {
            this.listener.becomeRoot(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("addChild")) {
            this.listener.addChild(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        } else if (stringArray[0].equals("setTokenBoundaries")) {
            this.listener.setTokenBoundaries(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
        } else {
            System.err.println("unknown debug event: " + string);
        }
    }

    protected ProxyToken deserializeToken(String[] stringArray, int n) {
        String string = stringArray[n + 0];
        String string2 = stringArray[n + 1];
        String string3 = stringArray[n + 2];
        String string4 = stringArray[n + 3];
        String string5 = stringArray[n + 4];
        String string6 = stringArray[n + 5];
        string6 = this.unEscapeNewlines(string6);
        int n2 = Integer.parseInt(string);
        ProxyToken proxyToken = new ProxyToken(n2, Integer.parseInt(string2), Integer.parseInt(string3), Integer.parseInt(string4), Integer.parseInt(string5), string6);
        return proxyToken;
    }

    public void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.eventHandler();
    }

    public String[] getEventElements(String object) {
        if (object == null) {
            return null;
        }
        String[] stringArray = new String[8];
        String string = null;
        try {
            Object object2;
            int n = ((String)object).indexOf(34);
            if (n >= 0) {
                object2 = ((String)object).substring(0, n);
                string = ((String)object).substring(n + 1, ((String)object).length());
                object = object2;
            }
            object2 = new StringTokenizer((String)object, " \t", false);
            int n2 = 0;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                stringArray[n2] = ((StringTokenizer)object2).nextToken();
                ++n2;
            }
            if (string != null) {
                stringArray[n2] = string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return stringArray;
    }

    protected String unEscapeNewlines(String string) {
        string = string.replaceAll("%0A", "\n");
        string = string.replaceAll("%0D", "\r");
        string = string.replaceAll("%25", "%");
        return string;
    }

    public boolean tokenIndexesAreInvalid() {
        return false;
    }

    public static class ProxyToken
    implements Token {
        int index;
        int type;
        int channel;
        int line;
        int charPos;
        String text;

        public ProxyToken(int n, int n2, int n3, int n4, int n5, String string) {
            this.index = n;
            this.type = n2;
            this.channel = n3;
            this.line = n4;
            this.charPos = n5;
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String string) {
            this.text = string;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int n) {
            this.line = n;
        }

        public int getCharPositionInLine() {
            return this.charPos;
        }

        public void setCharPositionInLine(int n) {
            this.charPos = n;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int n) {
            this.channel = n;
        }

        public int getTokenIndex() {
            return this.index;
        }

        public void setTokenIndex(int n) {
            this.index = n;
        }

        public String toString() {
            String string = "";
            if (this.channel > 0) {
                string = ",channel=" + this.channel;
            }
            return "[" + this.getText() + "/<" + this.type + ">" + string + "," + this.line + ":" + this.getCharPositionInLine() + "]";
        }
    }
}

