/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.devutility.mapping;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileUtils {
    public static PrintWriter createFile(String filename, String outputDir, boolean createBackups) throws IOException {
        File file;
        File destinationDir = new File(outputDir);
        if (!destinationDir.exists()) {
            destinationDir.mkdir();
        }
        if ((file = new File(destinationDir, filename)).exists() && createBackups) {
            File oldBackup;
            if (!file.isFile()) {
                System.err.println("error: source file \"" + filename + "\"already exists and is not a regular file");
                System.exit(1);
            }
            if ((oldBackup = new File(destinationDir, filename + "~")).isFile()) {
                oldBackup.delete();
            } else if (oldBackup.exists()) {
                System.err.println("error: backup source file \"" + filename + "~\" is not a regular file");
                System.exit(1);
            }
            if (!file.renameTo(new File(destinationDir, filename + "~"))) {
                System.err.println("error: can not rename old source code file \"" + filename + "\"");
                System.exit(1);
            }
        }
        PrintWriter out = new PrintWriter((Writer)new FileWriter(file), true);
        return out;
    }

    public static PrintWriter createJavaSourceFile(String classname, String outputDir, boolean createBackups) throws IOException {
        String filename = classname + ".java";
        PrintWriter out = FileUtils.createFile(filename, outputDir, createBackups);
        out.println("/*");
        out.println(" * Automatically generated by AR mapping utility on " + new SimpleDateFormat().format(new Date()));
        out.println(" *");
        out.println(" * @author Jiayi Gu");
        out.println(" *");
        out.println(" */");
        if (classname.startsWith("Proxy")) {
            out.println("package com.bmc.arsys.api;");
            out.println("");
            out.println("import java.util.ArrayList;");
            out.println("import java.util.List;");
            out.println("");
            out.println("import com.bmc.arsys.arrpc.*;");
            out.println("import com.bmc.arsys.api.internal.*;");
            out.println("import com.bmc.arsys.utils.ARConstantsBase;");
            out.println("import com.bmc.arsys.utils.CatalogReader;");
            out.println("");
            out.println("class ProxyJRpc extends ProxyJRpcBase {");
            out.println("");
        } else if (classname.startsWith("RpcConverter")) {
            out.println("package com.bmc.arsys.api;");
            out.println("");
            out.println("import java.util.ArrayList;");
            out.println("import java.util.Iterator;");
            out.println("import java.util.List;");
            out.println("import java.util.Map;");
            out.println("import java.util.TreeMap;");
            out.println("import java.util.Set;");
            out.println("import java.math.BigDecimal;");
            out.println("import java.sql.Date;");
            out.println("import com.bmc.arsys.arrpc.*;");
            out.println("");
            out.println("abstract class " + classname + "{");
            out.println("");
            out.println("    protected boolean isExtendingClassRegistered(ARServerUser context, Class clazz){");
            out.println("        return ((context != null) && (context.getExtendedClassRegistry() != null)");
            out.println("                && context.getExtendedClassRegistry().isExtendingClassRegistered(clazz));");
            out.println("    }");
            out.println("");
        } else {
            out.println("package com.bmc.arsys.api;");
            out.println("");
            out.println("public class " + classname + "{");
            out.println("");
        }
        return out;
    }
}

