/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.alert;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AlertCallbackHandler;
import com.bmc.arsys.api.AlertMessageInfo;
import com.bmc.arsys.api.AlertReceiver;
import java.text.SimpleDateFormat;

public class AlertReceiverTest
implements AlertCallbackHandler {
    int alertReceivedCount = 0;
    private String user;
    private String password = "";
    private String server;
    private int port = 0;
    private String locale = "";

    @Override
    public void onAlertRecieved(AlertMessageInfo alertMsg) {
        try {
            System.out.println("Object ID:\t" + alertMsg.getObjectId());
            System.out.println("Priority:\t" + alertMsg.getPriority());
            System.out.println("Form Name:\t" + alertMsg.getFormName());
            System.out.println("Source Type:\t" + alertMsg.getSourceType());
            System.out.println("Message:\t" + alertMsg.getAlertText());
            SimpleDateFormat formater = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss a");
            System.out.println("Date:\t\t" + formater.format(alertMsg.getTimestamp().toDate()));
            System.out.println("******************************************");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.alertReceivedCount;
    }

    static void printUsage() {
        System.out.println("Usage:");
        System.out.println("AlertReceiverTest -u $USER -p $PASSWORD -s $SERVER -t $PORT -l $LOCALE");
        System.out.println("where -u   :User name");
        System.out.println("where -p   :User password (Optional)");
        System.out.println("where -s   :Server name");
        System.out.println("where -t   :Server Port (Optional)");
        System.out.println("where -l   :Locale (Optional)");
        System.out.println("example: AlertReceiverTest -u Demo -s localhost");
        System.exit(0);
    }

    public void processCommandLineArgs(String[] args) {
        if (args == null || args.length < 2) {
            AlertReceiverTest.printUsage();
        }
        int argc = 0;
        String tempPtr = null;
        if (args != null) {
            argc = args.length;
        }
        block9: for (int i = 0; i < argc; ++i) {
            if (args[i].charAt(0) != '-' || args[i].charAt(1) != 'u' && args[i].charAt(1) != 'p' && args[i].charAt(1) != 's' && args[i].charAt(1) != 't' && args[i].charAt(1) != 'l') {
                if (args[i].equals("-help")) {
                    AlertReceiverTest.printUsage();
                    return;
                }
                System.out.println("Unrecognized option " + args[i] + "\n");
                AlertReceiverTest.printUsage();
                return;
            }
            char option = args[i].charAt(1);
            if (args[i].length() > 2) {
                int cmdLength = args[i].length() - 2;
                char[] tempCmd = new char[cmdLength];
                args[i].getChars(2, args[i].length(), tempCmd, 0);
                tempPtr = new String(tempCmd);
            } else if (++i < argc) {
                tempPtr = args[i];
            } else {
                System.out.println("Missing value for -" + option + "  option\n");
                AlertReceiverTest.printUsage();
            }
            switch (option) {
                case 'u': {
                    this.user = tempPtr;
                    continue block9;
                }
                case 'p': {
                    this.password = tempPtr;
                    continue block9;
                }
                case 's': {
                    this.server = tempPtr;
                    continue block9;
                }
                case 't': {
                    try {
                        this.port = Integer.parseInt(tempPtr);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Invalid Port Number:" + tempPtr);
                        AlertReceiverTest.printUsage();
                    }
                    continue block9;
                }
                case 'l': {
                    this.locale = tempPtr;
                }
            }
        }
        if (this.user == null || this.user.trim().equals("")) {
            System.out.println("User name is mandatory!");
            AlertReceiverTest.printUsage();
        }
        if (this.server == null || this.server.trim().equals("")) {
            System.out.println("Server name is mandatory!");
            AlertReceiverTest.printUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recieveAlerts() {
        ARServerUser svr = new ARServerUser(this.user, this.password, this.locale, this.server, this.port);
        boolean rcv = false;
        AlertReceiver receiver = null;
        try {
            receiver = new AlertReceiver(this);
            rcv = receiver.beginReceive(svr);
            if (rcv) {
                System.out.println("Waiting to receive alerts from " + svr.getServer() + " for user:" + svr.getUser());
                while (true) {
                    Thread.sleep(10000L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (receiver != null) {
                if (rcv) {
                    try {
                        receiver.stopReceive(svr);
                    }
                    catch (Exception exception) {}
                    System.out.println("Stopped receiving alerts from " + svr.getServer() + " for user:" + svr.getUser());
                    System.out.println("Total alerts received:" + this.alertReceivedCount);
                }
                try {
                    receiver.close();
                }
                catch (Exception exception) {}
                receiver = null;
            }
        }
    }

    public static void main(String[] args) {
        AlertReceiverTest receiver = new AlertReceiverTest();
        receiver.processCommandLineArgs(args);
        receiver.recieveAlerts();
    }
}

