/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.rpcext;

import com.bmc.arsys.arrpc.rpcext.ArSoftByteArrayManager;
import com.bmc.arsys.arrpc.rpcext.ArXdrTcpEncodingStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.acplt.oncrpc.ArNetworkSocket;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ArFlexXdrTcpEncodingStream
extends ArXdrTcpEncodingStream {
    private static Logger log = Logger.getLogger(ArFlexXdrTcpEncodingStream.class);
    protected int maxResponseSize = 500000;
    protected int maxXdrEncodingStreamSize = 500128;
    protected int minXdrEncodingStreamSize = 4096;
    protected int marginSize = 1152;
    private boolean useFlexXdrStreamBuffer;

    public ArFlexXdrTcpEncodingStream(ArNetworkSocket streamingSocket, int bufferSize) throws IOException {
        super(streamingSocket, ArSoftByteArrayManager.get(bufferSize, true));
    }

    @Override
    protected byte[] arEncAfterXdrEncoding(byte[] arBuffer) throws OncRpcException, IOException {
        byte[] xdrHeader;
        if (this.isArProcessOn() && this.isEncodingProcessReady() && this.isDataNotInXdrBuffer() && (xdrHeader = this.getHeaderBuf()) != null) {
            int newBuffIndex = xdrHeader.length + arBuffer.length;
            int len = newBuffIndex + 4 + 128;
            if (log.isTraceEnabled()) {
                log.trace("+++++++ArFlexXdrTcpEncodingStream.arEncAfterXdrEncoding() xdrHeader.length=" + xdrHeader.length + " arBuffer.length=" + arBuffer.length + " Buffer len changed to " + len + " bytes ");
            }
            if (!this.isArEncryptionOn()) {
                ByteBuffer newBuffer = ByteBuffer.allocate(len);
                newBuffer.put(xdrHeader);
                newBuffer.put(arBuffer);
                byte[] highMark = Integer.toString(newBuffIndex).getBytes();
                newBuffer.put(Integer.toString(newBuffIndex).getBytes());
                if (highMark != null && highMark.length < 4) {
                    if (log.isTraceEnabled()) {
                        log.trace("++++++highMark.length = " + highMark.length);
                    }
                    byte[] padding = new byte[4 - highMark.length];
                    newBuffer.put(padding);
                }
                this.replaceBuffer(newBuffer.array());
                this.setBufferIndex(newBuffIndex);
                this.setBufferHighmark(len - 4);
            }
        }
        return this.getBuffer();
    }

    public int changeBufferIfNeeded(int dataLen, boolean keepHeading) {
        int newBufferLen = 0;
        if (dataLen == 0 || !this.isUseFlexXdrStreamBuffer() || !this.isArProcessOn()) {
            return 0;
        }
        int orgBufferBeginIndex = this.getBufferIndex();
        int orgBufLen = this.getBufferSize();
        if (keepHeading) {
            orgBufLen = this.getBuffer().length;
        }
        if (this.isXdrTcpStreamResizeNeeded(dataLen, orgBufLen, keepHeading ? this.getMinXdrEncodingStreamSize() : this.getMarginSize(), 128) && (newBufferLen = this.determinNewBufferLen(dataLen)) != orgBufLen && newBufferLen <= this.getMaxXdrEncodingStreamSize()) {
            if (log.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append(" sending buffer change from ").append(orgBufLen).append(" to :" + newBufferLen).append(" bytes");
                log.trace(msg.toString());
            }
            byte[] minBuffer = ArSoftByteArrayManager.get(newBufferLen, newBufferLen + this.minXdrEncodingStreamSize, true);
            newBufferLen = minBuffer.length;
            if (keepHeading) {
                byte[] xdrHeader = this.getHeaderBuf();
                if (xdrHeader != null) {
                    newBufferLen = xdrHeader.length + newBufferLen;
                    ByteBuffer newBuffer = ByteBuffer.allocate(newBufferLen);
                    newBuffer.put(xdrHeader);
                    newBuffer.put(minBuffer);
                    this.replaceBuffer(newBuffer.array());
                } else {
                    this.replaceBuffer(minBuffer);
                }
            } else {
                this.replaceBuffer(minBuffer);
            }
            this.setBufferIndex(orgBufferBeginIndex);
            this.setBufferHighmark(newBufferLen - 4);
        }
        return newBufferLen;
    }

    private int determinNewBufferLen(int dataLen) {
        return dataLen + 128;
    }

    private boolean isXdrTcpStreamResizeNeeded(int arRequiredXdrSize, int currentXdrStreamSize, int minXdrStreamSize, int marginSize) {
        boolean neededFlag = true;
        if (currentXdrStreamSize == 0) {
            return neededFlag;
        }
        if (!this.isArProcessOn() || !this.isUseFlexXdrStreamBuffer()) {
            neededFlag = false;
        } else if (arRequiredXdrSize == currentXdrStreamSize || arRequiredXdrSize < currentXdrStreamSize && arRequiredXdrSize + marginSize >= currentXdrStreamSize) {
            neededFlag = false;
        }
        return neededFlag;
    }

    protected boolean isEncodingProcessReady() {
        return false;
    }

    int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
        this.setMaxXdrEncodingStreamSize(maxResponseSize + 128);
    }

    int getMinXdrEncodingStreamSize() {
        return this.minXdrEncodingStreamSize;
    }

    void setMinXdrEncodingStreamSize(int minXdrEncodingStreamSize) {
        this.minXdrEncodingStreamSize = minXdrEncodingStreamSize;
    }

    boolean isUseFlexXdrStreamBuffer() {
        return this.useFlexXdrStreamBuffer;
    }

    void setUseFlexXdrStreamBuffer(boolean useFlexXdrStreamBuffer) {
        this.useFlexXdrStreamBuffer = useFlexXdrStreamBuffer;
    }

    int getMarginSize() {
        return this.marginSize;
    }

    int getMaxXdrEncodingStreamSize() {
        return this.maxXdrEncodingStreamSize;
    }

    void setMaxXdrEncodingStreamSize(int maxXdrEncodingStreamSize) {
        this.maxXdrEncodingStreamSize = maxXdrEncodingStreamSize;
    }

    @Override
    protected void replaceBuffer(byte[] newBuffer) {
        ArSoftByteArrayManager.release(super.getBufferArray());
        super.replaceBuffer(newBuffer);
    }
}

